<?php
/**
 * Button X
 *
 * This file is used to register main functionality of the plugin.
 *
 * @package Buttons X
 * @since 0.1
 */
// Make sure we don't expose any info if called directly
if ( !defined( 'ABSPATH' ) )
	exit;

if( !class_exists( 'Btnsx' ) ) {

	class Btnsx {

		private static $instance;

		public $overrides;

		/**
		 * Initiator
		 * @since 0.1
		 */
		public static function init(){
			return self::$instance;
		}

		/**
		 * Constructor
		 * @since 0.1
		 */
		public function __construct() {
			// define override classes array
			$this->overrides = array(
				'woocommerce' => array(
					'normal' =>	'.woocommerce #content input.button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce-page #content input.button, .woocommerce-page #respond input#submit, .woocommerce-page a.button, .woocommerce-page button.button, .woocommerce-page input.button, .woocommerce ul.products a.button',
					'hover'	=> '.woocommerce #content input.button:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce-page #content input.button:hover, .woocommerce-page #respond input#submit:hover, .woocommerce-page a.button:hover, .woocommerce-page button.button:hover, .woocommerce-page input.button:hover, .woocommerce ul.products a.button:hover'
				),
				'woocommerce_alt' => array(
					'normal' =>	'.woocommerce #content input.button.alt, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce-page #content input.button.alt, .woocommerce-page #respond input#submit.alt, .woocommerce-page a.button.alt, .woocommerce-page button.button.alt, .woocommerce-page input.button.alt',
					'hover'	=> '.woocommerce #content input.button.alt:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce-page #content input.button.alt:hover, .woocommerce-page #respond input#submit.alt:hover, .woocommerce-page a.button.alt:hover, .woocommerce-page button.button.alt:hover, .woocommerce-page input.button.alt:hover'
				),
				'contact_form_7' => array(
					'normal' =>	'.wpcf7-submit',
					'hover'	=> '.wpcf7-submit:hover'
				),
				'caldera_form' => array(
					'normal' =>	'.caldera-grid .btn-default',
					'hover'	=> '.caldera-grid .btn-default:hover'
				),
				'ninja_form' => array(
					'normal' =>	'.ninja-forms-form .submit-wrap .ninja-forms-field',
					'hover'	=> '.ninja-forms-form .submit-wrap .ninja-forms-field:hover'
				),
				'jetpack_subscribe_widget' => array(
					'normal' =>	'input[name="jetpack_subscriptions_widget"]',
					'hover'	=> 'input[name="jetpack_subscriptions_widget"]:hover'
				),
				'formidable_form' => array(
					'normal' =>	'.frm_forms .frm_submit > input',
					'hover'	=> '.frm_forms .frm_submit > input:hover'
				),
			);
			add_action( 'plugins_loaded', array( $this, 'load_textdomain' ) );
			global $wp_version, $btnsx_settings;
			// execute code if minimum wp version is 4 n above else throw notice
			if ( $wp_version >= BTNSX__MIN_WP_VERSION ) {
				require_once( BTNSX__PLUGIN_DIR . 'includes/class.btnsx.form.design.php' );
				require_once( BTNSX__PLUGIN_DIR . 'includes/class.btnsx.form.php' );
				// admin functionality
				add_filter( 'post_row_actions', array( $this, 'row_actions' ), 10, 2 );
				add_filter( 'manage_buttons-x_posts_columns', array( $this, 'columns' ) );
				add_action( 'manage_buttons-x_posts_custom_column', array( $this, 'column_preview' ), 10, 2);
				add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) , 50 );
	            add_action( 'init', array( $this, 'register_cpt' ), 1 );
	            add_action( 'init', array( $this, 'register_taxonomies' ) );
	            add_action( 'add_meta_boxes', array( $this, 'register_meta_boxes' ) );
	            add_action( 'do_meta_boxes', array( $this, 'remove_extra_meta_boxes' ) );
	            add_filter( 'post_updated_messages', array( $this, 'updated_messages' ) );
	            add_action( 'save_post_buttons-x', array( $this, 'save_data' ) );
				add_action( 'admin_menu', array( $this, 'register_settings_page' ) );
				add_action( 'admin_init', array( $this, 'register_settings' ) );
				add_action( 'wp_ajax_dropdown_menu', array( $this, 'dropdown_menu_ajax' ) );
				add_action( 'admin_head', array( $this, 'preview_menu_jquery' ) );
				add_action( 'admin_head', array( $this, 'logo_style' ) );
				add_action( 'post_submitbox_misc_actions', array( $this, 'publishing_actions' ) );
	            // public functionality
	            add_action( 'wp_enqueue_scripts', array( $this, 'public_enqueue_scripts' ), 101 );
	            add_shortcode( 'btnsx' , array( $this, 'shortcode' ) );
				if( isset( $btnsx_settings[ 'css' ] ) && $btnsx_settings[ 'css' ] === 'external' ){
					add_action( 'save_post_buttons-x', array( $this, 'create_directory' ) );
					add_action( 'save_post_buttons-x', array( $this, 'print_css' ) );
					add_action( 'delete_post', array( $this, 'remove_css') );
				}
				add_action( 'wp_head', array( $this, 'override_style_inline' ), 51 );
				add_action( 'init', array( $this, 'analytics_version' ), 51 );
				add_filter( 'widget_text', 'do_shortcode' ); // short code in text widget
				add_filter( 'views_edit-buttons-x', array( $this, 'screen_meta_view' ) );
				add_action( 'admin_menu', array( $this, 'welcome_page' ), 9 );
				// Gravity Forms
				add_filter( 'gform_submit_button', array( $this, 'gravity_form_submit_button' ), 10, 2 );
				// Content Filter
				$before_content_priority = isset( $btnsx_settings['before_content_priority'] ) && $btnsx_settings['before_content_priority'] != '' ? $btnsx_settings['before_content_priority'] : 10;
				add_filter( 'the_content', array( $this, 'before_content_filter' ), (int) $before_content_priority );
				$after_content_priority = isset( $btnsx_settings['after_content_priority'] ) && $btnsx_settings['after_content_priority'] != '' ? $btnsx_settings['after_content_priority'] : 10;
				add_filter( 'the_content', array( $this, 'after_content_filter' ), (int) $after_content_priority );
				add_action( 'wp_head', array( $this, 'auto_responsive_styles' ), 51 );
				add_action( 'wp_footer', array( $this, 'auto_responsive_script' ), 51 );
			} else {
				add_action( 'admin_notices', array( $this, 'dependency_notice' ) );
			}
		}

		/**
		 * Adds a box to the side column on Buttons edit screens.
		 * @since  1.9.50
		 * @return string
		 */
		public function display_button_callback( $post ) {
			// Add a nonce field so we can check for it later.
			wp_nonce_field( 'btnsx_display_button_meta', 'btnsx_display_button_meta_nonce' );

			$btnsx_form = new BtnsxFormElements();
			echo '<div style="min-height:100px;"><div class="btnsx btnsx-side">';
        	echo $btnsx_form->input( array(
					'type'			=>	'posts',
					'id'			=>	'btnsx_opt_display_button',
					'name'			=>	'btnsx_opt_display_button[]',
					'class'			=>	'btnsx-select',
					'multiselect'	=>	true,
					'placeholder'	=>	null,
					'label'			=>	__( 'Display Only On', 'btnsx' ),
					'tooltip'		=>	__( 'Display button only on the selected page(s).', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_display_button', 'value' => array() ) )
				)
        	);
        	echo '</div></div>';
		}

		/**
		 * Adds a box to the side column on Buttons edit screens.
		 * @since  1.3
		 * @return string
		 */
		public function hide_buttons_callback( $post ) {
			// Add a nonce field so we can check for it later.
			wp_nonce_field( 'btnsx_preview_settings_meta', 'btnsx_preview_settings_meta_nonce' );

			$meta_values = array();
	        $meta_values = get_post_meta( $post->ID, 'btnsx', true );

			$btnsx_form = new BtnsxFormElements();
			echo '<div style="min-height:100px;"><div class="btnsx btnsx-side">';
        	echo $btnsx_form->input( array(
					'type'			=>	'checkbox',
					'id'			=>	'btnsx_opt_hide_button_desktop',
					'name'			=>	'btnsx_opt_hide_button_desktop',
					'class'			=>	'btnsx-checkbox',
					'label'			=>	__( 'Hide on Desktop', 'btnsx' ),
					'tooltip'		=>	__( 'Hides button on desktop.', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_hide_button_desktop', 'value' => '0' ) )
				)
        	);
        	echo $btnsx_form->input( array(
					'type'			=>	'checkbox',
					'id'			=>	'btnsx_opt_hide_button_tablet',
					'name'			=>	'btnsx_opt_hide_button_tablet',
					'class'			=>	'btnsx-checkbox',
					'label'			=>	__( 'Hide on Tablet', 'btnsx' ),
					'tooltip'		=>	__( 'Hides button on tablet.', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_hide_button_tablet', 'value' => '0' ) )
				)
        	);
        	echo $btnsx_form->input( array(
					'type'			=>	'checkbox',
					'id'			=>	'btnsx_opt_hide_button_mobile',
					'name'			=>	'btnsx_opt_hide_button_mobile',
					'class'			=>	'btnsx-checkbox',
					'label'			=>	__( 'Hide on Mobile', 'btnsx' ),
					'tooltip'		=>	__( 'Hides button on mobile.', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_hide_button_mobile', 'value' => '0' ) )
				)
        	);
        	echo '</div></div>';
		}

		public function auto_responsive_script(){
			$btnsx_settings = get_option( 'btnsx_settings' );
			if( isset( $btnsx_settings['auto_responsive_styles'] ) && $btnsx_settings['auto_responsive_styles'] === '1' ) {
			?>
			<script type="text/javascript">
				// Icon Divider Responsiveness
				jQuery(document).ready(function($){
					var $btn = $('.btnsx-btn');
					var viewSize = $( window ).width();
	    			$btn.each( function() {
	    				// Icon
			            var icon = $( this ).find( '.btnsx-icon' );
			            var iconImage = $( this ).find( '.btnsx-icon-img' );
			            var iconDivider = $( this ).find( '.btnsx-divider' );
			            var iconDividerOrigPos = '';
			            if( iconDivider.length > 0 ){
			                iconDividerOrigPos = iconDivider.css( 'left' ).replace('px','');
			            }
			            var iconPadTop = '';
			            if( icon.length > 0 ) {
			                icon.css( 'padding-top' ).replace('px','');
			            }
			            if( iconImage.length > 0 ){
			                var iconImgSrc = iconImage.attr('src');
			                var iconHvrImgSrc = iconImage.data('hover');
			                if( iconHvrImgSrc ){
			                    $( this ).on('mouseenter',function(){
			                        iconImage.attr('src',iconHvrImgSrc);
			                    });
			                    $( this ).on('mouseleave',function(){
			                        iconImage.attr('src',iconImgSrc);
			                    });
			                }
			            }

			            var padLeft = $( this ).css( 'padding-left' ).replace( 'px', '' );
			            var padRight = $( this ).css( 'padding-right' ).replace( 'px', '' );
			            var iconFloat = '';
			            if( icon.length > 0 ) {
			                icon.css( 'float' );
			            }
			            var iconOW = '';
			            if( icon.length > 0 ) {
			                icon.outerWidth();
			            }
			            $( this ).dividerResponsiveness( viewSize, icon, iconDivider, iconDividerOrigPos, iconPadTop, padLeft, padRight, iconFloat, iconOW );
			            $( window ).resize( function(){
			                var viewSize = $( window ).width();
			                $btn.dividerResponsiveness( viewSize, icon, iconDivider, iconDividerOrigPos, iconPadTop, padLeft, padRight, iconFloat, iconOW );
			            });
			        });
			    });
			</script>
			<?php
			}
		}

		public function auto_responsive_styles(){
			$btnsx_settings = get_option( 'btnsx_settings' );
			if( isset( $btnsx_settings['auto_responsive_styles'] ) && $btnsx_settings['auto_responsive_styles'] === '1' ) {
			?>
			<style type="text/css">
				/**
				 * Mobile Large 620px
				 */
				@media screen and (max-width: 38.75em) {
				  .btnsx-btn .btnsx-icon {
				    font-size: 24px !important; }
				  .btnsx-btn .btnsx-text-primary {
				    font-size: 24px !important; }
				  .btnsx-btn .btnsx-text-secondary {
				    font-size: 24px !important; } }
				/**
				 * Tablet Small 740px
				 */
				@media screen and (max-width: 46.25em) {
				  .btnsx-btn .btnsx-icon {
				    font-size: 24px !important; }
				  .btnsx-btn .btnsx-text-primary {
				    font-size: 24px !important; }
				  .btnsx-btn .btnsx-text-secondary {
				    font-size: 24px !important; } }
				/**
				 * Tablet Large 880px
				 */
				@media screen and (max-width: 55em) {
				  .btnsx-btn .btnsx-icon {
				    font-size: 95% !important; }
				  .btnsx-btn .btnsx-text-primary {
				    font-size: 95% !important; }
				  .btnsx-btn .btnsx-text-secondary {
				    font-size: 95% !important; }

				  .btnsx-dual-btn {
				    display: table;
				    width: 100%;
				    table-layout: fixed; }
				    .btnsx-dual-btn .btnsx-dual-first {
				      width: 51% !important;
				      display: table-cell !important; }
				    .btnsx-dual-btn .btnsx-dual-second {
				      width: 51% !important;
				      display: table-cell !important; } }
				/**
				 * Desktop Small 955px
				 */
				@media screen and (max-width: 59.6875em) {
				  .btnsx-btn .btnsx-icon {
				    font-size: 95% !important; }
				  .btnsx-btn .btnsx-text-primary {
				    font-size: 95% !important; }
				  .btnsx-btn .btnsx-text-secondary {
				    font-size: 95% !important; } }
				/**
				 * Desktop Medium 1100px
				 */
				@media screen and (max-width: 68.75em) {
				  .btnsx-btn .btnsx-icon {
				    font-size: 24px !important; }
				  .btnsx-btn .btnsx-text-primary {
				    font-size: 24px !important; }
				  .btnsx-btn .btnsx-text-secondary {
				    font-size: 24px !important; } }
			</style>
			<?php
			}
		}

		/**
		 * Filters content and adds button before content
		 * @since  1.8.0
		 * @param  string    $content
		 * @return string
		 */
		public function before_content_filter( $content ){
			global $btnsx_settings;
			$output = '';
			if( isset($btnsx_settings['before_content_buttons']) && isset($btnsx_settings['before_content_post_types']) ){
				$before_content_post_types = array_filter( $btnsx_settings['before_content_post_types'] );
				if( !empty( $before_content_post_types ) ) {
					$before_content_buttons = array_filter( $btnsx_settings['before_content_buttons'] );
					if( is_singular( $before_content_post_types ) ){
						$before_content_wrap_center = isset( $btnsx_settings['before_content_wrap_center'] ) ? $btnsx_settings['before_content_wrap_center'] : '0';
						if( $before_content_wrap_center == '1' ){
							$text_center = 'text-align:center;';
						}else{
							$text_center = '';
						}
						$before_content_margin_top = isset( $btnsx_settings['before_content_margin_top'] ) ? $btnsx_settings['before_content_margin_top'] : '0';
						$before_content_margin_bottom = isset( $btnsx_settings['before_content_margin_bottom'] ) ? $btnsx_settings['before_content_margin_bottom'] : '0';
						$before_content_margin_left = isset( $btnsx_settings['before_content_margin_left'] ) ? $btnsx_settings['before_content_margin_left'] : '0';
						$before_content_margin_right = isset( $btnsx_settings['before_content_margin_right'] ) ? $btnsx_settings['before_content_margin_right'] : '0';
						if( !empty( $before_content_buttons ) ){
							$output .= '<div class="btnsx-social-share-container" style="display:block;'.$text_center.'margin:'. $before_content_margin_top . 'px '. $before_content_margin_right . 'px '. $before_content_margin_bottom . 'px '. $before_content_margin_left . 'px ' .'">';
							foreach ($before_content_buttons as $key => $value) {
								$post_type = get_post_type($value);
								if( $post_type == 'buttons-x' ){
									$post_type = 'btnsx';
								} elseif( $post_type = 'buttons-x-dual' ){
									$post_type = 'btnsx_dual';
								} elseif( $post_type = 'buttons-x-social' ){
									$post_type = 'btnsx_social';
								} else{
									$post_type = 'btnsx_social_counter';
								}
								$output .= do_shortcode('['.$post_type.' id="'.$value.'"]');
							}
							$output .= '</div>';
						}
					}
				}
			}
			$output .= $content;
			return $output;
		}

		/**
		 * Filters content and adds button after content
		 * @since  1.7.8
		 * @param  string    $content
		 * @return string
		 */
		public function after_content_filter( $content ){
			global $btnsx_settings;
			$output = $content;
			if( isset($btnsx_settings['after_content_buttons']) && isset($btnsx_settings['after_content_post_types']) ){
				$after_content_post_types = array_filter( $btnsx_settings['after_content_post_types'] );
				if( !empty( $after_content_post_types ) ){
					if( is_singular( $after_content_post_types ) ){
						$after_content_buttons = array_filter( $btnsx_settings['after_content_buttons'] );
						if( !empty( $after_content_buttons ) ){
							$after_content_wrap_center = isset( $btnsx_settings['after_content_wrap_center'] ) ? $btnsx_settings['after_content_wrap_center'] : '0';
							if( $after_content_wrap_center == '1' ){
								$text_center = 'text-align:center;';
							}else{
								$text_center = '';
							}
							$after_content_margin_top = isset( $btnsx_settings['after_content_margin_top'] ) ? $btnsx_settings['after_content_margin_top'] : '0';
							$after_content_margin_bottom = isset( $btnsx_settings['after_content_margin_bottom'] ) ? $btnsx_settings['after_content_margin_bottom'] : '0';
							$after_content_margin_left = isset( $btnsx_settings['after_content_margin_left'] ) ? $btnsx_settings['after_content_margin_left'] : '0';
							$after_content_margin_right = isset( $btnsx_settings['after_content_margin_right'] ) ? $btnsx_settings['after_content_margin_right'] : '0';
							$output .= '<div class="btnsx-social-share-container" style="display:block;'.$text_center.'margin:'. $after_content_margin_top . 'px '. $after_content_margin_right . 'px '. $after_content_margin_bottom . 'px '. $after_content_margin_left . 'px ' .'">';
							foreach ($after_content_buttons as $key => $value) {
								$post_type = get_post_type($value);
								if( $post_type == 'buttons-x' ){
									$post_type = 'btnsx';
								} elseif( $post_type = 'buttons-x-dual' ){
									$post_type = 'btnsx_dual';
								} elseif( $post_type = 'buttons-x-social' ){
									$post_type = 'btnsx_social';
								} else{
									$post_type = 'btnsx_social_counter';
								}
								$output .= do_shortcode('['.$post_type.' id="'.$value.'"]');
							}
							$output .= '</div>';
						}
					}
				}
			}
			return $output;
		}

		/**
		 * Hides original button and adds our button before it
		 * @since  1.7.7
		 * @param  string    $button
		 * @param  array    $form
		 * @return string
		 */
		public function gravity_form_submit_button( $button, $form ) {
			global $wpdb;
		   	$btnsx_post = 'buttons-x';
			$btnsx_post_status = 'publish';
	        $btnsx = $wpdb->get_results( $wpdb->prepare(
	            "SELECT ID, post_title
	                FROM $wpdb->posts
	                WHERE $wpdb->posts.post_type = %s
	                AND $wpdb->posts.post_status = %s
	                ORDER BY ID ASC",
	            $btnsx_post,
	            $btnsx_post_status
	        ) );
	        foreach ( $btnsx as $btn ) {
	        	$gf_id = maybe_unserialize( $this->meta_values( $btn->ID, array( 'field' => 'btnsx_gravity_form_id' ) ) );
	        	if( $gf_id == $form['id'] ){
	        		$button = do_shortcode('[btnsx id="' . $btn->ID . '" class="btnsx-gravity-form"]');
	        		$button .= "<button class='button' id='gform_submit_button_{$form['id']}' style='display:none;'><span>Submit NOW</span></button>";
	        		return $button;
	        	}
	        }
	        return $button;
		}

		/**
		 * Register parent menu
		 * @since  1.7.3
		 * @return
		 */
		public function welcome_page() {
		    if( function_exists('current_user_can') ){
				if( current_user_can( 'manage_options' ) ){
			    	add_menu_page( 'Buttons X', 'Buttons X', 'manage_options', 'btnsx', array( $this, 'welcome_page_callback' ), 'dashicons-btnsx-logo', 21);
			    	add_submenu_page( 'btnsx', 'Welcome', 'Welcome', 'manage_options', 'btnsx', array( $this, 'welcome_page_callback' ) );
			    }
			}
		}

		/**
		 * Welcome page markup
		 * @since  1.7.3
		 * @return string
		 */
		public function welcome_page_callback(){
		    ?>
		        <style type="text/css">
		            .btnsx-badge {
		            	font-size: 11.5px;
		                background-color: #005086;
		                color: #69B4E2;
		                background-image: none!important;
		            }
		            .btnsx-badge span {
		                position: absolute;
		                font-size: 64px;
		                top: 25px;
		                color: #fff;
		            }
		            .fb-like > span, .fb-follow > span {
		            	vertical-align: baseline!important;
		            }
		        </style>
		        <script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script>
		        <div id="fb-root"></div>
				<script>(function(d, s, id) {
				  var js, fjs = d.getElementsByTagName(s)[0];
				  if (d.getElementById(id)) return;
				  js = d.createElement(s); js.id = id;
				  js.src = "//connect.facebook.net/en_GB/sdk.js#xfbml=1&version=v2.5";
				  fjs.parentNode.insertBefore(js, fjs);
				}(document, 'script', 'facebook-jssdk'));</script>
		        <!-- Place this tag in your head or just before your close body tag. -->
				<script src="https://apis.google.com/js/platform.js" async defer></script>
		        <div class="wrap about-wrap">
		            <h1><?php printf( __( 'Welcome to Buttons X %1$s', 'btnsx' ), BTNSX__VERSION ); ?></h1>
		            <div class="about-text">
		            	<?php _e( 'Thank you for updating!', 'btnsx' ); ?>
		            	<br><br>
		            	<strong><?php printf( __( 'Buttons X %1$s:', 'btnsx' ), BTNSX__VERSION ); ?></strong>
		            	<ol>
		                	<li>FIXED: Color picker UI for WordPress 4.9.</li>
		                </ol>
		                <br>
		            	<!-- Social Buttons -->
			            	<a href="https://twitter.com/share" class="twitter-share-button"{count} data-url="https://www.button.sx" data-text="Build any kind of button imaginable right from your WordPress Dashboard with Buttons X!" data-via="btnsx" data-related="gautam_thapar" data-hashtags="ButtonsX">Tweet</a>
			            	<a href="https://twitter.com/btnsx" class="twitter-follow-button" data-show-count="false">Follow @btnsx</a>
			            	<!-- Facebook -->
			            	<div class="fb-like" data-href="https://www.button.sx" data-layout="button" data-action="like" data-show-faces="false" data-share="true"></div>
			            	<div class="fb-follow" data-href="https://www.facebook.com/btnsx" data-layout="button" data-show-faces="true"></div>
							<!-- Google -->
							<div class="g-follow" data-annotation="none" data-height="20" data-href="//plus.google.com/u/0/105722599123710552395" data-rel="publisher"></div>
							<div class="g-plusone" data-size="medium" data-annotation="inline" data-width="200" data-href="https://www.button.sx"></div>
		            </div>
		            <div class="wp-badge btnsx-badge"><span class="dashicons-before dashicons-btnsx-logo"></span><?php printf( __( 'Version %1$s', 'btnsx' ), BTNSX__VERSION ); ?></div>
					<hr>
					<h3><?php _e('Plugin Updates','btnsx'); ?></h3>
					<!-- Begin MailChimp Signup Form -->
						<link href="//cdn-images.mailchimp.com/embedcode/classic-081711.css" rel="stylesheet" type="text/css">
						<style type="text/css">
							#mc_embed_signup{background:#fff; clear:left; font:14px Helvetica,Arial,sans-serif; }
						</style>
						<div id="mc_embed_signup">
							<form action="//button.us11.list-manage.com/subscribe/post?u=bedf4c5985b18b5ff8b07e766&amp;id=9bc07618db" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="validate" target="_blank" novalidate>
						   		<div id="mc_embed_signup_scroll">
									<div class="indicates-required">
										<span class="asterisk">*</span> <?php _e('indicates required','btnsx'); ?>
									</div>
									<div class="mc-field-group">
										<label for="mce-EMAIL"><?php _e('Email Address','btnsx'); ?>
											<span class="asterisk">*</span>
										</label>
										<input type="email" value="" name="EMAIL" class="required email" id="mce-EMAIL">
									</div>
									<div id="mce-responses" class="clear">
										<div class="response" id="mce-error-response" style="display:none"></div>
										<div class="response" id="mce-success-response" style="display:none"></div>
									</div>    <!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->
						    		<div style="position: absolute; left: -5000px;"><input type="text" name="b_bedf4c5985b18b5ff8b07e766_9bc07618db" tabindex="-1" value=""></div>
						    		<div class="clear"><input type="submit" value="Subscribe" name="subscribe" id="mc-embedded-subscribe" class="button"></div>
						    	</div>
							</form>
						</div>
						<script type='text/javascript' src='//s3.amazonaws.com/downloads.mailchimp.com/js/mc-validate.js'></script><script type='text/javascript'>(function($) {window.fnames = new Array(); window.ftypes = new Array();fnames[0]='EMAIL';ftypes[0]='email';fnames[1]='FNAME';ftypes[1]='text';fnames[2]='LNAME';ftypes[2]='text';}(jQuery));var $mcj = jQuery.noConflict(true);</script>
					<!--End mc_embed_signup-->
					<br>
					<div class="changelog point-releases">
						<br/>
						<p><?php _e( 'Thank you for purchasing Buttons X.', 'btnsx' ); ?></p>
						<p><?php _e( 'I am working hard to make sure you have pleasant experience while using this plugin. In case you face any issues or get stuck somehwere then kindly let me know using ', 'btnsx'); ?><a target="_blank" href="https://gautamthapar.ticksy.com"><?php _e( 'official ticket system.', 'btnsx' ); ?></a> <?php _e( 'I will do my best to solve your issues as soon as possible.', 'btnsx' ); ?></p>
						<p><?php _e( 'This is a <b>PAID version</b> of Buttons X and so it includes all the goodies.', 'btnsx' ); ?></p>
						<!-- @TODO - Contact Link -->
						<p><?php echo sprintf( wp_kses( __( 'If you face any issue, please do <a href="%1$s">contact me</a>. I will be more than happy to help you!', 'btnsx' ), array(  'a' => array( 'href' => array() ) ) ), esc_url( 'https://gautamthapar.ticksy.com' ) );
						?></p>
						<br/>
						<p><?php _e( 'Warm Regards' ); ?>, Gautam Thapar.</p>
					</div>
		            <div class="changelog point-releases">
						<h3><?php _e('Helpful Links','btnsx'); ?></h3>
						<div class="feature-section under-the-hood three-col">
							<div class="col">
								<h4><a target="_blank" href="https://www.button.sx/product-category/add-ons/"><?php _e('Button Add-ons','btnsx'); ?></a></h4>
							</div>
							<div class="col">
								<h4><a target="_blank" href="https://www.button.sx/product-category/packs/"><?php _e('Button Packs','btnsx'); ?></a></h4>
							</div>
							<div class="col">
								<h4><a target="_blank" href="https://gautamthapar.atlassian.net/wiki/display/BX/"><?php _e('Documentation','btnsx'); ?></a></h4>
							</div>
							<div class="col">
								<h4><a target="_blank" href="http://gautamthapar.ticksy.com/"><?php _e('Support','btnsx'); ?></a></h4>
							</div>
							<div class="col">
								<h4><a target="_blank" href="https://www.button.sx/"><?php _e('Official Website','btnsx'); ?></a></h4>
							</div>
							<div class="col">
								<h4><a target="_blank" href="https://twitter.com/Gautam_Thapar"><?php _e('Twitter','btnsx'); ?></a></h4>
							</div>
						</div>
					</div>
		            <div class="changelog">
		            	<h3><?php _e('Files changed in','btnsx'); ?> v<?php echo BTNSX__VERSION; ?></h3>
		            	<ol>
		            		<li>assets/css/admin/admin.css</li>
							<li>assets/css/admin/admin.min.css</li>
							<li>btnsx.php</li>
							<li>readme.txt</li>
		                </ol>
		            </div>
		        </div>
		    <?php
		}

		/**
		 * Add packs and tags links on buttons list page
		 * @since  1.7.3
		 * @param  array    $views
		 * @return array
		 */
		public function screen_meta_view( $views ){
		    $packs = count(get_terms('btnsx_pack'));
		    $tags = count(get_terms('btnsx_tag'));
		    $views['packs'] = "<a href='edit-tags.php?taxonomy=btnsx_pack&post_type=buttons-x'>".__('Packs','btnsx')." <span class='count'>(".$packs.")</span></a>";
		    $views['tags'] = "<a href='edit-tags.php?taxonomy=btnsx_tag&post_type=buttons-x'>".__('Tags','btnsx')." <span class='count'>(".$tags.")</span></a>";
		    return $views;
		}

		/**
		 * Adds a box to the side column on Buttons edit screens.
		 * @since  1.3
		 * @return string
		 */
		public function preview_settings_callback( $post ) {
			// Add a nonce field so we can check for it later.
			wp_nonce_field( 'btnsx_preview_settings_meta', 'btnsx_preview_settings_meta_nonce' );

			$meta_values = array();
	        $meta_values = get_post_meta( $post->ID, 'btnsx', true );

			$btnsx_form = new BtnsxFormElements();
			echo '<div style="min-height:200px;"><div class="btnsx btnsx-side">';
			echo $btnsx_form->input( array(
	        		'type'			=>	'color',
					'id'			=>	'btnsx_opt_preview_background',
					'name'			=>	'btnsx_opt_preview_background',
					'placeholder'	=>	' ',
					'label'			=>	__( 'Background Color', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_preview_background' ) ),
					'tooltip'		=>	__( 'Changing the color will change the preview background. If you intend to use this button on a coloured background then changing the preview background will give you exact look of the button over a color.', 'btnsx' )
				)
        	);
        	// echo '<hr>';
        	echo $btnsx_form->input( array(
        			'type'			=>	'background-image',
					'id'			=>	'btnsx_opt_preview_background_image',
					'name'			=>	'btnsx_opt_preview_background_image',
					'label'			=>	__( 'Background Image', 'btnsx' ),
					'tooltip'		=>	array(
						'image'			=>	__( 'Select or upload button preview background image.', 'btnsx' ),
						// 'repeat'		=>	__( 'Set preview background image repeat.', 'btnsx' ),
						'position'		=>	__( 'Set preview background image position.', 'btnsx' ),
					),
					'value'			=>	array(
						'image'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_preview_background_image', 'field2' => 'image' ) ),
						// 'repeat'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_preview_background_image', 'field2' => 'repeat' ) ),
						'position'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_preview_background_image', 'field2' => 'position' ) ),
					)
				)
        	);
        	// echo '<hr>';
        	echo $btnsx_form->input( array(
					'type'			=>	'range',
					'id'			=>	'btnsx_opt_preview_background_overlay',
					'name'			=>	'btnsx_opt_preview_background_overlay',
					'placeholder'	=>	' ',
					'label'			=>	__( 'Overlay', 'btnsx' ),
					'tooltip'		=>	__( 'Adjust background overlay opacity. You can change overlay colour by changing the background colour option above.', 'btnsx' ),
					'min'			=>	0,
					'max'			=>	1,
					'step'			=>	0.1,
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_preview_background_overlay', 'value' => '0' ) )
				)
        	);
        	echo '</div></div>';
		}

		/**
		 * Analtyics version notice
		 * @since  1.4
		 * @return html
		 */
		public function analytics_version() {
			$analytics_plugin = ABSPATH . 'wp-content/plugins/btnsx-analytics/btnsx-analytics.php';
			if( file_exists( $analytics_plugin ) && is_plugin_active( 'btnsx-analytics/btnsx-analytics.php' ) ){
				$analytics = get_plugin_data( $analytics_plugin );
				$analytics_version = (int) str_replace( '.', '', $analytics['Version'] );
				if( $analytics_version < 12 ) {
					add_action( 'admin_notices', array( $this, 'analytics_version_notice' ) );
				}
			}
		}

		/**
		 * Analtyics version notice
		 * @since  1.4
		 * @return html
		 */
		public function analytics_version_notice() {
			?>
			<div class="error">
				<p><?php printf( __( 'This "Buttons X" version requires "Analytics" extension v1.2 and above. You can find the latest analytics extension in extensions folder. Kindly update now!', 'btnsx' ), BTNSX__MIN_WP_VERSION ); ?></p>
			</div>
			<?php
		}

		/**
		 * Output override style in head
		 * @since  1.3
		 * @return string
		 */
		public function override_style_inline() {
			echo '<meta name="generator" content="Powered by Buttons X - Powerful Button Builder for WordPress." version="'.BTNSX__VERSION.'"/>' . PHP_EOL;
			global $btnsx_settings;
			if( $btnsx_settings['css'] === 'inline' ){
				$css = $this->override_style_optimize();
				if( $css != '' ){
					echo '<style id="btnsx-override-style" type="text/css">' . PHP_EOL . ' /* Buttons X - Style Override - Start -- You can move all this CSS to external file by selecting external CSS from settings */ ' . PHP_EOL . $css . ' /* Buttons X - Style Override - End */ ' . PHP_EOL . '</style>' . PHP_EOL;
				}
			}
		}

		/**
		 * optimize inline styles
		 * @since  1.3
		 * @return string
		 */
		public function override_style_optimize() {
			global $wpdb;
		   	$btnsx_post = 'buttons-x';
			$btnsx_post_status = 'publish';
	        $btnsx = $wpdb->get_results( $wpdb->prepare(
	            "SELECT ID, post_title
	                FROM $wpdb->posts
	                WHERE $wpdb->posts.post_type = %s
	                AND $wpdb->posts.post_status = %s
	                ORDER BY ID ASC",
	            $btnsx_post,
	            $btnsx_post_status
	        ) );
	        $normal = array(); $hover = array(); $css = '';
	        foreach ( $btnsx as $btn ) {
	        	$override_style_type = maybe_unserialize( $this->meta_values( $btn->ID, array( 'field' => 'btnsx_override_style_type' ) ) );
	        	$override_style_custom_class = maybe_unserialize( $this->meta_values( $btn->ID, array( 'field' => 'btnsx_override_style_custom_class' ) ) );
	        	
				if( $override_style_type != '' && is_array( $override_style_type ) ){
					foreach ($override_style_type as $override_type ) {
						if( $override_type === 'woocommerce_button' ) {
							$normal[] = $this->overrides['woocommerce']['normal'];
							$hover[] = $this->overrides['woocommerce']['hover'];
						}
						if( $override_type === 'woocommerce_button_alt' ) {
							$normal[] = $this->overrides['woocommerce_alt']['normal'];
							$hover[] = $this->overrides['woocommerce_alt']['hover'];
						}
						if( $override_type === 'contact_form_7' ) {
							$normal[] = $this->overrides['contact_form_7']['normal'];
							$hover[] = $this->overrides['contact_form_7']['hover'];
						}
						if( $override_type === 'caldera_form' ) {
							$normal[] = $this->overrides['caldera_form']['normal'];
							$hover[] = $this->overrides['caldera_form']['hover'];
						}
						if( $override_type === 'ninja_form' ) {
							$normal[] = $this->overrides['ninja_form']['normal'];
							$hover[] = $this->overrides['ninja_form']['hover'];
						}
						if( $override_type === 'jetpack_subscribe_widget' ) {
							$normal[] = $this->overrides['jetpack_subscribe_widget']['normal'];
							$hover[] = $this->overrides['jetpack_subscribe_widget']['hover'];
						}
						if( $override_type === 'formidable_form' ) {
							$normal[] = $this->overrides['formidable_form']['normal'];
							$hover[] = $this->overrides['formidable_form']['hover'];
						}
					}
					$css .= $this->generate_override_css( $btn->ID, implode(', ', $normal ), implode(', ', $hover ), 'internal' ) . PHP_EOL;
				} elseif( $override_style_type == '' && $override_style_custom_class != '' ) {
					$css .= $this->generate_override_css( $btn->ID, '', '', 'internal' ) . PHP_EOL;
				}
				// reset values
				$normal = array(); $hover = array();
			}

			return $css;
		}

		/**
		 * Adds a box to the main column on the Post and Page edit screens.
		 * @since  1.3
		 * @return string
		 */
		public function override_style_callback( $post ) {
			// Add a nonce field so we can check for it later.
			wp_nonce_field( 'btnsx_override_style_meta', 'btnsx_override_style_meta_nonce' );

			$meta_values = array();
	        $meta_values = get_post_meta( $post->ID, 'btnsx', true );

			$btnsx_form = new BtnsxFormElements();
			echo '<div style="min-height:200px;"><div class="btnsx btnsx-side">';
			echo $btnsx_form->input( array(
	        		'type'			=>	'select',
					'size'			=>	'12',
					'id'			=>	'btnsx_opt_override_style_type',
					'name'			=>	'btnsx_opt_override_style_type[]',
					'class'			=>	'btnsx-select',
					'multiselect'	=>	true,
					'label'			=>	__( 'Override Style for', 'btnsx' ),
					'tooltip'		=>	__( 'Select type of buttons to override their styles. You can select mulitple options.', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_override_style_type' ) ),
					'options'		=>	array(
						'woocommerce_button' 		=> __( 'WooCommerce Buttons', 'btnsx' ),
						'woocommerce_button_alt' 	=> __( 'WooCommerce Alternate Buttons', 'btnsx' ),
						'contact_form_7' 			=> __( 'Contact Form 7', 'btnsx' ),
						'ninja_form' 				=> __( 'Ninja Forms', 'btnsx' ),
						'caldera_form' 				=> __( 'Caldera Forms', 'btnsx' ),
						'jetpack_subscribe_widget'	=> __( 'Jetpack Subscribe Button', 'btnsx' ),
						'formidable_form'			=> __( 'Formidable Form', 'btnsx' )
					)
				)
        	);
        	echo $btnsx_form->input( array(
	        		'type'			=>	'text',
					'size'			=>	'12',
					'id'			=>	'btnsx_opt_override_style_custom_class',
					'name'			=>	'btnsx_opt_override_style_custom_class',
					'placeholder'  	=>	' ',
					'label'			=>	__( 'Custom Class(es)', 'btnsx' ),
					'tooltip'		=>	__( 'Add custom class(es) (comma separated)', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_override_style_custom_class' ) ),
				)
        	);
        	echo '<br/></div></div>';
		}

		/**
		 * Function to rest button options
		 * @since  0.1
		 * @return string
		 */
		public function publishing_actions() {
		    global $post;
		    if ( $post->post_type === 'buttons-x' ) {
		        echo '<div class="misc-pub-section misc-pub-btnsx-options-reset"><i id="btnsx_options_reset_icon" class="fas fa-redo" style="font-size:16px;color:#82878c;margin-right:10px;"></i><a id="btnsx_options_reset" href="javascript:void(0)">' . __( 'Reset Options', 'btnsx' ) . '</a></div>';
		        echo '<div class="misc-pub-section misc-pub-btnsx-options-reset"><i id="btnsx_options_clone_icon" class="fa fa-clone" style="font-size:16px;color:#82878c;margin-right:10px;"></i><a id="btnsx_options_clone" href="edit.php?post_type=buttons-x&btnsx-clone=' . $post->ID . '">' . __( 'Clone Button', 'btnsx' ) . '</a></div>';
		    }
		}

		/**
		 * Function to load logo icon styles & font
		 * @since  0.1
		 * @return string
		 */
		public function logo_style() {
			?>
			<style type="text/css">
				@font-face {
					font-family: 'btnsx';
					src:url('<?php echo BTNSX__PLUGIN_URL; ?>assets/css/fonts/btnsx.eot?2w9zom');
					src:url('<?php echo BTNSX__PLUGIN_URL; ?>assets/css/fonts/btnsx.eot?#iefix2w9zom') format('embedded-opentype'),
						url('<?php echo BTNSX__PLUGIN_URL; ?>assets/css/fonts/btnsx.ttf?2w9zom') format('truetype'),
						url('<?php echo BTNSX__PLUGIN_URL; ?>assets/css/fonts/btnsx.woff?2w9zom') format('woff'),
						url('<?php echo BTNSX__PLUGIN_URL; ?>assets/css/fonts/btnsx.svg?2w9zom#btnsx') format('svg');
					font-weight: normal;
					font-style: normal;
				}
				[class^="dashicons-btnsx-"], [class*=" dashicons-btnsx-"] {
					font-family: 'btnsx';
					speak: none;
					font-style: normal;
					font-weight: normal;
					font-variant: normal;
					text-transform: none;
					line-height: 1;
					/* Better Font Rendering =========== */
					-webkit-font-smoothing: antialiased;
					-moz-osx-font-smoothing: grayscale;
				}
				.dashicons-btnsx-logo:before {
					font-family: btnsx !important;
					content: "\e600";
					font-size: 1.3em!important;
					font-weight: 900!important;
				}
				.wp-media-buttons-icon.dashicons-btnsx-logo {
					display: inline-block;
				    width: 18px;
				    height: 18px;
				    vertical-align: text-top;
				    margin: 0 2px;
				}
			</style>
			<?php
		}

		/**
		 * Function to send json response to menu ajax request
		 * @since  0.1
		 * @return string
		 */
		public function dropdown_menu_ajax() {
			// check for nonce
			check_ajax_referer( 'btnsx-menu', 'security' );
			$menu_type = $_POST['menuType'];
			$urls = $_POST['urls'];
			$labels = $_POST['labels'];
			if($menu_type==='wordpress'){
				$response = $this->dropdown_menu( array( 'menu' => $_POST['data'], 'menu_id' => 'btnsx-preview-btn-dropdown', 'menu_class' => 'btnsx-dropdown-menu' ) );
			}else if($menu_type==='custom'){
				$response = '<ul id="btnsx-preview-btn-dropdown" class="btnsx-dropdown-menu">';
	   			if(is_array($urls)){
   					foreach ($urls as $k => $url) {
   						$label = $labels[$k];
   						if( !$label ){
   							$label = __('Insert Label','btnsx');
   						}
   						$response .= '<li class="menu-item"><a href="'.esc_url($url).'">'.esc_html($label).'</a></li>';
   					}
	   			}
	   			$response .= '</ul>';
			}else{
				$response = '';
			}
			
			wp_send_json( $response );
		}

		/**
		 * Function to output script on button page
		 * @since  0.1
		 * @return string
		 */
		public function preview_menu_jquery() {
			// create nonce
			$menu_nonce = wp_create_nonce( 'btnsx-menu' );
			?>
		    <script type="text/javascript">
				jQuery( document ).ready( function( $ ) {
					if( $('#btnsx_opt_link_type').val() == 'menu'){
						var urls = [];
						$("input[name='btnsx_opt_link_menu_custom_url[]']").each(function() {
						    urls.push($(this).val());
						});
						var labels = [];
						$("input[name='btnsx_opt_link_menu_custom_label[]']").each(function() {
						    labels.push($(this).val());
						});
			            var data = {
			                action: 'dropdown_menu',
			                security: '<?php echo $menu_nonce; ?>',
			                data: $('#btnsx_opt_link_menu').val(),
			                menuType: $('#btnsx_opt_link_menu_type').val(),
			                labels: labels,
			                urls: urls
			            };
			            $.post( ajaxurl, data, function( response ) {
			            	var btnContainer = $('#btnsx-preview-container');
			            	var btnFullWidth = $('#btnsx_opt_full_width');
			                btnContainer.addClass('btnsx-btn-group').find('.btnsx-dropdown-menu').remove();
			                if( btnFullWidth.is(':checked') ){
			                	btnContainer.css('width','100%');
			                }else{
			                	btnContainer.css('width','auto');
			                }
			                btnContainer.append(response);
			                var btnMenuDisplay = $('#btnsx_opt_link_menu_display').val();
			                if( btnMenuDisplay === 'on_hover' ) {
			                	$('#btnsx-preview-btn').addClass('btnsx-dropdown-toggle').attr('data-toggle-hover','btnsx-dropdown');
			                	$('#btnsx-preview-container').on('mouseenter', function(){
						            $('#btnsx-preview-btn-dropdown').stop( true, true ).fadeIn(100);
						            $(this).toggleClass('btnsx-open');
						        });
						        $('#btnsx-preview-container').on('mouseleave', function(){
						            $('#btnsx-preview-btn-dropdown').stop( true, true ).fadeOut('fast');
						            $(this).toggleClass('btnsx-open');
						        });
			                } else {
			                	$('#btnsx-preview-btn').addClass('btnsx-dropdown-toggle').attr('data-toggle','btnsx-dropdown');
			                	$('#btnsx-preview-btn').on('click',function(){
			                		if( btnContainer.hasClass('btnsx-open') ) {
			                			$('#btnsx-preview-btn-dropdown').stop( true, true ).fadeOut('fast');
			                		}else{
			                			$('#btnsx-preview-btn-dropdown').stop( true, true ).fadeIn(100);
			                		}
			                	});
			                }
			            });
			        }
					$("#btnsx_opt_link_type,#btnsx_opt_link_menu_type,#btnsx_opt_link_menu,#btnsx_opt_link_menu_display").change(function () {
				        if( $('#btnsx_opt_link_type').val() == 'menu'){
				        	var urls = [];
							$("input[name='btnsx_opt_link_menu_custom_url[]']").each(function() {
							    urls.push($(this).val());
							});
							var labels = [];
							$("input[name='btnsx_opt_link_menu_custom_label[]']").each(function() {
							    labels.push($(this).val());
							});
				            var data = {
				                action: 'dropdown_menu',
				                security: '<?php echo $menu_nonce; ?>',
				                data: $('#btnsx_opt_link_menu').val(),
				                menuType: $('#btnsx_opt_link_menu_type').val(),
				                labels: labels,
				                urls: urls
				            };
				            $.post( ajaxurl, data, function( response ) {
				            	var btnContainer = $('#btnsx-preview-container');
				            	var btnFullWidth = $('#btnsx_opt_full_width');
				                btnContainer.addClass('btnsx-btn-group').find('.btnsx-dropdown-menu').remove();
				                if( btnFullWidth.is(':checked') ){
				                	btnContainer.css('width','100%');
				                } else {
				                	btnContainer.css('width','auto');
				                }
				                btnContainer.append(response);
				                var btnMenuDisplay = $('#btnsx_opt_link_menu_display').val();
				                $('#btnsx-preview-btn').addClass('btnsx-dropdown-toggle');
				                if( btnMenuDisplay === 'on_hover' ) {
				                	$('#btnsx-preview-btn').removeAttr('data-toggle').attr('data-toggle-hover','btnsx-dropdown');
				                	$('#btnsx-preview-container').on('mouseenter', function(){
							            $('#btnsx-preview-btn-dropdown').stop( true, true ).fadeIn(100);
							            $(this).addClass('btnsx-open');
							        });
							        $('#btnsx-preview-container').on('mouseleave', function(){
							            $('#btnsx-preview-btn-dropdown').stop( true, true ).fadeOut('fast');
							            $(this).removeClass('btnsx-open');
							        });
				                } else {
				                	$('#btnsx-preview-container').unbind(' mouseenter mouseleave ');
				                	$('#btnsx-preview-btn').removeAttr('data-toggle-hover').attr('data-toggle','btnsx-dropdown');
				                	$('#btnsx-preview-btn').on('click',function(){
				                		if( btnContainer.hasClass('btnsx-open') ) {
				                			$('#btnsx-preview-btn-dropdown').stop( true, true ).fadeOut('fast');
				                		} else {
				                			$('#btnsx-preview-btn-dropdown').stop( true, true ).fadeIn(100);
				                		}
				                	});
				                }
				            });
				        } else {
				        	$('#btnsx-preview-btn-dropdown').remove();
				        	$('#btnsx-preview-btn').removeClass('btnsx-dropdown-toggle').removeAttr('data-toggle data-toggle-hover aria-expanded');
				        	$('#btnsx-preview-container').removeClass('btnsx-btn-group');
				        }
				    });
				});
			</script>
			<?php
		}

		/**
		 * Function to return menu as list
		 * @since  0.1
		 * @param  array    $args
		 * @return string
		 */
		public function dropdown_menu( $args  ) {

		   	$defaults = array(
		   		'theme_location'  => '',
		        'menu'            => '',
		        'container'       => false,
		        'container_class' => '',
		        'container_id'    => '',
		        'menu_class'      => 'btnsx-dropdown-menu',
		        'menu_id'         => 'btnsx-dropdown-menu',
		        'echo'            => '0',
		        'fallback_cb'     => 'wp_page_menu',
		        'before'          => '',
		        'after'           => '',
		        'link_before'     => '',
		        'link_after'      => '',
		        'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
		        'depth'           => -1,
		        'walker'          => ''
		   	);

		   	$args = wp_parse_args( $args, $defaults );

		    $response = wp_nav_menu( $args );

		    return $response;
		}

		/**
		 * Function to remove view link to row actions on buttons X post type
		 * @since  0.1
		 * @param  string    $actions default actions
		 * @param  WP_Post   $post post object
		 * @return string
		 */
		public function row_actions( $actions, WP_Post $post ) {
	        if ( $post->post_type != 'buttons-x' ) {
	            return $actions;
	        }
	        unset( $actions['view'] );
	        return $actions;
	    }

	    /**
	     * Add custom columns to buttons x page
	     * @since  0.1
	     * @param  array    $defaults
	     * @return array
	     */
	    public function columns( $defaults ) {
			$defaults['btnsx_shortcode'] 	= __( 'Shortcode', 'btnsx' );
		    $defaults['btnsx_preview'] 	= __( 'Preview', 'btnsx' );
		    unset( $defaults['date'] );
		    return $defaults;
		}

		/**
		 * Callback function for preview column
		 * @since  0.1
		 * @param  string    $column_name
		 * @param  int    $id
		 * @return string
		 */
		public function column_preview( $column_name, $id ) {
		    if ( $column_name === 'btnsx_preview' ) {
		        $meta = get_post_meta( $id, 'btnsx', true);
		        $background = ( isset( $meta['btnsx_preview_background'] ) && $meta['btnsx_preview_background'] != '' ? $meta['btnsx_preview_background'] : '#fff' );
		        $background_image = ( isset( $meta['btnsx_preview_background_image']['image'] ) && $meta['btnsx_preview_background_image']['image'] != '' ? 'background-image:url(' . $meta['btnsx_preview_background_image']['image'] . ');' : '' );
		       	$background_image_position = ( isset( $meta['btnsx_preview_background_image']['position'] ) && $meta['btnsx_preview_background_image']['position'] != '' ? 'background-position:' . $meta['btnsx_preview_background_image']['position'] . ';' : '' );
		       	$background_overlay = ( isset( $meta['btnsx_preview_background_overlay'] ) && $meta['btnsx_preview_background_overlay'] != '' ? 'opacity:' . $meta['btnsx_preview_background_overlay'] . ';' : 'opacity:0;' );
		        ?>
		        <div class="btnsx">
			        <!-- Modal Trigger -->
					<a class="waves-effect waves-light btn modal-trigger" href="#modal<?php echo esc_attr( $id ); ?>"><?php _e( 'Preview', 'btnsx' ); ?></a>
					<!-- Modal Structure -->
					<style type="text/css">
						#modal<?php echo sanitize_text_field( $id ); ?> .modal-content, #modal<?php echo sanitize_text_field( $id ); ?> .modal-footer {
						  	background-color: <?php echo sanitize_text_field( $background ); ?>;
						  	<?php echo $background_image;echo $background_image_position; ?>
						  	background-repeat: repeat;
						}
					</style>
					<div id="modal<?php echo esc_attr( $id ); ?>" class="modal preview-modal">
						<div class="btnsx-preview-overlay" style="<?php echo sanitize_text_field( $background_overlay ); echo 'background-color:'.sanitize_text_field( $background ).';'; ?>"></div>
					    <div class="modal-content">
					    	<?php
					    		// Filter Short Code Attributes
					    		$default = array (
					    			'id' => $id,
					    			'css_inline' => '1'
					    		);
								$filter = apply_filters( 'btnsx_list_preview_filter', array(), $default );
								$filtered = array();
								// combine multiple arrays into one
								foreach ($filter as $key => $value) {
									foreach ($value as $k => $v) {
										$filtered[$k] = $v;
									}
								}
								$options = wp_parse_args( $filtered, $default );
					    		echo $this->shortcode( $options );
					    	?>
					    	<a href="javascript:void(0)" class="modal-action modal-close" style="position:absolute;bottom:10px;right:10px;"><i class="fa fa-close"></i></a>
					    </div>
					    <div class="modal-footer" style="display:none;">
					      	<a href="javascript:void(0)" class="modal-action modal-close"><i class="fa fa-close"></i></a>
					    </div>
					</div>
				</div>
				<?php
		    }
		    if ( $column_name === 'btnsx_shortcode' ) {
		        echo '[btnsx id="' . $id . '"]';
		    }
		}

		/**
		 * Function to re-order columns on Buttons X page
		 * @since  0.1
		 * @param  array   $columns
		 * @return array
		 */
		public function columns_order( $columns ) {
		    return array(
		        'cb' 					=> '<input type="checkbox" />',
		        'title' 				=> __( 'Title', 'btnsx' ),
		        'taxonomy-btnsx_pack' 	=> __( 'Packs', 'btnsx' ),
		        'taxonomy-btnsx_tag' 	=> __( 'Tags', 'btnsx' ),
		        'btnsx_shortcode' 		=> __( 'Shortcode', 'btnsx' ),
		        'btnsx_preview' 		=> __( 'Preview', 'btnsx' ),
		    );
		}

		/**
		 * Function to create directory and dynamic style file.
		 * @since  0.1
		 * @return nothing
		 */
	    public function create_directory( $content = '' ) {

	    	$access = get_filesystem_method();

			if( $access === 'direct' )
			{
		        $creds = request_filesystem_credentials( site_url() . '/wp-admin/', '', false, false, null );

		        if ( !WP_Filesystem( $creds ) ) {
		            return false;
		        }

		        global $wp_filesystem;

		        $upload_dir = wp_upload_dir();
		        $dir   = trailingslashit( $upload_dir['basedir'] ) . 'btnsx';
		        $file  = trailingslashit( $dir ) . 'dynamic.css';

		        if ( !is_dir( $dir ) ) {
		            $wp_filesystem->mkdir( $dir );
		        }
		        if ( !file_exists( $file ) ) {
		            $wp_filesystem->put_contents( $file, '', FS_CHMOD_FILE );
		        }
		        if( $content === 'empty' ){
		        	$wp_filesystem->put_contents( $file, '', FS_CHMOD_FILE );
		        }

		    } else {

		    	add_action( 'admin_notices', array( $this, 'error_notice_directory') );

		    }
	    }

    	/**
    	 * Notice if fails to create directory for dynamic css.
    	 * @since  0.1
    	 * @return string
    	 */
	    public function error_notice_directory() {
	        ?>
	        <div class="error">
	            <p><?php _e( 'Buttons X not able to create required directories. You won\'t be able to use external CSS. Kindly reactivate the plugin. If problem persists, kindly contact support.', 'btnsx' ); ?></p>
	        </div>
	        <?php
	    }

		/**
		 * Load plugin textdomain
		 * @since 0.1
		 */
		public function load_textdomain() {
			load_plugin_textdomain( 'btnsx', false, BTNSX__PLUGIN_URL . 'languages' );
		}

		/**
		 * Dependency notice
		 * @since  0.1
		 * @return html
		 */
		public function dependency_notice() {
			?>

			<div class="error">
				<p><?php printf( __( 'Buttons X require minimum WordPress version to be %1$s.', 'btnsx' ), BTNSX__MIN_WP_VERSION ); ?></p>
			</div>

			<?php
		}

		/**
		 * Enqueue Admin Scripts
		 * @since 0.1
		 */
		public function admin_enqueue_scripts() {

			$screen = get_current_screen();

			// Admin Scripts
			if ( in_array( $screen->id, array( 'buttons-x', 'edit-buttons-x', 'buttons-x-social', 'edit-buttons-x-social', 'buttons-x-dual', 'edit-buttons-x-dual', 'buttons-x-cs', 'edit-buttons-x-cs', 'buttons-x_page_buttons-x-settings', 'buttons-x_page_buttons-x-import' ) ) ) {
				wp_enqueue_script( 'jquery-ui-core' );
				wp_enqueue_script( 'wp-color-picker' );	
				wp_register_script(
					'btnsx-admin',
					BTNSX__PLUGIN_URL . 'assets/js/admin/admin.js',
					array('jquery','jquery-ui-core','wp-color-picker'),
					BTNSX__VERSION,
					false
				);
				wp_enqueue_script( 'btnsx-admin' );
				wp_register_script(
					'btnsx-ace-js',
					BTNSX__PLUGIN_URL . 'assets/js/admin/ace.js',
					array('jquery'),
					BTNSX__VERSION,
					false
				);
				wp_enqueue_script( 'btnsx-ace-js' );
				wp_deregister_script( 'select2' ); // WooCommerce Product Faq Manager
				wp_dequeue_script( 'select2' ); // WooCommerce Product Faq Manager
				wp_enqueue_media();
				wp_deregister_script( 'et-core-admin' ); // Fix Divi 2.7 admin.js conflict
				// GT ShortCodes conflict
				wp_deregister_script( 'gt-admin-ace' );
			   	wp_dequeue_script( 'gt-admin-ace' );
			   	wp_deregister_script( 'gt-admin-select2' );
			   	wp_dequeue_script( 'gt-admin-select2' );
				wp_deregister_script( 'acf-input' ); // ACF
				wp_dequeue_script( 'acf-input' ); // ACF
				wp_deregister_script( 'acf-pro-input' ); // ACF
				wp_dequeue_script( 'acf-pro-input' ); // ACF
				wp_deregister_script( 'acf-field-group' ); // ACF
				wp_dequeue_script( 'acf-field-group' ); // ACF
				wp_dequeue_script( 'ultimate-vc-backend-script' ); // UVCA
				wp_dequeue_style( 'ultimate-vc-backend-style' ); // UVCA
				wp_dequeue_script( 'woocomposer-admin-script' ); // UVCA
				wp_dequeue_script( 'tab-js-1' ); // UVCA
				wp_dequeue_script( 'tab-js-2' ); // UVCA
				// Kalium Theme Conflict.
				wp_deregister_script( 'kalium-acfpro-gm-main-js' );
				wp_dequeue_script( 'kalium-acfpro-gm-main-js' );
			}
			if ( in_array( $screen->id, array( 'edit-buttons-x-cs' ) ) ) {
				wp_enqueue_script('jquery-ui-sortable');
			}
			if ( in_array( $screen->id, array( 'buttons-x' ) ) ) {
				$view_version  = date('ymd-Gis', filemtime( BTNSX__PLUGIN_DIR . 'assets/js/admin/views.min.js' ));
				wp_register_script(
					'btnsx-views-js',
					BTNSX__PLUGIN_URL . 'assets/js/admin/views.min.js',
					array('jquery','jquery-ui-core','backbone'),
					$view_version,
					false
				);
				$translations = array(
					'google_web_fonts' => BTNSX__PLUGIN_URL . 'assets/webfonts.json'
				);
				wp_localize_script( 'btnsx-views-js', 'view_translations', $translations );
				wp_enqueue_script( 'btnsx-views-js' );
			}

			// Admin Styles
			if ( in_array( $screen->id, array( 'buttons-x', 'edit-buttons-x', 'buttons-x-social', 'edit-buttons-x-social', 'buttons-x-dual', 'edit-buttons-x-dual', 'buttons-x-cs', 'edit-buttons-x-cs', 'buttons-x_page_buttons-x-settings', 'buttons-x_page_buttons-x-import', 'post', 'page' ) ) ) {
				wp_enqueue_style( 'wp-color-picker' );
				wp_enqueue_style(
					'btnsx' . '-css',
					BTNSX__PLUGIN_URL . 'assets/css/admin/admin.min.css',
					array(),
					BTNSX__VERSION
				);
				wp_dequeue_style( 'wpe-common' ); // WPEngine styles
				wp_dequeue_style( 'jquery-ui-datepicker' );
				wp_dequeue_style( 'font-awesome' ); // Multi-X Bar plugin
				wp_dequeue_style( 'select2' ); // WooCommerce Product Faq Manager
			}
		}

		/**
		 *  Enqueue Public Scripts
		 *  @since 0.1
		 */
		public function public_enqueue_scripts() {
			// Public scripts
			wp_register_script(
				'btnsx',
				BTNSX__PLUGIN_URL . 'assets/js/public/btnsx.js',
				array('jquery'),
				BTNSX__VERSION,
				true
			);
			wp_enqueue_script( 'btnsx' );

			// Public styles
			wp_enqueue_style(
				'btnsx',
				BTNSX__PLUGIN_URL . 'assets/css/common/button.css',
				array(),
				BTNSX__VERSION
			);
			$upload_dir = wp_upload_dir();
			global $btnsx_settings; global $wp_filesystem;
			if( isset( $btnsx_settings['css'] ) && $btnsx_settings['css'] === 'external' ){
				wp_enqueue_style(
					'btnsx' . '-dynamic',
					trailingslashit( $upload_dir['baseurl'] ) . 'btnsx/dynamic.css',
					array(),
					BTNSX__VERSION
				);
			}
		}

		/**
		 * Register settings page
		 * @since  0.1
		 * @return string
		 */
		public function register_settings_page() {
			add_submenu_page(
				'btnsx',
				'Buttons X',
				'Import',
				'manage_options',
				'buttons-x-import',
				array( $this, 'import_page_callback' )
			);
			add_submenu_page(
				'btnsx',
				'Buttons X',
				'Settings',
				'manage_options',
				'buttons-x-settings',
				array( $this, 'settings_page_callback' )
			);
		}

		/**
		 * Settings page callback
		 * @since  0.1
		 * @return string
		 */
		public function settings_page_callback() {
			$btnsx_settings = get_option( 'btnsx_settings' );
			include plugin_dir_path( __FILE__ ) . 'settings-page.php';
		}

		/**
		 * Register settings
		 * @since  0.1
		 * @return
		 */
		public function register_settings() {
			register_setting( 'btnsx_settings_group', 'btnsx_settings' );
		}

		/**
		 * Function to create and update external css files when css setting is changed
		 * @since  0.1
		 * @return string
		 */
		public function external_css( $content = '' ) {
			// echo 'ext1';
			if( !$content == 'empty' ){
				$this->create_directory( $content );
			}
			// echo $id;
			// The Query
			$btn_query = new WP_Query( array( 'post_type'=> 'buttons-x', 'posts_per_page' => -1 ) );
			// var_dump($btn_query);
			// The Loop
			if ( $btn_query->have_posts() ) {
				while ( $btn_query->have_posts() ) {
					$btn_query->the_post();
					// print CSS
					$this->print_css( get_the_ID() );
				}
			}
			if( class_exists('BtnsxDual') ){
				$btn_query = new WP_Query( array( 'post_type'=> 'buttons-x-dual', 'posts_per_page' => -1 ) );
				$dual = new BtnsxDual();
				// var_dump($btn_query);
				// The Loop
				if ( $btn_query->have_posts() ) {
					while ( $btn_query->have_posts() ) {
						$btn_query->the_post();
						// print CSS
						$dual->print_css( get_the_ID() );
					}
				}
			}
			/* Restore original Post Data */
			wp_reset_postdata();
		}

		/**
		 * Import page callback
		 * @since  0.1
		 * @return string
		 */
		public function import_page_callback() {
			include plugin_dir_path( __FILE__ ) . 'import-page.php';
		}

        /**
        * Register the menu for the Dashboard.
        * @since 0.1
        */
        public function register_cpt() {
    		global $btnsx_settings;

    		// White label options
            if( isset( $btnsx_settings['menu_name'] ) ){
                $button_menu_name = $btnsx_settings['menu_name'];
            } else {
                $button_menu_name = _x('Buttons', 'admin menu', 'btnsx');
            }

            if( isset( $btnsx_settings['name_singular'] ) ){
                $button_name_singular = $btnsx_settings['name_singular'];
            } else {
                $button_name_singular = _x('Button', 'post type singular name', 'btnsx');
            }

            if( isset( $btnsx_settings['name_plural'] ) ){
                $button_name_plural = $btnsx_settings['name_plural'];
            } else {
                $button_name_plural = _x('Buttons', 'post type general name', 'btnsx');
            }

            if( isset( $btnsx_settings['admin_bar_name'] ) ){
                $button_admin_bar_name = $btnsx_settings['admin_bar_name'];
            } else {
                $button_admin_bar_name = _x('Button', 'add new on admin bar', 'btnsx');
            }

            // Register buttons post
            register_post_type('buttons-x',
                array(
                    'labels' => array(
                        'name' => $button_name_plural,
                        'singular_name' => $button_name_singular,
                        'menu_name' => $button_menu_name,
                        'name_admin_bar' => $button_admin_bar_name,
                        'add_new' => _x('Add New', $button_name_singular, 'btnsx'),
                        'add_new_item' => __('Add New ', 'btnsx') . $button_name_singular,
                        'new_item' => __('New ', 'btnsx') . $button_name_singular,
                        'edit_item' => __('Edit ', 'btnsx') . $button_name_singular,
                        'view_item' => __('View ', 'btnsx') . $button_name_singular,
                        'all_items' => $button_name_plural,
                        'search_items' => __('Search ', 'btnsx') . $button_name_plural,
                        'parent_item_colon' => __('Parent ', 'btnsx') . $button_name_plural . ':',
                        'not_found' => __('No ', 'btnsx') . $button_name_plural . __(' found.', 'btnsx'),
                        'not_found_in_trash' => __('No ', 'btnsx') . $button_name_plural . __(' found in Trash.', 'btnsx'),
                    ),
                    'public'                => false,
                    'show_ui'				=> true,
                    'exclude_from_search'   => true,
                    'publicly_queryable'    => false,
                    'has_archive'           => false,
                    'show_in_admin_bar'     => true,
                    'show_in_nav_menus'		=> true,
                    'show_in_menu'			=> 'btnsx',
                    'supports'              => array( 'title' ),
                    'menu_icon'				=> 'dashicons-btnsx-logo'
                )
            );
        }

        /**
         * Button update messages.
         * @since  0.1
         * @param  array    $messages
         * @return array
         */
		public function updated_messages( $messages ) {
			$post             = get_post();
			$post_type        = get_post_type( $post );
			$post_type_object = get_post_type_object( $post_type );
			$messages['buttons-x'] = array(
				0  => '', // Unused. Messages start at index 1.
				1  => __( 'Button updated.', 'btnsx' ),
				2  => __( 'Custom field updated.', 'btnsx' ),
				3  => __( 'Custom field deleted.', 'btnsx' ),
				4  => __( 'Button updated.', 'btnsx' ),
				/* translators: %s: date and time of the revision */
				5  => isset( $_GET['revision'] ) ? sprintf( __( 'Button restored to revision from %s', 'btnsx' ), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
				6  => __( 'Button published.', 'btnsx' ),
				7  => __( 'Button saved.', 'btnsx' ),
				8  => __( 'Button submitted.', 'btnsx' ),
				9  => sprintf(
					__( 'Button scheduled for: <strong>%1$s</strong>.', 'btnsx' ),
					// translators: Publish box date format, see http://php.net/date
					date_i18n( __( 'M j, Y @ G:i', 'btnsx' ), strtotime( $post->post_date ) )
				),
				10 => __( 'Button draft updated.', 'btnsx' )
			);

			// if ( $post_type_object->publicly_queryable ) {
			// 	$permalink = get_permalink( $post->ID );

			// 	$view_link = sprintf( ' <a href="%s">%s</a>', esc_url( $permalink ), __( 'View button', 'btnsx' ) );
			// 	$messages[ $post_type ][1] .= $view_link;
			// 	$messages[ $post_type ][6] .= $view_link;
			// 	$messages[ $post_type ][9] .= $view_link;

			// 	$preview_permalink = add_query_arg( 'preview', 'true', $permalink );
			// 	$preview_link = sprintf( ' <a target="_blank" href="%s">%s</a>', esc_url( $preview_permalink ), __( 'Preview Button', 'btnsx' ) );
			// 	$messages[ $post_type ][8]  .= $preview_link;
			// 	$messages[ $post_type ][10] .= $preview_link;
			// }
			return $messages;
		}

        /**
         * Register custom taxonomies for button post type
         * @since  0.1
         * @return
         */
        public function register_taxonomies() {
		    // Add new taxonomy, make it hierarchical (like categories)
		    $labels = array(
		        'name' 				=> _x( 'Packs', 'btnsx' ),
		        'singular_name' 	=> _x( 'Pack', 'btnsx' ),
		        'search_items' 		=> __( 'Search Pack', 'btnsx' ),
		        'all_items' 		=> __( 'All', 'btnsx' ),
		        'parent_item' 		=> __( 'Parent Pack', 'btnsx' ),
		        'parent_item_colon' => __( 'Parent Pack:', 'btnsx' ),
		        'edit_item' 		=> __( 'Edit Pack', 'btnsx' ),
		        'update_item' 		=> __( 'Update Pack', 'btnsx' ),
		        'add_new_item' 		=> __( 'Add New Pack', 'btnsx' ),
		        'new_item_name' 	=> __( 'New Pack Name', 'btnsx' ),
		        'menu_name' 		=> __( 'Packs', 'btnsx' )
		    );
		    $args = array(
		    	'public' 			=> false,
		        'hierarchical' 		=> true,
		        'labels' 			=> $labels,
		        'show_ui' 			=> true,
		        'show_admin_column' => true,
		        'query_var' 		=> true,
		        'show_in_nav_menus' => false,
		        'rewrite' 			=> array( 'slug' => 'btnsx_pack' ),
		    );
		    register_taxonomy( 'btnsx_pack', array( 'buttons-x' ), $args );
		    // Add new taxonomy, not hierarchical (like tags)
		    $labels = array(
		        'name' 				=> _x( 'Tags', 'btnsx' ),
		        'singular_name' 	=> _x( 'Tag', 'btnsx' ),
		        'search_items' 		=> __( 'Search Tag', 'btnsx' ),
		        'all_items' 		=> __( 'All', 'btnsx' ),
		        'parent_item' 		=> __( 'Parent Tag', 'btnsx' ),
		        'parent_item_colon' => __( 'Parent Tag:', 'btnsx' ),
		        'edit_item' 		=> __( 'Edit Tag', 'btnsx' ),
		        'update_item' 		=> __( 'Update Tag', 'btnsx' ),
		        'add_new_item' 		=> __( 'Add New Tag', 'btnsx' ),
		        'new_item_name' 	=> __( 'New Tag Name', 'btnsx' ),
		        'menu_name' 		=> __( 'Tags', 'btnsx' )
		    );
		    $args = array(
		    	'public' 			=> false,
		        'hierarchical' 		=> false,
		        'labels' 			=> $labels,
		        'show_ui' 			=> true,
		        'show_admin_column' => true,
		        'query_var' 		=> true,
		        'show_in_nav_menus' => false,
		        'rewrite' 			=> array( 'slug' => 'btnsx_tag' ),
		    );
		    register_taxonomy( 'btnsx_tag', array( 'buttons-x' ), $args );
		}

		/**
		* Adds the meta box container.
		* @since 0.1
		*/
		public function register_meta_boxes() {
			$screens = array('buttons-x');
			foreach ( $screens as $screen ) {
			    add_meta_box(
			        'btnsx-preview',
			        __( 'Live Preview', 'btnsx' ),
			        array( $this, 'preview_callback' ),
			        $screen,
			        'normal',
			        'high'
			    );
			    add_meta_box(
			        'btnsx-options',
			        __( 'Buttons X - Options Panel', 'btnsx' ),
			        array( $this, 'options_callback' ),
			        $screen,
			        'normal',
			        'core'
			    );
			    add_meta_box(
			        'btnsx-preview-settings',
			        __( 'Buttons X - Preview Settings', 'btnsx' ),
			        array( $this, 'preview_settings_callback' ),
			        $screen,
			        'side',
			        'high'
			    );
			    add_meta_box(
			        'btnsx-override-style',
			        __( 'Buttons X - Override Style', 'btnsx' ),
			        array( $this, 'override_style_callback' ),
			        $screen,
			        'side',
			        'default'
			    );
			    add_meta_box(
			        'btnsx-shortcode',
			        __( 'Buttons X - Short Code', 'btnsx' ),
			        array( $this, 'shortcode_callback' ),
			        $screen,
			        'side',
			        'high'
			    );
			    add_meta_box(
			        'btnsx-hide-buttons',
			        __( 'Buttons X - Hide Button', 'btnsx' ),
			        array( $this, 'hide_buttons_callback' ),
			        $screen,
			        'side',
			        'high'
			    );
			    // add_meta_box(
			    //     'btnsx-display-button',
			    //     __( 'Buttons X - Display Button', 'btnsx' ),
			    //     array( $this, 'display_button_callback' ),
			    //     $screen,
			    //     'side',
			    //     'default'
			    // );
			    if ( class_exists( 'GFForms' ) ) {
				    add_meta_box(
				        'btnsx-gravity-forms',
				        __( 'Buttons X - Gravity Forms', 'btnsx' ),
				        array( $this, 'gravity_forms_callback' ),
				        $screen,
				        'side',
				        'high'
				    );
				}
			}
		}

		/**
		 * Adds a box to the main column on the Post and Page edit screens.
		 * @since  1.3
		 * @return string
		 */
		public function gravity_forms_callback( $post ) {
			// Add a nonce field so we can check for it later.
			wp_nonce_field( 'btnsx_gravity_forms_meta', 'btnsx_gravity_forms_meta_nonce' );

			$meta_values = array();
	        $meta_values = get_post_meta( $post->ID, 'btnsx', true );

	        $gf_options = array();
	        $gf_options['none'] = __( 'None', 'btnsx' );
	        $forms = RGFormsModel::get_forms( null, 'title' );

	        foreach ($forms as $form) {
	        	$gf_options[$form->id] = $form->title;
	        }

			$btnsx_form = new BtnsxFormElements();
			echo '<div style="min-height:106px;"><div class="btnsx btnsx-side">';
			echo $btnsx_form->input( array(
	        		'type'			=>	'select',
					'size'			=>	'12',
					'id'			=>	'btnsx_opt_gravity_form_id',
					'name'			=>	'btnsx_opt_gravity_form_id',
					'class'			=>	'btnsx-select',
					'label'			=>	__( 'Replace form button for', 'btnsx' ),
					'tooltip'		=>	__( 'Select a form to override submit button.', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_gravity_form_id' ) ),
					'options'		=>	$gf_options
				)
        	);
        	echo '<br/></div></div>';
		}

		/**
	     * Prints the box content.
	     * @param WP_Post $post The object for the current post/page.
	     * @since 0.1
	     */
	    public function shortcode_callback( $post ) {
	    	$current_color = get_user_option( 'admin_color' );
	    	global $_wp_admin_css_colors;
	        echo '<p style="font-weight:bold;color:'.$_wp_admin_css_colors[$current_color]->colors[2].';">[btnsx id="'.$post->ID.'"]</p>';
	    }

		/**
		 * remove extra meta boxes on custom post page
		 * @since 0.1
		 */
		public function remove_extra_meta_boxes() {
		    if( get_post_type() == 'buttons-x' ){
		        $meta_boxes_advanced = $this->get_meta_boxes( 'buttons-x', 'advanced' );
		        $meta_boxes_normal = $this->get_meta_boxes( 'buttons-x', 'normal' );
		        $meta_boxes_side = $this->get_meta_boxes( 'buttons-x', 'side' );
		        $meta_advanced = apply_filters( 'btnsx_button_meta_boxes_advanced', array( 'btnsx-analytic' ) );
		        $meta_normal = apply_filters( 'btnsx_button_meta_boxes_normal', array( 'btnsx-preview', 'btnsx-options' ) );
		        $meta_side = apply_filters( 'btnsx_button_meta_boxes_side', array( 'submitdiv', 'btnsx_packdiv', 'tagsdiv-btnsx_tag', 'btnsx-override-style', 'btnsx-preview-settings', 'btnsx-shortcode', 'btnsx-gravity-forms', 'btnsx-hide-buttons', 'btnsx-display-button' ) );
		        foreach ( $meta_boxes_advanced as $key => $value ) {
		            foreach ( $value as $k => $v ) {
		                if( !in_array( $v['id'], $meta_advanced )  ){
		                    remove_meta_box( $v['id'] , 'buttons-x' , 'advanced' );
		                }
		            }
		        }
		        foreach ($meta_boxes_normal as $key => $value) {
		            foreach ($value as $k => $v) {
		                if( !in_array($v['id'], $meta_normal)  ){
		                    remove_meta_box( $v['id'] , 'buttons-x' , 'normal' );
		                }
		            }
		        }
		        foreach ($meta_boxes_side as $key => $value) {
		            foreach ($value as $k => $v) {
		                if( !in_array($v['id'], $meta_side)  ){
		                    remove_meta_box( $v['id'] , 'buttons-x' , 'side' );
		                }
		            }
		        }
		    }
		}

		/**
		 * Extract meta boxes information
		 * @param  string $screen  target page
		 * @param  string $context part of page where meta box is shown
		 * @return array          list of meta boxes on the target page
		 * @since 0.1
		 */
		public function get_meta_boxes( $screen = null, $context = 'advanced' ) {
		    global $wp_meta_boxes;
		    if ( empty( $screen ) ) {
		        $screen = get_current_screen();
		    } elseif ( is_string( $screen ) ) {
		        $screen = convert_to_screen( $screen );
		    }
		    $page = $screen->id;
		    if( isset( $wp_meta_boxes[ $page ][ $context ] ) ) {
		    	return $wp_meta_boxes[ $page ][ $context ];
		    } else {
		    	return array();
		    }
		}

		/**
	     * Prints the box content.
	     * @param WP_Post $post The object for the current post/page.
	     * @since 0.1
	     */
	    public function preview_callback( $post ) {
	    	$btnsx_settings = array(
	    		'material_admin_theme' => false,
	    		'wp_admin_theme' => true,
	    	);
	    	$current_color = get_user_option( 'admin_color' );
	    	global $_wp_admin_css_colors;
	    	if( $btnsx_settings['material_admin_theme'] == true ) :
	        ?>
	        <!-- Material Style For Admin Page -->
	        <style type="text/css">
	        	/*#poststuff h3 {
				  background-color: #ee6e73;
				  color: #fff;
				}*/
				.wp-core-ui .button-primary {
				  background: #26a69a;
				  border-color: #26a69a;
				  -webkit-box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.16), 0 2px 10px 0 rgba(0, 0, 0, 0.12);
				  box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.16), 0 2px 10px 0 rgba(0, 0, 0, 0.12);
				  color: #fff;
				  text-decoration: none;
				}
				.wp-core-ui .button-primary.focus, .wp-core-ui .button-primary.hover, .wp-core-ui .button-primary:focus, .wp-core-ui .button-primary:hover {
				  background: #2bbbad;
				  border-color: #2bbbad;
				  -webkit-box-shadow: 0 5px 11px 0 rgba(0, 0, 0, 0.18), 0 4px 15px 0 rgba(0, 0, 0, 0.15);
				  box-shadow: 0 5px 11px 0 rgba(0, 0, 0, 0.18), 0 4px 15px 0 rgba(0, 0, 0, 0.15);
				  color: #fff;
				}
				.btnsx-tabs nav li.tab-current a {
				  color: #ee6e73;
				}
				#all-plugins-table .plugins a.delete, #media-items a.delete, #media-items a.delete-permanently, #nav-menu-footer .menu-delete, #search-plugins-table .plugins a.delete, .plugins a.delete, .row-actions span.delete a, .row-actions span.spam a, .row-actions span.trash a, .submitbox .submitdelete {
				  color: #ee6e73;
				}
	        </style>
	        <?php
	        endif;
	        if( $btnsx_settings['wp_admin_theme'] == true ) :
	        ?>
	        <style type="text/css">
	        	/*#poststuff h3 {
				  background-color: <?php echo $_wp_admin_css_colors[$current_color]->colors[2]; ?>;
				  color: #fff;
				}*/
				.btnsx-tabs nav li.tab-current a {
				  color: <?php echo sanitize_text_field( $_wp_admin_css_colors[$current_color]->colors[3] ); ?>;
				}
				.ball-pulse>div {
				  background-color: <?php echo sanitize_text_field( $_wp_admin_css_colors[$current_color]->colors[3] ); ?>;
				}
				.btnsx .collapsible-header.active i {
					color: <?php echo sanitize_text_field( $_wp_admin_css_colors[$current_color]->colors[3] ); ?>;
				}
	        </style>
	        <?php
	        endif;
	        ?>
	        <!-- Responsive View -->
	        <div id="btnsx-responsive-bar">
	        	<a href="javascript:void(0)" id="btnsx-responsive-bar-desktop" class="btnsx-responsive-bar-item btnsx-bar-tooltip tooltipster active" data-tooltip="<?php _e('Desktop','btnsx'); ?>"><i class="fas fa-desktop"></i></a>
	        	<a href="javascript:void(0)" id="btnsx-responsive-bar-tablet" class="btnsx-responsive-bar-item btnsx-bar-tooltip tooltipster" data-tooltip="<?php _e('Tablet','btnsx'); ?>"><i class="fas fa-tablet-alt"></i></a>
	        	<a href="javascript:void(0)" id="btnsx-responsive-bar-mobile" class="btnsx-responsive-bar-item btnsx-bar-tooltip tooltipster" data-tooltip="<?php _e('Mobile','btnsx'); ?>"><i class="fas fa-mobile-alt"></i></a>
	        </div>
	        <script type="text/javascript">
	        	jQuery(document).ready(function($){
	        		$( '.btnsx-bar-tooltip' ).each( function() {
	        			var tipText = $( this ).attr( 'data-tooltip' );
				        $(this).tooltipster({
				          	content: tipText,
				          	animation: 'fade',
				          	position: 'top',
				          	delay: 50,
				          	theme: 'tooltipster-default',
				          	trigger: 'hover',
				          	interactive: true,
				          	maxWidth: 400
				      	});
				    });
	        	});
	        </script>
	        <!-- Overlay -->
	        <div id="btnsx-preview-overlay"></div>
	        <!-- Loader -->
	        <div id="btnsx-preview-container" class="btnsx">
	        	<div id="btnsx-preview-loader" class="loader-inner ball-pulse">
	        		<div></div>
	        		<div></div>
	        		<div></div>
	        	</div>
	        	<style type="text/css" id="btnsx-preview-btn-css"></style>
	        	<a id="btnsx-preview-btn" class="btnsx-btn" href="#" style="padding:10px 40px;display:none;">
		    		<span id="btnsx-btn-divider" class="btnsx-divider"></span>
		    		<i id="btnsx-btn-icon" class="btnsx-btn-icon btnsx-icon-prev btnsx-icon-hide"></i>
		    		<span id="btnsx-btn-text" class="btnsx-text-primary">button</span>
		    		<i id="btnsx-btn-icon" class="btnsx-btn-icon btnsx-icon-next btnsx-icon-hide"></i>
		    		<span id="btnsx-btn-text-secondary" class="btnsx-text-secondary" style="display:none;"></span>
		    	</a>
	        </div>

	    	<?php
	    }

	    /**
	     * Function to properly return gradient values
	     * @since  0.1
	     * @param  int    	 $post_id
	     * @param  string    $meta_key - post meta key
	     * @param  string    $id - form fields id prefix
	     * @param  string    $label - Collapsible header text
	     * @param  int    	 $key  -  count
	     * @param  array     $fields  -  gradient value keys
	     * @return array
	     */
		public function gradient_options( $post_id, $meta_key = 'btnsx_gradient_stop_normal', $id = 'btnsx_opt_gradient_stop_normal', $label = '', $key = 0, $fields = array()  ) {

			$defaults = array(
				'color'			=>	'',
				'location'		=>	'',
				'copy_text' 	=> '',
				'copy_ids' 		=>	array(),
				'copy_class'	=>	''
			);

			$result = array_merge( $defaults, $fields );

        	$step = $key + 1;
    		$gradient_options = array(
				'id'			=>	$id . $step,
				'text'			=>	__( $label, 'btnsx' ),
				'multiple'		=>	true,
				'clone_class'	=>	$meta_key,
				'copy'			=>	true,
				'copy_text'		=>	$result['copy_text'],
				'copy_ids'		=>	$result['copy_ids'],
				'copy_class'	=>	$result['copy_class'],
				'elements'		=> array(
					array(
						'type'			=>	'gradient',
						'id'			=>	$id . $step,
						'name'			=>	$id,
						'placeholder'	=>	' ',
						'tooltip'		=>	array(
							'color' 		=> __( 'Set gradient stop color.', 'btnsx' ),
					    	'location' 		=> __( 'Set gradient stop location. Must be between 0 and 100.', 'btnsx' )
						),
					    'value' 		=> array(
					    	'color' 		=> $result['color'],
					    	'location' 		=> $result['location']
					    )
					)
				)
			);
			return $gradient_options;
		}

	    /**
	     * Function to properly return box shadow values
	     * @since  0.1
	     * @param  int    	 $post_id
	     * @param  string    $meta_key - post meta key
	     * @param  string    $id - form fields id prefix
	     * @param  string    $label - Collapsible header text
	     * @param  int    	 $key  -  count
	     * @param  array     $fields  -  box shadow keys
	     * @return array
	     */
		public function box_shadow_options( $post_id, $meta_key = 'btnsx_box_shadow_normal', $id = 'btnsx_opt_box_shadow_normal', $label = '', $key = 0, $fields = array()  ) {

			$defaults = array(
				'horizontal'	=>	'',
				'vertical'		=>	'',
				'blur'			=>	'',
				'spread'		=>	'',
				'position'		=>	'',
				'color'			=>	'',
				'copy_text'		=>	'',
				'copy_ids'		=>	array()
			);

			$result = array_merge( $defaults, $fields );

        	$step = $key + 1;
    		$box_shadow_options = array(
				'id'			=>	$id . $step,
				'text'			=>	__( $label, 'btnsx' ),
				'multiple'		=>	true,
				'clone_class'	=>	$meta_key,
				'copy'			=>	true,
				'copy_text'		=>	$result['copy_text'],
				'copy_ids'		=>	$result['copy_ids'],
				'elements'		=> array(
					array(
						'type'			=>	'box-shadow',
						'id'			=>	$id . $step,
						'name'			=>	$id,
						'placeholder'	=>	' ',
						'tooltip'		=>	array(
							'horizontal' 	=> __( 'Set horizontal shadow in pixels.', 'btnsx' ),
					    	'vertical' 		=> __( 'Set vertical shadow in pixels.', 'btnsx' ),
					    	'blur' 			=> __( 'Set blur radius in pixels.', 'btnsx' ),
					    	'spread' 		=> __( 'Set shadow spread in pixels.', 'btnsx' ),
					    	'position' 		=> __( 'Select shadow postion.', 'btnsx' ),
					    	'color' 		=> __( 'Set shadow color.', 'btnsx' ),
						),
					    'value' 		=> array(
					    	'horizontal' 	=> $result['horizontal'],
					    	'vertical' 		=> $result['vertical'],
					    	'blur' 			=> $result['blur'],
					    	'spread' 		=> $result['spread'],
					    	'position' 		=> $result['position'],
					    	'color' 		=> $result['color']
					    )
					)
				)
			);
			return $box_shadow_options;
		}

		/**
	     * Function to properly return custom menu link values
	     * @since  0.1
	     * @param  int    	 $post_id
	     * @param  string    $meta_key - post meta key
	     * @param  string    $id - form fields id prefix
	     * @param  string    $label - Collapsible header text
	     * @param  int    	 $key  -  count
	     * @param  array     $fields  -  link value keys
	     * @return array
	     */
		public function menu_custom_link_options( $post_id, $meta_key = 'btnsx_link_menu_custom', $id = 'btnsx_opt_link_menu_custom', $label = '', $key = 0, $fields = array()  ) {

			$defaults = array(
				'label'			=>	'',
				'url'		=>	'',
			);

			$result = array_merge( $defaults, $fields );

        	$step = $key + 1;
    		$cml_options = array(
				'id'			=>	$id . $step,
				'text'			=>	__( $label, 'btnsx' ),
				'multiple'		=>	true,
				'clone_class'	=>	$meta_key,
				'elements'		=> array(
					array(
						'type'			=>	'text',
						'id'			=>	$id . $step . '_label',
						'name'			=>	$id.'_label[]',
						'placeholder'	=>	' ',
						'label'			=>	__( 'Label', 'btnsx' ),
						'tooltip'		=>	__( 'Add label text.', 'btnsx' ),
						'value'			=>	$result['label']
					),
					array(
						'type'			=>	'text',
						'id'			=>	$id . $step . '_url',
						'name'			=>	$id.'_url[]',
						'placeholder'	=>	' ',
						'label'			=>	__( 'URL', 'btnsx' ),
						'tooltip'		=>	__( 'Add a custom link.', 'btnsx' ),
						'value'			=>	$result['url']
					),
				)
			);
			return $cml_options;
		}

		/**
		 * Fetch meta values
		 * @since  0.1
		 * @param  int   	$post_id ID for the current post/page.
		 * @param  array    $params
		 * @return string
		 */
		public function meta_values( $post_id, $params = array( 'field' => '', 'field2' => '', 'value' => '' ) ) {
			/*
	         * Use get_post_meta() to retrieve an existing value
	         * from the database and use the value for the form.
	         */
	        $meta_values = array();
	        $meta_values = get_post_meta( $post_id, 'btnsx', true );

	        // meta key value
	        $field = isset( $params['field'] ) ? $params['field'] : '';
	        // meta key value in case stored as an array
	        $field2 = isset( $params['field2'] ) ? $params['field2'] : '';
	        // value in case meta value is not defined
	        $value = isset( $params['value'] ) ? $params['value'] : '';

	        // Based on defined parameters set value
	        if ( $field != '' && $field2 == '' ){
	        	$meta_value = isset( $meta_values[$field] ) ? $meta_values[$field] : $value;
	        } elseif ( $field != '' && $field2 != '' ) {
	        	$meta_value = isset( $meta_values[$field][$field2] ) ? $meta_values[$field][$field2] : $value;
	        } else {
	        	$meta_value = '';
	        }

	        return $meta_value;
		}

	    /**
	     * Prints the box content.
	     * @param WP_Post $post The object for the current post/page.
	     * @since 0.1
	     */
	    public function options_callback( $post ) {

	        // Add an nonce field so we can check for it later.
	        wp_nonce_field( 'btnsx', 'btnsx_options_nonce' );

	        /*
	         * Use get_post_meta() to retrieve an existing value
	         * from the database and use the value for the form.
	         */

	        	// Custom Options
			        $meta_values = array();
			        $meta_values = get_post_meta( $post->ID, 'btnsx', true );

			        // Configure Box Shadow Options
			        $box_shadow_options = array();
			        $shadow_key = 'btnsx_box_shadow_normal';
			        $shadow_id  = 'btnsx_opt_box_shadow_normal';
			        if( isset( $meta_values[$shadow_key]['horizontal'] ) && $meta_values[$shadow_key]['horizontal'] != '' ){
			        	$shadow_horizontal 	= unserialize( $meta_values[$shadow_key]['horizontal'] );
			        	$shadow_vertical 	= unserialize( $meta_values[$shadow_key]['vertical'] );
			        	$shadow_blur 		= unserialize( $meta_values[$shadow_key]['blur'] );
			        	$shadow_spread 		= unserialize( $meta_values[$shadow_key]['spread'] );
			        	$shadow_position 	= unserialize( $meta_values[$shadow_key]['position'] );
			        	$shadow_color 		= unserialize( $meta_values[$shadow_key]['color'] );
			        	$bsStep = 1;
			        	foreach( $shadow_horizontal as $key => $label ){
			        		$fields = array(
			        			'horizontal'	=>	isset( $shadow_horizontal[$key] ) ? $shadow_horizontal[$key] : '',
								'vertical'		=>	isset( $shadow_vertical[$key] ) ? $shadow_vertical[$key] : '',
								'blur'			=>	isset( $shadow_blur[$key] ) ? $shadow_blur[$key] : '',
								'spread'		=>	isset( $shadow_spread[$key] ) ? $shadow_spread[$key] : '',
								'position'		=>	isset( $shadow_position[$key] ) ? $shadow_position[$key] : '',
								'color'			=>	isset( $shadow_color[$key] ) ? $shadow_color[$key] : '',
								'copy_text'		=>	'hover',
								'copy_ids'		=>	array(
									'highlight'		=>	'#btnsx_opt_box_shadow_hover'.$bsStep.'_header,#btnsx_opt_box_shadow_hover'.$bsStep.'_body',
									'old_input'		=>	'#btnsx_opt_box_shadow_normal'.$bsStep.'_horizontal,#btnsx_opt_box_shadow_normal'.$bsStep.'_vertical,#btnsx_opt_box_shadow_normal'.$bsStep.'_blur,#btnsx_opt_box_shadow_normal'.$bsStep.'_spread',
									'new_input'		=>	'#btnsx_opt_box_shadow_hover'.$bsStep.'_horizontal,#btnsx_opt_box_shadow_hover'.$bsStep.'_vertical,#btnsx_opt_box_shadow_hover'.$bsStep.'_blur,#btnsx_opt_box_shadow_hover'.$bsStep.'_spread',
									'old_select'	=>	'#btnsx_opt_box_shadow_normal'.$bsStep.'_position',
									'new_select'	=>	'#btnsx_opt_box_shadow_hover'.$bsStep.'_position',
									'old_color'		=>	'#btnsx_opt_box_shadow_normal'.$bsStep.'_color',
									'new_color'		=>	'#btnsx_opt_box_shadow_hover'.$bsStep.'_color'
								),
			        		);
			        		$box_shadow_options[] 	= $this->box_shadow_options( $post->ID, $shadow_key, $shadow_id, 'Normal', $key, $fields );
			        		$bsStep++;
			        	}
			        } else {
			        	$fields = array(
		        			'horizontal'	=>	'',
							'vertical'		=>	'',
							'blur'			=>	'',
							'spread'		=>	'',
							'position'		=>	'',
							'color'			=>	'',
							'copy_text'		=>	'hover',
							'copy_ids'		=>	array(
								'highlight'		=>	'#btnsx_opt_box_shadow_hover1_header,#btnsx_opt_box_shadow_hover1_body',
								'old_input'		=>	'#btnsx_opt_box_shadow_normal1_horizontal,#btnsx_opt_box_shadow_normal1_vertical,#btnsx_opt_box_shadow_normal1_blur,#btnsx_opt_box_shadow_normal1_spread',
								'new_input'		=>	'#btnsx_opt_box_shadow_hover1_horizontal,#btnsx_opt_box_shadow_hover1_vertical,#btnsx_opt_box_shadow_hover1_blur,#btnsx_opt_box_shadow_hover1_spread',
								'old_select'	=>	'#btnsx_opt_box_shadow_normal1_position',
								'new_select'	=>	'#btnsx_opt_box_shadow_hover1_position',
								'old_color'		=>	'#btnsx_opt_box_shadow_normal1_color',
								'new_color'		=>	'#btnsx_opt_box_shadow_hover1_color'
							),
		        		);
			        	$box_shadow_options[] = $this->box_shadow_options( $post->ID, $shadow_key, $shadow_id, __( 'Normal', 'btnsx' ), 0, $fields );
			        }
			        $shadow_key_hover = 'btnsx_box_shadow_hover';
			        $shadow_id_hover  = 'btnsx_opt_box_shadow_hover';
			        if( isset( $meta_values[$shadow_key_hover]['horizontal'] ) && $meta_values[$shadow_key_hover]['horizontal'] != '' ){
			        	$shadow_horizontal 	= unserialize( $meta_values[$shadow_key_hover]['horizontal'] );
			        	$shadow_vertical 	= unserialize( $meta_values[$shadow_key_hover]['vertical'] );
			        	$shadow_blur 		= unserialize( $meta_values[$shadow_key_hover]['blur'] );
			        	$shadow_spread 		= unserialize( $meta_values[$shadow_key_hover]['spread'] );
			        	$shadow_position 	= unserialize( $meta_values[$shadow_key_hover]['position'] );
			        	$shadow_color 		= unserialize( $meta_values[$shadow_key_hover]['color'] );
			        	$bsStep = 1;
			        	foreach( $shadow_horizontal as $key => $label ){
			        		$fields = array(
			        			'horizontal'	=>	isset( $shadow_horizontal[$key] ) ? $shadow_horizontal[$key] : '',
								'vertical'		=>	isset( $shadow_vertical[$key] ) ? $shadow_vertical[$key] : '',
								'blur'			=>	isset( $shadow_blur[$key] ) ? $shadow_blur[$key] : '',
								'spread'		=>	isset( $shadow_spread[$key] ) ? $shadow_spread[$key] : '',
								'position'		=>	isset( $shadow_position[$key] ) ? $shadow_position[$key] : '',
								'color'			=>	isset( $shadow_color[$key] ) ? $shadow_color[$key] : '',
								'copy_text'		=>	'normal',
								'copy_ids'		=>	array(
									'highlight'		=>	'#btnsx_opt_box_shadow_normal'.$bsStep.'_header,#btnsx_opt_box_shadow_normal'.$bsStep.'_body',
									'old_input'		=>	'#btnsx_opt_box_shadow_hover'.$bsStep.'_horizontal,#btnsx_opt_box_shadow_hover'.$bsStep.'_vertical,#btnsx_opt_box_shadow_hover'.$bsStep.'_blur,#btnsx_opt_box_shadow_hover'.$bsStep.'_spread',
									'new_input'		=>	'#btnsx_opt_box_shadow_normal'.$bsStep.'_horizontal,#btnsx_opt_box_shadow_normal'.$bsStep.'_vertical,#btnsx_opt_box_shadow_normal'.$bsStep.'_blur,#btnsx_opt_box_shadow_normal'.$bsStep.'_spread',
									'old_select'	=>	'#btnsx_opt_box_shadow_hover'.$bsStep.'_position',
									'new_select'	=>	'#btnsx_opt_box_shadow_normal'.$bsStep.'_position',
									'old_color'		=>	'#btnsx_opt_box_shadow_hover'.$bsStep.'_color',
									'new_color'		=>	'#btnsx_opt_box_shadow_normal'.$bsStep.'_color'
								),
			        		);
			        		$box_shadow_options[] 	= $this->box_shadow_options( $post->ID, $shadow_key_hover, $shadow_id_hover, 'Hover', $key, $fields );
			        	}
			        } else {
			        	$fields = array(
		        			'horizontal'	=>	'',
							'vertical'		=>	'',
							'blur'			=>	'',
							'spread'		=>	'',
							'position'		=>	'',
							'color'			=>	'',
							'copy_text'		=>	'normal',
							'copy_ids'		=>	array(
								'highlight'		=>	'#btnsx_opt_box_shadow_normal1_header,#btnsx_opt_box_shadow_normal1_body',
								'old_input'		=>	'#btnsx_opt_box_shadow_hover1_horizontal,#btnsx_opt_box_shadow_hover1_vertical,#btnsx_opt_box_shadow_hover1_blur,#btnsx_opt_box_shadow_hover1_spread',
								'new_input'		=>	'#btnsx_opt_box_shadow_normal1_horizontal,#btnsx_opt_box_shadow_normal1_vertical,#btnsx_opt_box_shadow_normal1_blur,#btnsx_opt_box_shadow_normal1_spread',
								'old_select'	=>	'#btnsx_opt_box_shadow_hover1_position',
								'new_select'	=>	'#btnsx_opt_box_shadow_normal1_position',
								'old_color'		=>	'#btnsx_opt_box_shadow_hover1_color',
								'new_color'		=>	'#btnsx_opt_box_shadow_normal1_color'
							),
		        		);
			        	$box_shadow_options[] = $this->box_shadow_options( $post->ID, $shadow_key_hover, $shadow_id_hover, __( 'Hover', 'btnsx' ), 0, $fields );
			        }
					$box_shadow_options[] = array(
						'text'		=>	__( 'CSS', 'btnsx' ),
						'elements'		=> array(
							array(
								'type'			=>	'editor',
								'id'			=>	'btnsx_opt_box_shadow_css_normal',
								'name'			=>	'btnsx_opt_box_shadow_css_normal',
								'placeholder'	=>	' ',
								'label'			=>	__( 'Normal', 'btnsx' ),
								'tooltip' 		=> __( 'Set custom box shadow CSS.', 'btnsx' ),
								'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_box_shadow_css_normal' ) )
							),
							array(
								'type'			=>	'editor',
								'id'			=>	'btnsx_opt_box_shadow_css_hover',
								'name'			=>	'btnsx_opt_box_shadow_css_hover',
								'placeholder'	=>	' ',
								'label'			=>	__( 'Hover', 'btnsx' ),
								'tooltip' 		=> __( 'Set custom box shadow CSS for when button is hovered.', 'btnsx' ),
								'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_box_shadow_css_hover' ) )
							)
						)
					);

					// Configure Gradient Options
					$gradient_options = array();
					// type
					$gradient_options[] = array(
						'text'		=>	__( 'Type', 'btnsx' ),
						'id'		=>	'btnsx_gradient_type_normal_collapsible',
						'elements'		=> array(
							array(
								'type'			=>	'select',
								'id'			=>	'btnsx_opt_gradient_type_normal',
								'name'			=>	'btnsx_opt_gradient_type_normal',
								'label'			=>	__( 'Normal', 'btnsx' ),
								'tooltip'		=>	__( 'Select gradient type.', 'btnsx' ),
								'options'		=>	array(
									'none'				=>	__( 'None', 'btnsx' ),
									'vertical'			=>	__( 'Vertical ↓', 'btnsx' ),
									'horizontal'		=>	__( 'Horizontal →', 'btnsx' ),
									'diagonal_top'		=>	__( 'Diagonal ↘', 'btnsx' ),
									'diagonal_bottom'	=>	__( 'Diagonal ↗', 'btnsx' ),
									'radial'			=>	__( 'Radial ○', 'btnsx' )
								),
								'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_gradient_type_normal' ) ),
								'copy'			=>	true,
								'copy_text'		=>	'hover',
								'copy_ids'		=>	array(
									'highlight'		=>	'#btnsx_gradient_type_normal_collapsible_body',
									'old_select'	=>	'#btnsx_opt_gradient_type_normal',
									'new_select'	=>	'#btnsx_opt_gradient_type_hover'
								)
							),
							array(
								'type'			=>	'select',
								'id'			=>	'btnsx_opt_gradient_type_hover',
								'name'			=>	'btnsx_opt_gradient_type_hover',
								'label'			=>	__( 'Hover', 'btnsx' ),
								'tooltip'		=>	__( 'Select gradient type for when button will be hovered.', 'btnsx' ),
								'options'		=>	array(
									'none'				=>	__( 'None', 'btnsx' ),
									'vertical'			=>	__( 'Vertical ↓', 'btnsx' ),
									'horizontal'		=>	__( 'Horizontal →', 'btnsx' ),
									'diagonal_top'		=>	__( 'Diagonal ↘', 'btnsx' ),
									'diagonal_bottom'	=>	__( 'Diagonal ↗', 'btnsx' ),
									'radial'			=>	__( 'Radial ○', 'btnsx' )
								),
								'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_gradient_type_hover' ) ),
								'copy'			=>	true,
								'copy_text'		=>	'normal',
								'copy_ids'		=>	array(
									'highlight'		=>	'#btnsx_gradient_type_normal_collapsible_body',
									'old_select'	=>	'#btnsx_opt_gradient_type_hover',
									'new_select'	=>	'#btnsx_opt_gradient_type_normal'
								)
							),
						)
					);
			        $gradient_key = 'btnsx_gradient_stop_normal';
			        $gradient_id  = 'btnsx_opt_gradient_stop_normal';
			        if( isset( $meta_values[$gradient_key]['color'] ) && $meta_values[$gradient_key]['color'] != '' ){
			        	$gradient_color 	= unserialize( $meta_values[$gradient_key]['color'] );
			        	$gradient_location 	= unserialize( $meta_values[$gradient_key]['location'] );
			        	$gStep = 1;
			        	foreach( $gradient_color as $key => $label ){
			        		$fields = array(
			        			'color'		=>	isset( $gradient_color[$key] ) ? $gradient_color[$key] : '',
								'location'	=>	isset( $gradient_location[$key] ) ? $gradient_location[$key] : '',
								'copy_text'		=>	'hover',
								'copy_ids'		=>	array(
									'highlight'		=>	'#btnsx_opt_gradient_stop_hover'.$gStep.'_header,#btnsx_opt_gradient_stop_hover'.$gStep.'_body',
									'old_input'		=>	'#btnsx_opt_gradient_stop_normal'.$gStep.'_location',
									'new_input'		=>	'#btnsx_opt_gradient_stop_hover'.$gStep.'_location',
									'old_color'		=>	'#btnsx_opt_gradient_stop_normal'.$gStep.'_color',
									'new_color'		=>	'#btnsx_opt_gradient_stop_hover'.$gStep.'_color'
								),
								'copy_class'		=>	'gradient-normal-copy',
			        		);
			        		$gradient_options[] = $this->gradient_options( $post->ID, $gradient_key, $gradient_id, 'Stop (Normal)', $key, $fields );
			        		$gStep++;
			        	}
			        } else {
			        	$fields = array(
		        			'color'		=>	'',
							'location'	=>	'',
							'copy_text'		=>	'hover',
							'copy_ids'		=>	array(
								'highlight'		=>	'#btnsx_opt_gradient_stop_hover1_header,#btnsx_opt_gradient_stop_hover1_body',
								'old_input'		=>	'#btnsx_opt_gradient_stop_normal1_location',
								'new_input'		=>	'#btnsx_opt_gradient_stop_hover1_location',
								'old_color'		=>	'#btnsx_opt_gradient_stop_normal1_color',
								'new_color'		=>	'#btnsx_opt_gradient_stop_hover1_color'
							),
							'copy_class'		=>	'gradient-normal-copy',
		        		);
			        	$gradient_options[] 	= $this->gradient_options( $post->ID, $gradient_key, $gradient_id, __( 'Stop (Normal)', 'btnsx' ), 0, $fields );
			        }
			        $gradient_key_hover = 'btnsx_gradient_stop_hover';
			        $gradient_id_hover  = 'btnsx_opt_gradient_stop_hover';
			        if( isset( $meta_values[$gradient_key_hover]['color'] ) && $meta_values[$gradient_key_hover]['color'] != '' ){
			        	$gradient_color 	= unserialize( $meta_values[$gradient_key_hover]['color'] );
			        	$shadow_location 	= unserialize( $meta_values[$gradient_key_hover]['location'] );
			        	$gStep = 1;
			        	foreach( $gradient_color as $key => $label ){
			        		$fields = array(
			        			'color'		=>	isset( $gradient_color[$key] ) ? $gradient_color[$key] : '',
								'location'	=>	isset( $shadow_location[$key] ) ? $shadow_location[$key] : '',
								'copy_text'		=>	'normal',
								'copy_ids'		=>	array(
									'highlight'		=>	'#btnsx_opt_gradient_stop_normal'.$gStep.'_header,#btnsx_opt_gradient_stop_normal'.$gStep.'_body',
									'old_input'		=>	'#btnsx_opt_gradient_stop_hover'.$gStep.'_location',
									'new_input'		=>	'#btnsx_opt_gradient_stop_normal'.$gStep.'_location',
									'old_color'		=>	'#btnsx_opt_gradient_stop_hover'.$gStep.'_color',
									'new_color'		=>	'#btnsx_opt_gradient_stop_normal'.$gStep.'_color'
								),
								'copy_class'		=>	'gradient-hover-copy',
			        		);
			        		$gradient_options[] 	= $this->gradient_options( $post->ID, $gradient_key_hover, $gradient_id_hover, __( 'Stop (Hover)', 'btnsx' ), $key, $fields );
			        		$gStep++;
			        	}
			        } else {
			        	$fields = array(
		        			'color'		=>	'',
							'location'	=>	'',
							'copy_text'		=>	'normal',
							'copy_ids'		=>	array(
								'highlight'		=>	'#btnsx_opt_gradient_stop_normal1_header,#btnsx_opt_gradient_stop_normal1_body',
								'old_input'		=>	'#btnsx_opt_gradient_stop_hover1_location',
								'new_input'		=>	'#btnsx_opt_gradient_stop_normal1_location',
								'old_color'		=>	'#btnsx_opt_gradient_stop_hover1_color',
								'new_color'		=>	'#btnsx_opt_gradient_stop_normal1_color'
							),
							'copy_class'		=>	'gradient-hover-copy',
		        		);
			        	$gradient_options[] 	= $this->gradient_options( $post->ID, $gradient_key_hover, $gradient_id_hover, __( 'Stop (Hover)', 'btnsx' ), 0, $fields );
			        }
			        // css
					$gradient_options[] = array(
						'text'		=>	__( 'CSS', 'btnsx' ),
						'elements'		=> array(
							array(
								'type'			=>	'editor',
								'id'			=>	'btnsx_opt_gradient_css_normal',
								'name'			=>	'btnsx_opt_gradient_css_normal',
								'placeholder'	=>	' ',
								'label'			=>	__( 'Normal', 'btnsx' ),
								'tooltip'		=>	__( 'Add custom gradient CSS.', 'btnsx' ),
								'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_gradient_css_normal' ) )
							),
							array(
								'type'			=>	'editor',
								'id'			=>	'btnsx_opt_gradient_css_hover',
								'name'			=>	'btnsx_opt_gradient_css_hover',
								'placeholder'	=>	' ',
								'label'			=>	__( 'Hover', 'btnsx' ),
								'tooltip'		=>	__( 'Add custom gradient CSS for when button will be hovered.', 'btnsx' ),
								'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_box_shadow_css_hover' ) )
							)
						)
					);

					// Configure Custom Menu Link Options
					$cml_options = array();
			        $cml_key = 'btnsx_link_menu_custom';
			        $cml_id  = 'btnsx_opt_link_menu_custom';
			        if( isset( $meta_values[$cml_key]['url'] ) && $meta_values[$cml_key]['url'] != '' ){
			        	$cml_label 	= unserialize( $meta_values[$cml_key]['label'] );
			        	$cml_url 	= unserialize( $meta_values[$cml_key]['url'] );
			        	$cmlStep = 1;
			        	foreach( $cml_label as $key => $label ){
			        		$fields = array(
			        			'label'	=>	isset( $cml_label[$key] ) ? $cml_label[$key] : '',
								'url'	=>	isset( $cml_url[$key] ) ? $cml_url[$key] : '',
			        		);
			        		$cml_options[] = $this->menu_custom_link_options( $post->ID, $cml_key, $cml_id, 'Custom Menu Link', $key, $fields );
			        		$cmlStep++;
			        	}
			        } else {
			        	$fields = array(
		        			'label'	=>	'',
							'url'	=>	'',
		        		);
			        	$cml_options[] 	= $this->menu_custom_link_options( $post->ID, $cml_key, $cml_id, __( 'Custom Menu Link', 'btnsx' ), 0, $fields );
			        }

			        // add dropdown styling options
			        $cml_options[] = array(
						'id'			=>	'btnsx_opt_link_dropdown_font_style',
						'text'			=>	__( 'Dropdown Font Style', 'btnsx' ),
						'elements'		=> array(
							array(
    							'type'			=>	'font',
    							'id'			=>	'btnsx_opt_link_dropdown_font',
    							'name'			=>	'btnsx_opt_link_dropdown_font',
    							'placeholder'	=>	' ',
    							'tooltip'		=>	array(
    								'size'			=>	__( 'Add font size in pixels. This will make your menu text bigger or smaller depending up on the value specified.', 'btnsx' ),
    								'style'			=>	__( 'Select font style. This will style your menu text. Normal means as it is, italic means the text will appear slanted, oblique makes the text slanted + bold and inherit will get the style from parent element.', 'btnsx' ),
    								'weight'		=>	__( 'Select font weight. This adds weight to text like bold makes the text stronger. 100 is lightest and 900 is boldest.', 'btnsx' ),
    								'family'		=>	__( 'Select font family. Choose from among 100\'s of Google Web Fonts to style primary text.', 'btnsx' )
    							),
    							'value'			=>	array(
    								'size'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_font', 'field2' => 'size', 'value' => '14' ) ),
    								'style'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_font', 'field2' => 'style', 'value' => 'normal' ) ),
    								'weight'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_font', 'field2' => 'weight', 'value' => 'normal' ) ),
    								'family'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_font', 'field2' => 'family' ) )
    							)
    						),
						)
					);
					$cml_options[] = array(
						'id'			=>	'btnsx_opt_link_dropdown_border_style',
						'text'			=>	__( 'Dropdown Border Style', 'btnsx' ),
						'elements'		=> array(
    						array(
							    'type'			=>	'border',
							    'id'			=>	'btnsx_opt_link_dropdown_border_normal',
							    'name'			=>	'btnsx_opt_link_dropdown_border_normal',
							    'placeholder'	=>	' ',
							    'tooltip'		=>	array(
									'size'			=>	__( 'Set border size in pixels.', 'btnsx' ),
									'style'			=>	__( 'Set border style.', 'btnsx' ),
									'color'			=>	__( 'Set border color.', 'btnsx' ),
									'top'			=>	__( 'Enable/Disable top border.', 'btnsx' ),
									'bottom'		=>	__( 'Enable/Disable bottom border.', 'btnsx' ),
									'left'			=>	__( 'Enable/Disable left border.', 'btnsx' ),
									'right'			=>	__( 'Enable/Disable right border.', 'btnsx' )
								),
							    'value' 		=> array(
							    	'size' 			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'size', 'value' => '1' ) ),
							    	'style' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'style', 'value' => 'solid' ) ),
							    	'color' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'color', 'value' => '#ccc' ) ),
							    	'top' 			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'top', 'value' => '1' ) ),
							    	'bottom' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'bottom', 'value' => '1' ) ),
							    	'left' 			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'left', 'value' => '1' ) ),
							    	'right' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'right', 'value' => '1' ) )
							    )
						    ),
						)
					);
					$cml_options[] = array(
						'id'			=>	'btnsx_opt_link_dropdown_border_radius_style',
						'text'			=>	__( 'Dropdown Border Radius Style', 'btnsx' ),
						'elements'		=> array(
							array(
							    'type'		=>	'radius',
							    'id'		=>	'btnsx_opt_link_dropdown_border_normal_radius',
							    'name'		=>	'btnsx_opt_link_dropdown_border_normal_radius',
							    'tooltip'		=>	array(
									'top_left'			=>	__( 'Set top left border radius in pixels.', 'btnsx' ),
									'top_right'			=>	__( 'Set top right border radius in pixels.', 'btnsx' ),
									'bottom_left'		=>	__( 'Set bottom left border radius in pixels.', 'btnsx' ),
									'bottom_right'		=>	__( 'Set bottom right border radius in pixels.', 'btnsx' )
								),
							    'value' 	=> array(
							    	'top_left' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_border_normal_radius', 'field2' => 'top_left', 'value' => '2' ) ),
							    	'top_right' 	=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_border_normal_radius', 'field2' => 'top_right', 'value' => '2' ) ),
							    	'bottom_left' 	=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_border_normal_radius', 'field2' => 'bottom_left', 'value' => '2' ) ),
							    	'bottom_right' 	=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_dropdown_border_normal_radius', 'field2' => 'bottom_right', 'value' => '2' ) )
							    )
						    ),
						)
					);
					$cml_options[] = array(
						'id'			=>	'btnsx_opt_link_dropdown_shadow_style',
						'text'			=>	__( 'Dropdown Shadow Style', 'btnsx' ),
						'elements'		=> array(
    						array(
								'type'			=>	'checkbox',
								'id'			=>	'btnsx_opt_link_dropdown_shadow_hide',
								'name'			=>	'btnsx_opt_link_dropdown_shadow_hide',
								'label'			=>	__( 'Hide Shadow', 'btnsx' ),
								'tooltip'		=>	__( 'Hide the shadow below dropdown.', 'btnsx' ),
								'class'			=>	'btnsx-checkbox',
								'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_opt_link_dropdown_shadow_hide', 'value' => '0' ) )
							),
						)
					);

				// tab
				echo '<input type="hidden" id="btnsx_opt_tab" name="btnsx_opt_tab" value="' . $this->meta_values( $post->ID, array( 'field' => 'btnsx_tab' ) ) . '">';
				// echo '<input type="hidden" id="btnsx_opt_tab_content" name="btnsx_opt_tab_content" value="' . $this->meta_values( $post->ID, array( 'field' => 'btnsx_tab_content' ) ) . '">';
				// tab groups
				echo '<input type="hidden" id="btnsx_opt_tab_group_content" name="btnsx_opt_tab_group_content" value="' . $this->meta_values( $post->ID, array( 'field' => 'btnsx_tab_group_content', 'value' => '0' ) ) . '">';
				echo '<input type="hidden" id="btnsx_opt_tab_group_style" name="btnsx_opt_tab_group_style" value="' . $this->meta_values( $post->ID, array( 'field' => 'btnsx_tab_group_style', 'value' => '0' ) ) . '">';
				echo '<input type="hidden" id="btnsx_opt_tab_group_advanced" name="btnsx_opt_tab_group_advanced" value="' . $this->meta_values( $post->ID, array( 'field' => 'btnsx_tab_group_advanced', 'value' => '0' ) ) . '">';
				echo '<input type="hidden" id="btnsx_opt_tab_group_expert" name="btnsx_opt_tab_group_expert" value="' . $this->meta_values( $post->ID, array( 'field' => 'btnsx_tab_group_expert', 'value' => '0' ) ) . '">';

				echo '<div class="btnsx"><div id="btnsx-options-loader" class="loader-inner ball-pulse"><div></div><div></div><div></div></div></div>';

			$default_link_options = array(
				''										=> __( 'Default', 'btnsx' ),
				'none'									=> __( 'None', 'btnsx' ),
				'admin_page'							=> __( 'Admin Page', 'btnsx' ),
				'back_to_top'							=> __( 'Back To Top', 'btnsx' ),
				'buffer_share'							=> __( 'Buffer Share', 'btnsx' ),
				'delicious_share'						=> __( 'Delicious Share', 'btnsx' ),
				'digg_share'							=> __( 'Digg Share', 'btnsx' ),
				'edd_checkout'							=> __( 'EDD - Checkout', 'btnsx' ),
				'edd_straight_to_gateway'				=> __( 'EDD - Straight to Gateway', 'btnsx' ),
				'evernote_share'						=> __( 'Evernote Share', 'btnsx' ),
				'facebook_share'						=> __( 'Facebook Share', 'btnsx' ),
				'google_share'							=> __( 'Google+ Share', 'btnsx' ),
				'google_bookmarks_share'				=> __( 'Google Bookmarks Share', 'btnsx' ),
				'home_page'								=> __( 'Home Page', 'btnsx' ),
				'linkedin_share'						=> __( 'LinkedIn Share', 'btnsx' ),
				'login'									=> __( 'Login Page', 'btnsx' ),
				'login_redirect_current_page'			=> __( 'Login - Redirect to Current Page', 'btnsx' ),
				'login_redirect_home_page'				=> __( 'Login - Redirect to Home Page', 'btnsx' ),
				'login_redirect_custom_page'			=> __( 'Login - Redirect to Custom Page', 'btnsx' ),
				'logout'								=> __( 'Logout Page', 'btnsx' ),
				'logout_redirect_current_page'			=> __( 'Logout - Redirect to Current Page', 'btnsx' ),
				'logout_redirect_home_page'				=> __( 'Logout - Redirect to Home Page', 'btnsx' ),
				'logout_redirect_custom_page'			=> __( 'Logout - Redirect to Custom Page', 'btnsx' ),
				'lost_password'							=> __( 'Lost Password Page', 'btnsx' ),
				'lost_password_redirect_current_page'	=> __( 'Lost Password - Redirect to Current Page', 'btnsx' ),
				'lost_password_redirect_home_page'		=> __( 'Lost Password - Redirect to Home Page', 'btnsx' ),
				'lost_password_redirect_custom_page'	=> __( 'Lost Password - Redirect to Custom Page', 'btnsx' ),
				'mailto'								=> __( 'Mail To', 'btnsx' ),
				'menu'									=> __( 'Menu', 'btnsx' ),
				'newsvine_share'						=> __( 'Newsvine Share', 'btnsx' ),
				'next_post'								=> __( 'Next Post', 'btnsx' ),
				'pinterest_share'						=> __( 'Pinterest Share', 'btnsx' ),
				'post'									=> __( 'Post/Page/CPT', 'btnsx' ),
				'previous_page'							=> __( 'Previous Page', 'btnsx' ),
				'previous_post'							=> __( 'Previous Post', 'btnsx' ),
				'print'									=> __( 'Print', 'btnsx' ),
				'reddit_share'							=> __( 'Reddit Share', 'btnsx' ),
				'register'								=> __( 'Registration Page', 'btnsx' ),
				// 'slashdot_share'						=> __( 'Slashdot Share', 'btnsx' ),
				'skype_call'							=> __( 'Skype Call', 'btnsx' ),
				'skype_chat'							=> __( 'Skype Chat', 'btnsx' ),
				'skype_video_call'						=> __( 'Skype Video Call', 'btnsx' ),
				'sms'									=> __( 'SMS', 'btnsx' ),
				'stumbleupon_share'						=> __( 'StumbleUpon Share', 'btnsx' ),
				'tel'									=> __( 'Telephone', 'btnsx' ),
				'tumblr_share'							=> __( 'Tumblr Share', 'btnsx' ),
				'twitter_share'							=> __( 'Twitter Share', 'btnsx' ),
				'url'									=> __( 'URL', 'btnsx' ),
				'url_unescaped'							=> __( 'URL Unescaped', 'btnsx' ),
				'whatsapp_share'						=> __( 'Whatsapp Share', 'btnsx' ),
				'wistia_popover'						=> __( 'Wistia Popover', 'btnsx' ),
				'woocommerce_add_to_cart'				=> __( 'Woocommerce - Add to Cart', 'btnsx' ),
				'woocommerce_add_to_cart_auto_id'		=> __( 'Woocommerce - Add to Cart - Auto ID', 'btnsx' ),
			);
			// filter to add custom link options
        	$filtered_link_options = apply_filters( 'btnsx_link_options_filter', array(), $default_link_options );
        	$link_options = wp_parse_args( $filtered_link_options, $default_link_options );
        	ksort($link_options);

        	$default_link_tab_fields = array(
				array(
					'type'			=>	'select',
					'id'			=>	'btnsx_opt_link_type',
					'name'			=>	'btnsx_opt_link_type',
					'placeholder'	=>	__( 'Choose type', 'btnsx' ),
					'label'			=>	__( 'Type', 'btnsx' ),
					'tooltip'		=>	__( 'Choose the type of link required for the button.', 'btnsx' ),
					'options'		=>	$link_options,
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_type' ) )
				),
				array(
					'type'			=>	'select',
					'id'			=>	'btnsx_opt_link_target',
					'name'			=>	'btnsx_opt_link_target',
					'placeholder'	=>	__( 'Choose target', 'btnsx' ),
					'label'			=>	__( 'Target', 'btnsx' ),
					'tooltip'		=>	__( 'Where would you like to open the new link? New window or Same Window?', 'btnsx' ),
					'options'		=>	array(
						'new_window'	=> __( 'New Window', 'btnsx' ),
						'same_window'	=> __( 'Same Window', 'btnsx' ),
						'iframe'		=> __( 'Iframe', 'btnsx' )
					),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_target' ) )
				),
				array(
					'type'			=>	'select',
					'id'			=>	'btnsx_opt_link_relationship',
					'name'			=>	'btnsx_opt_link_relationship',
					'placeholder'	=>	__( 'Choose relationship', 'btnsx' ),
					'label'			=>	__( 'Relationship', 'btnsx' ),
					'tooltip'		=>	__( 'It species the relationship between the current document and linked document/resource. Alternate - Links to an alternate version of the document. Author - Links to author of the document. Bookmark - Permanent URL used for bookmarking. Help - Links to a help doument. License - Links to copyright information for the document. Next - The next document in a selection. Nofollow - Links to an unendorsed document, like a paid link. No Referrer - Specifies that the browser should not send a HTTP referer header if the user follows the hyperlink. Prefetch - Specifies that the target document should be cached. Previous - The previous document in a selection. Search - Links to a search tool for the document. Tag - A tag (keyword) for the current document.', 'btnsx' ),
					'options'		=>	array(
						''				=> __( 'None', 'btnsx' ),
						'alternate'		=> __( 'Alternate', 'btnsx' ),
						'author'		=> __( 'Author', 'btnsx' ),
						'bookmark'		=> __( 'Bookmark', 'btnsx' ),
						'help'			=> __( 'Help', 'btnsx' ),
						'license'		=> __( 'License', 'btnsx' ),
						'next'			=> __( 'Next', 'btnsx' ),
						'nofollow'		=> __( 'Nofollow', 'btnsx' ),
						'noreferrer'	=> __( 'No Referrer', 'btnsx' ),
						'prefetch'		=> __( 'Prefetch', 'btnsx' ),
						'prev'			=> __( 'Previous', 'btnsx' ),
						'search'		=> __( 'Search', 'btnsx' ),
						'tag'			=> __( 'Tag', 'btnsx' )
					),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_relationship' ) )
				),
				array(
					'type'			=>	'posts',
					'id'			=>	'btnsx_opt_link_post',
					'name'			=>	'btnsx_opt_link_post',
					'placeholder'	=>	__( 'Choose post', 'btnsx' ),
					'label'			=>	__( 'Post/Page/CPT', 'btnsx' ),
					'tooltip'		=>	__( 'Select a post, page or custom post type.', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_post' ) )
				),
				array(
					'type'			=>	'select',
					'id'			=>	'btnsx_opt_link_menu_display',
					'name'			=>	'btnsx_opt_link_menu_display',
					'placeholder'	=>	__( 'Choose when to display menu', 'btnsx' ),
					'label'			=>	__( 'Menu Display', 'btnsx' ),
					'tooltip'		=>	__( 'Select whether to display menu <strong>on button click</strong> or <strong>on button hover</strong>.', 'btnsx' ),
					'options'		=>	array(
						'on_click'	=> __( 'On Click', 'btnsx' ),
						'on_hover'  => __( 'On Hover', 'btnsx' )
					),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_menu_display' ) )
				),
				array(
					'type'			=>	'select',
					'id'			=>	'btnsx_opt_link_menu_type',
					'name'			=>	'btnsx_opt_link_menu_type',
					'placeholder'	=>	__( 'Select menu type', 'btnsx' ),
					'label'			=>	__( 'Menu Type', 'btnsx' ),
					'tooltip'		=>	__( 'Select whether to add custom links or use WordPress menu as dropdown.', 'btnsx' ),
					'options'		=>	array(
						'custom'	=> __( 'Custom Links', 'btnsx' ),
						'wordpress'  => __( 'WordPress Menu', 'btnsx' )
					),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_menu_type', 'value' => 'wordpress' ) )
				),
				array(
					'type'			=>	'menu',
					'id'			=>	'btnsx_opt_link_menu',
					'name'			=>	'btnsx_opt_link_menu',
					'placeholder'	=>	__( 'Choose menu', 'btnsx' ),
					'label'			=>	__( 'Menu as Dropdown', 'btnsx' ),
					'tooltip'		=>	__( 'Select a menu. These are the menus created under Appearance -> Menu.', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_menu' ) )
				),
				array(
					'type'			=>	'text',
					'id'			=>	'btnsx_opt_link',
					'name'			=>	'btnsx_opt_link',
					'placeholder'	=>	' ',
					'label'			=>	__( 'URL', 'btnsx' ),
					'tooltip'		=>	__( 'Add a custom URL.', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link' ) )
				),
			    array(
				    'type'			=>	'edd',
				    'id'			=>	'btnsx_opt_link_edd_id',
				    'name'			=>	'btnsx_opt_link_edd_id',
				    'placeholder'	=>	__( 'Choose download id', 'btnsx' ),
				    'label'			=>	__( 'EDD Download ID', 'btnsx' ),
				    'tooltip'		=>	__( 'Select Easy Digital Downloads download ID.', 'btnsx' ),
				    'value'			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_edd_id' ) )
			    ),
			    array(
				    'type'			=>	'text',
				    'id'			=>	'btnsx_opt_link_redirect_url',
				    'name'			=>	'btnsx_opt_link_redirect_url',
				    'placeholder'	=>	__( '/my-page', 'btnsx' ),
				    'label'			=>	__( 'Redirect URL', 'btnsx' ),
				    'tooltip'		=>	__( 'Only add the last part of the url where you would like to redirect user. If the full URL is http://wwww.example.com/my-page/ then only add /my-page/ in this field. The other part of the URL is computed automatically.', 'btnsx' ),
				    'value'			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_redirect_url' ) )
			    ),
			    array(
				    'type'			=>	'woocommerce',
				    'id'			=>	'btnsx_opt_link_woocommerce_id',
				    'name'			=>	'btnsx_opt_link_woocommerce_id',
				    'placeholder'	=>	__( 'Choose product id', 'btnsx' ),
				    'label'			=>	__( 'WooCommerce Product ID', 'btnsx' ),
				    'tooltip'		=>	__( 'Select a Woocommerce product ID.', 'btnsx' ),
				    'value'			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_woocommerce_id' ) )
			    ),
			    array(
				    'type'			=>	'text',
				    'id'			=>	'btnsx_opt_link_frame_width',
				    'name'			=>	'btnsx_opt_link_frame_width',
				    'placeholder'	=>	__( '1100', 'btnsx' ),
				    'label'			=>	__( 'Iframe Width', 'btnsx' ),
				    'tooltip'		=>	__( 'Define iframe width in pixels.', 'btnsx' ),
				    'value'			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_frame_width' ) )
			    ),
			    array(
				    'type'			=>	'text',
				    'id'			=>	'btnsx_opt_link_frame_height',
				    'name'			=>	'btnsx_opt_link_frame_height',
				    'placeholder'	=>	__( '600', 'btnsx' ),
				    'label'			=>	__( 'Iframe Height', 'btnsx' ),
				    'tooltip'		=>	__( 'Define iframe height in pixels.', 'btnsx' ),
				    'value'			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_link_frame_height' ) )
			    ),
				array(
					'type'			=>	'text',
					'id'			=>	'btnsx_opt_link_email',
					'name'			=>	'btnsx_opt_link_email',
					'placeholder'	=>	' ',
					'label'			=>	__( 'Email', 'btnsx' ),
					'tooltip'		=>	__( 'Add email address where the user should send email.', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_email' ) )
				),
				array(
					'type'			=>	'text',
					'id'			=>	'btnsx_opt_link_email_subject',
					'name'			=>	'btnsx_opt_link_email_subject',
					'placeholder'	=>	' ',
					'label'			=>	__( 'Email Subject', 'btnsx' ),
					'tooltip'		=>	__( 'Add subject for the email.', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_email_subject' ) )
				),
				array(
					'type'			=>	'text',
					'id'			=>	'btnsx_opt_link_skype_id',
					'name'			=>	'btnsx_opt_link_skype_id',
					'placeholder'	=>	' ',
					'label'			=>	__( 'Skype ID', 'btnsx' ),
					'tooltip'		=>	__( 'Add your Skype ID.', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_skype_id' ) )
				),
				array(
					'type'			=>	'text',
					'id'			=>	'btnsx_opt_link_telephone',
					'name'			=>	'btnsx_opt_link_telephone',
					'placeholder'	=>	' ',
					'label'			=>	__( 'Telephone Number', 'btnsx' ),
					'tooltip'		=>	__( 'Add telephone number to be used for call or sms.', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_telephone' ) )
				),
				array(
					'type'			=>	'text',
					'id'			=>	'btnsx_opt_link_sms_content',
					'name'			=>	'btnsx_opt_link_sms_content',
					'placeholder'	=>	' ',
					'label'			=>	__( 'SMS Content', 'btnsx' ),
					'tooltip'		=>	__( 'Add content to be used for SMS.', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_sms_content' ) )
				),
				array(
					'type'			=>	'text',
					'id'			=>	'btnsx_opt_link_wistia_video_id',
					'name'			=>	'btnsx_opt_link_wistia_video_id',
					'placeholder'	=>	' ',
					'label'			=>	__( 'Wistia Video ID', 'btnsx' ),
					'tooltip'		=>	__( 'Add Wistia video ID.', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_link_wistia_video_id' ) )
				)
			);
        	// filter to add custom options under link tab
        	$filtered_link_tab_fields = apply_filters( 'btnsx_link_tab_fields_filter', array(), $default_link_tab_fields );
        	$link_tab_fields = wp_parse_args( $filtered_link_tab_fields, $default_link_tab_fields );

        	$btnsx_form_design = new BtnsxFormDesign();
        	$btnsx_default_options = array(
				array(
					'icon_class'	=>	'fa fa-magic',
					'text'			=>	__( 'Animations', 'btnsx' ),
					'group'			=>	'advanced',
					'inner_group'	=>	array(
						array(
							'text'			=>	__( 'Reveal Animations', 'btnsx' ),
							'elements'		=> array(
								array(
								    'type'			=>	'icon-animation',
								    'id'			=>	'btnsx_opt_animation_reveal',
								    'name'			=>	'btnsx_opt_animation_reveal',
								    'label'			=>	__( 'Animation', 'btnsx' ),
								    'tooltip'		=>	__( 'Select button reveal animation type.', 'btnsx' ),
								    'class'			=> 'btnsx-select',
								    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_animation_reveal' ) )
							    )
							)
						),
						array(
							'text'			=>	__( 'Hover Animations', 'btnsx' ),
							'elements'		=> array(
								array(
								    'type'			=>	'animation',
								    'id'			=>	'btnsx_opt_animation_hover',
								    'name'			=>	'btnsx_opt_animation_hover',
								    'label'			=>	__( 'Animation', 'btnsx' ),
								    'tooltip'		=>	__( 'Select button hover animation type.', 'btnsx' ),
								    'class'			=> 'btnsx-select',
								    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_animation_hover' ) )
							    )
							)
						)
					)
				),
				array(
					'icon_class'	=>	'fa fa-image',
					'text'			=>	__( 'Background', 'btnsx' ),
					'group'			=>	'style',
					'inner_group'	=>	array(
						array(
							'text'			=>	__( 'Color', 'btnsx' ),
							'id'			=>	'btnsx_background_1',
							'elements'		=> array(
								array(
									'type'			=>	'color-states',
									'id'			=>	'btnsx_opt_background_color',
									'name'			=>	'btnsx_opt_background_color',
									'placeholder'	=>	' ',
									'tooltip'			=>	array(
										'normal'		=>	__( 'Set button background color.', 'btnsx' ),
										'hover'			=>	__( 'Set button background color for when the button will be hovered.', 'btnsx' )
									),
									'value'			=>	array(
										'normal'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_background_color', 'field2' => 'normal', 'value' => '#f4f4f4' ) ),
										'hover'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_background_color', 'field2' => 'hover', 'value' => '#e8e8e8' ) )
									),
									'copy'			=>	true,
									'copy_text'		=>	array(
										'normal'	=>	'hover',
										'hover'		=>	'normal'
									),
									'copy_ids'		=>	array(
										'normal'	=>	array(
											'highlight'		=>	'#btnsx_background_1_body',
											'old_color'		=>	'#btnsx_opt_background_color_normal',
											'new_color'		=>	'#btnsx_opt_background_color_hover'
										),
										'hover'	=>	array(
											'highlight'		=>	'#btnsx_background_1_body',
											'old_color'		=>	'#btnsx_opt_background_color_hover',
											'new_color'		=>	'#btnsx_opt_background_color_normal'
										)
									)
								)
							)
						),
						array(
							'text'			=>	__( 'Image', 'btnsx' ),
							'id'			=>	'btnsx_background_image_collapsible',
							'elements'		=> array(
								array(
	    							'type'			=>	'file',
	    							'id'			=>	'btnsx_opt_background_image_normal',
	    							'name'			=>	'btnsx_opt_background_image_normal',
	    							'label'			=>	__( 'Normal', 'btnsx' ),
	    							'tooltip'		=>	__( 'Select or upload button background image.', 'btnsx' ),
	    							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_background_image_normal' ) ),
	    							'copy'			=>	true,
									'copy_text'		=>	'hover',
									'copy_ids'		=>	array(
										'highlight'		=>	'#btnsx_background_image_collapsible_body',
										'old_input'		=>	'#btnsx_opt_background_image_normal',
										'new_input'		=>	'#btnsx_opt_background_image_hover'
									)
	    						),
	    						array(
	    							'type'			=>	'file',
	    							'id'			=>	'btnsx_opt_background_image_hover',
	    							'name'			=>	'btnsx_opt_background_image_hover',
	    							'label'			=>	__( 'Hover', 'btnsx' ),
	    							'tooltip'		=>	__( 'Select or upload button background image for when the button will be hovered.', 'btnsx' ),
	    							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_background_image_hover' ) ),
	    							'copy'			=>	true,
									'copy_text'		=>	'normal',
									'copy_ids'		=>	array(
										'highlight'		=>	'#btnsx_background_image_collapsible_body',
										'old_input'		=>	'#btnsx_opt_background_image_hover',
										'new_input'		=>	'#btnsx_opt_background_image_normal'
									)
	    						),
								array(
								    'type'			=>	'select',
								    'id'			=>	'btnsx_opt_background_image_repeat',
								    'name'			=>	'btnsx_opt_background_image_repeat',
								    'placeholder'	=>	__( 'Choose background repeat', 'btnsx' ),
								    'label'			=>	__( 'Repeat', 'btnsx' ),
								    'tooltip'		=>	__( 'Select whether the background image should repeat.', 'btnsx' ),
								    'options'		=>	array(
								    	'repeat'		=> __( 'Image Repeat', 'btnsx' ),
								    	'repeat-x'		=> __( 'Repeat X', 'btnsx' ),
								    	'repeat-y'		=> __( 'Repeat Y', 'btnsx' ),
								    	'no-repeat'		=> __( 'No Repeat', 'btnsx' ),
								    ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_background_image_repeat' ) )
							    ),
								array(
								    'type'			=>	'select',
								    'id'			=>	'btnsx_opt_background_image_position',
								    'name'			=>	'btnsx_opt_background_image_position',
								    'placeholder'	=>	__( 'Choose background position', 'btnsx' ),
								    'label'			=>	__( 'Image Position', 'btnsx' ),
								    'tooltip'		=>	__( 'Select background image position.', 'btnsx' ),
								    'options'		=>	array(
								    	'left top'		=> __( 'Left Top', 'btnsx' ),
								    	'left center'	=> __( 'Left Center', 'btnsx' ),
								    	'left bottom'	=> __( 'Left Bottom', 'btnsx' ),
								    	'right top'		=> __( 'Right Top', 'btnsx' ),
								    	'right center'	=> __( 'Right Center', 'btnsx' ),
								    	'right bottom'	=> __( 'Right Bottom', 'btnsx' ),
								    	'center top'	=> __( 'Center Top', 'btnsx' ),
								    	'center center'	=> __( 'Center Center', 'btnsx' ),
								    	'center bottom'	=> __( 'Center Bottom', 'btnsx' )
								    ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_background_image_position' ) )
							    ),
							)
						)
					)
				),
				array(
					'icon_class'	=>	'fas fa-vector-square',
					'text'			=>	__( 'Border', 'btnsx' ),
					'group'			=>	'style',
					'inner_group'	=>	array(
						array(
							'text'			=>	__( 'Normal', 'btnsx' ),
							'id'			=>	'btnsx_border_normal_collapsible',
							'copy'			=>	true, // copy enabled
							'copy_text'		=>	'hover', // copy to hover
							'copy_ids'		=>	array(
								'highlight'		=>	'#btnsx_border_hover_collapsible_header, #btnsx_border_hover_collapsible_body',
								'old_input'		=>	'#btnsx_opt_border_normal_size,#btnsx_opt_border_normal_top,#btnsx_opt_border_normal_bottom,#btnsx_opt_border_normal_left,#btnsx_opt_border_normal_right',
								'new_input'		=>	'#btnsx_opt_border_hover_size,#btnsx_opt_border_hover_top,#btnsx_opt_border_hover_bottom,#btnsx_opt_border_hover_left,#btnsx_opt_border_hover_right',
								'old_select'	=>	'#btnsx_opt_border_normal_style',
								'new_select'	=>	'#btnsx_opt_border_hover_style',
								'old_color'		=>	'#btnsx_opt_border_normal_color',
								'new_color'		=>	'#btnsx_opt_border_hover_color'
							), // store our fields, comma separated values
							'elements'		=>	array(
								array(
								    'type'			=>	'border',
								    'id'			=>	'btnsx_opt_border_normal',
								    'name'			=>	'btnsx_opt_border_normal',
								    'placeholder'	=>	' ',
								    'tooltip'		=>	array(
										'size'			=>	__( 'Set border size in pixels.', 'btnsx' ),
										'style'			=>	__( 'Set border style.', 'btnsx' ),
										'color'			=>	__( 'Set border color.', 'btnsx' ),
										'top'			=>	__( 'Enable/Disable top border.', 'btnsx' ),
										'bottom'		=>	__( 'Enable/Disable bottom border.', 'btnsx' ),
										'left'			=>	__( 'Enable/Disable left border.', 'btnsx' ),
										'right'			=>	__( 'Enable/Disable right border.', 'btnsx' )
									),
								    'value' 		=> array(
								    	'size' 			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_normal', 'field2' => 'size', 'value' => '0' ) ),
								    	'style' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_normal', 'field2' => 'style', 'value' => 'none' ) ),
								    	'color' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_normal', 'field2' => 'color' ) ),
								    	'top' 			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_normal', 'field2' => 'top', 'value' => '1' ) ),
								    	'bottom' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_normal', 'field2' => 'bottom', 'value' => '1' ) ),
								    	'left' 			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_normal', 'field2' => 'left', 'value' => '1' ) ),
								    	'right' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_normal', 'field2' => 'right', 'value' => '1' ) )
								    )
							    ),
							)
						),
						array(
							'text'			=>	__( 'Hover', 'btnsx' ),
							'id'			=>	'btnsx_border_hover_collapsible',
							'copy'			=>	true,
							'copy_text'		=>	'normal',
							'copy_ids'		=>	array(
								'highlight'		=>	'#btnsx_border_normal_collapsible_header, #btnsx_border_normal_collapsible_body',
								'old_input'		=>	'#btnsx_opt_border_hover_size,#btnsx_opt_border_hover_top,#btnsx_opt_border_hover_bottom,#btnsx_opt_border_hover_left,#btnsx_opt_border_hover_right',
								'new_input'		=>	'#btnsx_opt_border_normal_size,#btnsx_opt_border_normal_top,#btnsx_opt_border_normal_bottom,#btnsx_opt_border_normal_left,#btnsx_opt_border_normal_right',
								'old_select'	=>	'#btnsx_opt_border_hover_style',
								'new_select'	=>	'#btnsx_opt_border_normal_style',
								'old_color'		=>	'#btnsx_opt_border_hover_color',
								'new_color'		=>	'#btnsx_opt_border_normal_color'
							),
							'elements'		=>	array(
								array(
								    'type'			=>	'border',
								    'id'			=>	'btnsx_opt_border_hover',
								    'name'			=>	'btnsx_opt_border_hover',
								    'placeholder'	=>	' ',
								    'tooltip'		=>	array(
										'size'			=>	__( 'Set border size in pixels for when button is hovered.', 'btnsx' ),
										'style'			=>	__( 'Set border style for when button is hovered.', 'btnsx' ),
										'color'			=>	__( 'Set border colour for when button is hovered.', 'btnsx' ),
										'top'			=>	__( 'Enable/Disable top border.', 'btnsx' ),
										'bottom'		=>	__( 'Enable/Disable bottom border.', 'btnsx' ),
										'left'			=>	__( 'Enable/Disable left border.', 'btnsx' ),
										'right'			=>	__( 'Enable/Disable right border.', 'btnsx' )
									),
								    'value' 		=> array(
								    	'size' 			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_hover', 'field2' => 'size', 'value' => '0' ) ),
								    	'style' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_hover', 'field2' => 'style', 'value' => 'none' ) ),
								    	'color' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_hover', 'field2' => 'color' ) ),
								    	'top' 			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_hover', 'field2' => 'top', 'value' => '1' ) ),
								    	'bottom' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_hover', 'field2' => 'bottom', 'value' => '1' ) ),
								    	'left' 			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_hover', 'field2' => 'left', 'value' => '1' ) ),
								    	'right' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_hover', 'field2' => 'right', 'value' => '1' ) )
								    )
							    ),
							)
						),
						array(
							'text'			=>	__( 'Radius (Normal) ', 'btnsx' ),
							'id'			=>	'btnsx_border_normal_radius_collapsible',
							'copy'			=>	true,
							'copy_text'		=>	'hover',
							'copy_ids'		=>	array(
								'highlight'		=>	'#btnsx_border_hover_radius_collapsible_header, #btnsx_border_hover_radius_collapsible_body',
								'old_input'		=>	'#btnsx_opt_border_normal_radius_top_left,#btnsx_opt_border_normal_radius_top_right,#btnsx_opt_border_normal_radius_bottom_left,#btnsx_opt_border_normal_radius_bottom_right',
								'new_input'		=>	'#btnsx_opt_border_hover_radius_top_left,#btnsx_opt_border_hover_radius_top_right,#btnsx_opt_border_hover_radius_bottom_left,#btnsx_opt_border_hover_radius_bottom_right'
							),
							'elements'		=>	array(
								array(
								    'type'		=>	'radius',
								    'id'		=>	'btnsx_opt_border_normal_radius',
								    'name'		=>	'btnsx_opt_border_normal_radius',
								    'tooltip'		=>	array(
										'top_left'			=>	__( 'Set top left border radius in pixels.', 'btnsx' ),
										'top_right'			=>	__( 'Set top right border radius in pixels.', 'btnsx' ),
										'bottom_left'		=>	__( 'Set bottom left border radius in pixels.', 'btnsx' ),
										'bottom_right'		=>	__( 'Set bottom right border radius in pixels.', 'btnsx' )
									),
								    'value' 	=> array(
								    	'top_left' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_normal_radius', 'field2' => 'top_left', 'value' => '0' ) ),
								    	'top_right' 	=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_normal_radius', 'field2' => 'top_right', 'value' => '0' ) ),
								    	'bottom_left' 	=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_normal_radius', 'field2' => 'bottom_left', 'value' => '0' ) ),
								    	'bottom_right' 	=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_normal_radius', 'field2' => 'bottom_right', 'value' => '0' ) )
								    )
							    ),
							)
						),
						array(
							'text'			=>	__( 'Radius (Hover) ', 'btnsx' ),
							'id'			=>	'btnsx_border_hover_radius_collapsible',
							'copy'			=>	true,
							'copy_text'		=>	'normal',
							'copy_ids'		=>	array(
								'highlight'		=>	'#btnsx_border_normal_radius_collapsible_header, #btnsx_border_normal_radius_collapsible_body',
								'old_input'		=>	'#btnsx_opt_border_hover_radius_top_left,#btnsx_opt_border_hover_radius_top_right,#btnsx_opt_border_hover_radius_bottom_left,#btnsx_opt_border_hover_radius_bottom_right',
								'new_input'		=>	'#btnsx_opt_border_normal_radius_top_left,#btnsx_opt_border_normal_radius_top_right,#btnsx_opt_border_normal_radius_bottom_left,#btnsx_opt_border_normal_radius_bottom_right'
							),
							'elements'		=>	array(
								array(
								    'type'		=>	'radius',
								    'id'		=>	'btnsx_opt_border_hover_radius',
								    'name'		=>	'btnsx_opt_border_hover_radius',
								    'tooltip'		=>	array(
										'top_left'			=>	__( 'Set top left border radius in pixels for when button is hovered.', 'btnsx' ),
										'top_right'			=>	__( 'Set top right border radius in pixels for when button is hovered.', 'btnsx' ),
										'bottom_left'		=>	__( 'Set bottom left border radius in pixels for when button is hovered.', 'btnsx' ),
										'bottom_right'		=>	__( 'Set bottom right border radius in pixels for when button is hovered.', 'btnsx' )
									),
								    'value' 	=> array(
								    	'top_left' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_hover_radius', 'field2' => 'top_left', 'value' => '0' ) ),
								    	'top_right' 	=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_hover_radius', 'field2' => 'top_right', 'value' => '0' ) ),
								    	'bottom_left' 	=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_hover_radius', 'field2' => 'bottom_left', 'value' => '0' ) ),
								    	'bottom_right' 	=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_border_hover_radius', 'field2' => 'bottom_right', 'value' => '0' ) )
								    )
							    ),
							)
						)
					)
				),
				array(
        			'icon_class'	=>	'fa fa-columns',
        			'text'			=>	__( 'Layout', 'btnsx' ),
        			'group'			=>	'style',
        			'elements'		=> array(
						array(
							'type'			=>	'hidden',
							'id'			=>	'btnsx_opt_id',
							'name'			=>	'btnsx_opt_id',
							'label'			=>	__( 'ID', 'btnsx' ),
							'value'			=>	$post->ID,
						),
						array(
							'type'			=>	'range',
							'id'			=>	'btnsx_opt_width',
							'name'			=>	'btnsx_opt_width',
							'placeholder'	=>	' ',
							'label'			=>	__( 'Width', 'btnsx' ),
							'tooltip'		=>	__( 'Add button width in pixels. This gives the button a fixed width. Clearing the field removes fixed width.', 'btnsx' ),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_width' ) )
						),
						array(
							'type'			=>	'range',
							'id'			=>	'btnsx_opt_height',
							'name'			=>	'btnsx_opt_height',
							'placeholder'	=>	' ',
							'label'			=>	__( 'Height', 'btnsx' ),
							'tooltip'		=>	__( 'Add button height in pixels. This gives the button a fixed height. Clearing the field removes fixed height.', 'btnsx' ),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_height' ) )
						),
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_size',
							'name'			=>	'btnsx_opt_size',
							'placeholder'	=>	__( 'Choose size', 'btnsx' ),
							'label'			=>	__( 'Size', 'btnsx' ),
							'tooltip'		=>	__( 'These are some preset button sizes. Changing the size value automatically adjusts the font size and padding values of primary text.', 'btnsx' ),
							'options'		=>	array(
								'huge'	=> __( 'Huge', 'btnsx' ),
								'large'	=> __( 'Large', 'btnsx' ),
								'wide'	=> __( 'Wide', 'btnsx' ),
								'small'	=> __( 'Small', 'btnsx' ),
								'mini'	=> __( 'Mini', 'btnsx' )
							),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_size' ) )
						),
						array(
							'type'			=>	'checkbox',
							'id'			=>	'btnsx_opt_disabled',
							'name'			=>	'btnsx_opt_disabled',
							'label'			=>	__( 'Disabled', 'btnsx' ),
							'tooltip'		=>	__( 'Make the button disabled by checking this field. Clicking the button won\'t be possible once disabled.', 'btnsx' ),
							'class'			=>	'btnsx-checkbox',
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_disabled', 'value' => '0' ) )
						),
						array(
							'type'			=>	'checkbox',
							'id'			=>	'btnsx_opt_embossed',
							'name'			=>	'btnsx_opt_embossed',
							'label'			=>	__( 'Embossed', 'btnsx' ),
							'tooltip'		=>	__( 'Checking this field gives an embossed effect to button.', 'btnsx' ),
							'class'			=>	'btnsx-checkbox',
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_embossed', 'value' => '0' ) )
						),
						array(
							'type'			=>	'checkbox',
							'id'			=>	'btnsx_opt_full_width',
							'name'			=>	'btnsx_opt_full_width',
							'label'			=>	__( 'Full Width', 'btnsx' ),
							'tooltip'		=>	__( 'Make the button cover the entire width of the container.', 'btnsx' ),
							'class'			=>	'btnsx-checkbox',
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_full_width', 'value' => '0' ) )
						),
						array(
							'type'			=>	'checkbox',
							'id'			=>	'btnsx_opt_container',
							'name'			=>	'btnsx_opt_container',
							'label'			=>	__( 'Container', 'btnsx' ),
							'tooltip'		=>	__( 'Add a container div to button.', 'btnsx' ),
							'class'			=>	'btnsx-checkbox',
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_container', 'value' => '0' ) )
						),
						array(
							'type'			=>	'checkbox',
							'id'			=>	'btnsx_opt_wrap_center',
							'name'			=>	'btnsx_opt_wrap_center',
							'label'			=>	__( 'Wrap Center', 'btnsx' ),
							'tooltip'		=>	__( 'Makes the button centered. Very helpful when you want the button to be centered inside a big container.', 'btnsx' ),
							'class'			=>	'btnsx-checkbox',
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_wrap_center', 'value' => '0' ) )
						)
					)
				),
				array(
        			'icon_class'	=>	'fa fa-link',
        			'text'			=>	__( 'Link', 'btnsx' ),
        			'group'			=>	'content',
        			'elements'		=> $link_tab_fields,
        			'inner_group'	=> $cml_options
        		),
				array(
        			'icon_class'	=>	'fas fa-arrows-alt',
        			'text'			=>	__( 'Margin', 'btnsx' ),
        			'group'			=>	'style',
        			'elements'		=> array(
						array(
							'type'			=>	'trbl',
							'id'			=>	'btnsx_opt_margin',
							'name'			=>	'btnsx_opt_margin',
							'placeholder'	=>	'',
							'tooltip'		=>	array(
								'all'			=>	__( 'Set margin for all sides. This field is not saved. It should be used to apply same margin value to all sides.', 'btnsx' ),
								'top'			=>	__( 'Set top margin for button.', 'btnsx' ),
								'bottom'		=>	__( 'Set bottom margin for button.', 'btnsx' ),
								'left'			=>	__( 'Set left margin for button.', 'btnsx' ),
								'right'			=>	__( 'Set right margin for button.', 'btnsx' ),
							),
							'value'			=>	array(
								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_margin', 'field2' => 'top', 'value' => '0' ) ),
								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_margin', 'field2' => 'bottom', 'value' => '0' ) ),
								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_margin', 'field2' => 'left', 'value' => '0' ) ),
								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_margin', 'field2' => 'right', 'value' => '0' ) )

							)
						)
					)
        		),
        		array(
        			'icon_class'	=>	'fas fa-compress-arrows-alt',
        			'text'			=>	__( 'Padding', 'btnsx' ),
        			'group'			=>	'style',
					'elements'		=> array(
						array(
							'type'			=>	'trbl',
							'id'			=>	'btnsx_opt_padding',
							'name'			=>	'btnsx_opt_padding',
							'placeholder'	=>	'',
							'tooltip'		=>	array(
								'all'			=>	__( 'Set padding for all sides. This field is not saved. It should be used to apply same padding value to all sides.', 'btnsx' ),
								'top'			=>	__( 'Set top padding for button.', 'btnsx' ),
								'bottom'		=>	__( 'Set bottom padding for button.', 'btnsx' ),
								'left'			=>	__( 'Set left padding for button.', 'btnsx' ),
								'right'			=>	__( 'Set right padding for button.', 'btnsx' ),
							),
							'value'			=>	array(
								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_padding', 'field2' => 'top', 'value' => '10' ) ),
								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_padding', 'field2' => 'bottom', 'value' => '10' ) ),
								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_padding', 'field2' => 'left', 'value' => '40' ) ),
								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_padding', 'field2' => 'right', 'value' => '40' ) )
							)
						)
					)
        		),
				array(
        			'icon_class'	=>	'fab fa-css3',
        			'text'			=>	__( 'Custom CSS', 'btnsx' ),
        			'group'			=>	'expert',
					'elements'		=> array(
						array(
							'type'			=>	'text',
							'id'			=>	'btnsx_opt_class',
							'name'			=>	'btnsx_opt_class',
							'placeholder'	=>	' ',
							'label'			=>	__( 'Custom Class', 'btnsx' ),
							'tooltip'		=>	__( 'Add custom class to button.', 'btnsx' ),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_class' ) )
						),
						array(
							'type'			=>	'editor',
							'id'			=>	'btnsx_opt_css',
							'name'			=>	'btnsx_opt_css',
							'placeholder'	=>	' ',
							'label'			=>	__( 'Custom CSS', 'btnsx' ),
							'tooltip'		=>	__( 'Add custom CSS.', 'btnsx' ),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_css' ) )
						)
					)
        		),
        		array(
        			'icon_class'	=>	'fa fa-code',
        			'text'			=>	__( 'Custom JS', 'btnsx' ),
        			'group'			=>	'expert',
					'elements'		=> array(
						array(
							'type'			=>	'editor-js',
							'id'			=>	'btnsx_opt_js',
							'name'			=>	'btnsx_opt_js',
							'placeholder'	=>	' ',
							'label'			=>	__( 'Custom JS', 'btnsx' ),
							'tooltip'		=>	__( 'Add custom JS. DO NOT include <code>script</code> tag.', 'btnsx' ),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_js' ) )
						)
					)
        		),
        		array(
					'icon_class'	=>	'fa fa-adjust',
					'text'			=>	__( 'Gradient', 'btnsx' ),
					'group'			=>	'advanced',
					'inner_group'	=>	$gradient_options
				),
        		array(
					'icon_class'	=>	'fa fa-rocket',
					'text'			=>	__( 'Icon', 'btnsx' ),
					'group'			=>	'style',
					'inner_group'	=>	array(
						array(
							'text'			=>	__( 'Main', 'btnsx' ),
							'elements'		=> array(
								array(
									'type'			=>	'icon',
									'id'			=>	'btnsx_opt_icon',
									'name'			=>	'btnsx_opt_icon',
									'placeholder'	=>	' ',
									'label'			=>	__( 'Icon', 'btnsx' ),
									'tooltip'		=>	__( 'Select the desired icon. Icon will be placed to the left of primary text if it is not already aligned.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon' ) )
								),
								array(
								    'type'			=>	'range',
								    'id'			=>	'btnsx_opt_icon_size',
								    'name'			=>	'btnsx_opt_icon_size',
								    'placeholder'	=>	' ',
								    'label'			=>	__( 'Size', 'btnsx' ),
								    'tooltip'		=>	__( 'Add font size in pixels. This will make the icon bigger or smaller depending up on the value. Best is to keep the icon size similar to primary text size.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_size', 'value' => '14' ) )
							    ),
							    array(
								    'type'			=>	'select',
								    'id'			=>	'btnsx_opt_icon_alignment',
								    'name'			=>	'btnsx_opt_icon_alignment',
								    'placeholder'	=>	__( 'Choose alignment', 'btnsx' ),
								    'label'			=>	__( 'Alignment', 'btnsx' ),
								    'tooltip'		=>	__( 'Align the icon as required. Left moves the icon to the left of button and right moves the icon right of the button.', 'btnsx' ),
								    'options'		=>	array(
								    	'none'			=> __( 'None', 'btnsx' ),
								    	'left'			=> __( 'Left', 'btnsx' ),
								    	'extreme_left'	=> __( 'Extreme Left', 'btnsx' ),
								    	'right'			=> __( 'Right', 'btnsx' ),
								    	'extreme_right'	=> __( 'Extreme Right', 'btnsx' )
								    ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_alignment' ) )
							    ),
							    array(
							    	'type'			=>	'range',
							    	'id'			=>	'btnsx_opt_icon_vertical_position',
							    	'name'			=>	'btnsx_opt_icon_vertical_position',
							    	'placeholder'	=>	' ',
							    	'label'			=>	__( 'Vertical Position', 'btnsx' ),
							    	'tooltip'		=>	__( 'Position the icon vertically. More the value more the icon will move vertically downwards. You can also specify negative values to move icon upwards.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_vertical_position' ) )
							    ),
							)
						),
						array(
							'text'			=>	__( 'Color', 'btnsx' ),
							'id'			=>	'btnsx_icon_color_collapsible',
							'elements'		=>	array(
								array(
	    							'type'			=>	'color-states',
	    							'id'			=>	'btnsx_opt_icon_color',
	    							'name'			=>	'btnsx_opt_icon_color',
	    							'placeholder'	=>	' ',
	    							'tooltip'		=>	array(
	    								'normal'		=>	__( 'Select icon color.', 'btnsx' ),
	    								'hover'			=>	__( 'Select icon color for when button is hovered.', 'btnsx' ),
	    							),
	    							'value'			=>	array(
	    								'normal'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_color', 'field2' => 'normal' ) ),
	    								'hover'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_color', 'field2' => 'hover' ) )
	    							),
	    							'copy'			=>	true,
									'copy_text'		=>	array(
										'normal'	=>	'hover',
										'hover'		=>	'normal'
									),
									'copy_ids'		=>	array(
										'normal'	=>	array(
											'highlight'		=>	'#btnsx_icon_color_collapsible_body',
											'old_color'		=>	'#btnsx_opt_icon_color_normal',
											'new_color'		=>	'#btnsx_opt_icon_color_hover'
										),
										'hover'	=>	array(
											'highlight'		=>	'#btnsx_icon_color_collapsible_body',
											'old_color'		=>	'#btnsx_opt_icon_color_hover',
											'new_color'		=>	'#btnsx_opt_icon_color_normal'
										)
									)
	    						),
							)
						),
						array(
							'text'			=>	__( 'Image', 'btnsx' ),
							'id'			=>	'btnsx_icon_image_collapsible',
							'elements'		=>	array(
								array(
	    							'type'			=>	'file',
	    							'id'			=>	'btnsx_opt_icon_image',
	    							'name'			=>	'btnsx_opt_icon_image',
	    							'label'			=>	__( 'Normal', 'btnsx' ),
	    							'tooltip'		=>	__( 'Select or upload icon image.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_image' ) ),
									'copy'			=>	true,
									'copy_text'		=>	'hover',
									'copy_ids'		=>	array(
										'highlight'		=>	'#btnsx_icon_image_collapsible_body',
										'old_input'		=>	'#btnsx_opt_icon_image',
										'new_input'		=>	'#btnsx_opt_icon_image_hover'
									)
	    						),
	    						array(
	    							'type'			=>	'file',
	    							'id'			=>	'btnsx_opt_icon_image_hover',
	    							'name'			=>	'btnsx_opt_icon_image_hover',
	    							'label'			=>	__( 'Hover', 'btnsx' ),
	    							'tooltip'		=>	__( 'Select or upload icon image for when the button is hovered.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_image_hover' ) ),
									'copy'			=>	true,
									'copy_text'		=>	'normal',
									'copy_ids'		=>	array(
										'highlight'		=>	'#btnsx_icon_image_collapsible_body',
										'old_input'		=>	'#btnsx_opt_icon_image_hover',
										'new_input'		=>	'#btnsx_opt_icon_image'
									)
	    						),
	    						array(
									'type'			=>	'checkbox',
									'id'			=>	'btnsx_opt_icon_image_position_enable',
									'name'			=>	'btnsx_opt_icon_image_position_enable',
									'label'			=>	__( 'Position Freely', 'btnsx' ),
									'tooltip'		=>	__( 'Enabling this will display image position tab which can be used to position the icon image precisely.', 'btnsx' ),
									'class'			=>	'btnsx-checkbox',
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_image_position_enable', 'value' => '0' ) )
								)
							)
						),
						array(
							'text'			=>	__( 'Image Position', 'btnsx' ),
							'id'			=>	'btnsx-icon-image-position-tab',
							'elements'		=> array(
								array(
        							'type'			=>	'trbl',
        							'id'			=>	'btnsx_opt_icon_image_position',
        							'name'			=>	'btnsx_opt_icon_image_position',
        							'placeholder'	=>	'',
        							'tooltip'		=>	array(
        								'all'			=>	__( 'Set position for all sides. This field is not saved. It should be used to apply same position values to all sides.', 'btnsx' ),
        								'top'			=>	__( 'Set position from top.', 'btnsx' ),
        								'bottom'		=>	__( 'Set position from bottom.', 'btnsx' ),
        								'left'			=>	__( 'Set position from left.', 'btnsx' ),
        								'right'			=>	__( 'Set position from right.', 'btnsx' ),
        							),
        							'value'			=>	array(
	    								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_image_position', 'field2' => 'top', 'value' => '0' ) ),
	    								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_image_position', 'field2' => 'bottom', 'value' => '0' ) ),
	    								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_image_position', 'field2' => 'left', 'value' => '0' ) ),
	    								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_image_position', 'field2' => 'right', 'value' => '0' ) )
	    							)
        						)
							)
						),
						array(
							'text'			=>	__( 'Shadow', 'btnsx' ),
							'elements'		=> array(
								array(
	    							'type'			=>	'text-shadow',
	    							'id'			=>	'btnsx_opt_icon_shadow',
	    							'name'			=>	'btnsx_opt_icon_shadow',
	    							'placeholder'	=>	' ',
	    							'tooltip'		=>	array(
	    								'horizontal'	=>	__( 'Add position of the horizontal shadow in pixels. Adds horizontal shadow to icon.', 'btnsx' ),
	    								'vertical'		=>	__( 'Add position of the vertical shadow in pixels. Adds vertical shadow to icon.', 'btnsx' ),
	    								'blur'			=>	__( 'Add blur radius in pixels. Makes icon shadow blurry.', 'btnsx' ),
	    								'color'			=>	__( 'Pick icon shadow color.', 'btnsx' )
	    							),
	    							'value'			=>	array(
	    								'horizontal'	=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_shadow', 'field2' => 'horizontal' ) ),
	    								'vertical'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_shadow', 'field2' => 'vertical' ) ),
	    								'blur'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_shadow', 'field2' => 'blur' ) ),
	    								'color'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_shadow', 'field2' => 'color' ) )
	    							)
	    						)
							)
						),
						array(
							'text'			=>	__( 'Divider', 'btnsx' ),
							'elements'		=> array(
								array(
	    							'type'			=>	'divider',
	    							'id'			=>	'btnsx_opt_icon_divider',
	    							'name'			=>	'btnsx_opt_icon_divider',
	    							'placeholder'	=>	' ',
	    							'tooltip'		=>	array(
	    								'position'		=>	__( 'Select divider position. Position the divider to left or right of icon.', 'btnsx' ),
	    								'size'			=>	__( 'Add divider size in pixels. This will make the divider bigger or smaller depending up on the value. Best is to keep the divider size little smaller or equal to icon size.', 'btnsx' ),
	    								'color'			=>	__( 'Select divider color.', 'btnsx' )
	    							),
	    							'value'			=>	array(
	    								'size'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_divider', 'field2' => 'size' ) ),
	    								'position'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_divider', 'field2' => 'position' ) ),
	    								'color'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_divider', 'field2' => 'color' ) )
	    							)
	    						)
							)
						),
						array(
							'text'			=>	__( 'Animation', 'btnsx' ),
							'elements'		=>	array(
								array(
								    'type'			=>	'select',
								    'id'			=>	'btnsx_opt_icon_animation',
								    'name'			=>	'btnsx_opt_icon_animation',
								    'placeholder'	=>	__( 'Choose animation', 'btnsx' ),
								    'label'			=>	__( 'Animation', 'btnsx' ),
								    'tooltip'		=>	__( 'Select when to animate the icon, on button click or when button is hovered.', 'btnsx' ),
								    'options'		=>	array(
								    	'none'			=> __( 'None', 'btnsx' ),
								    	'click'			=> __( 'On Click', 'btnsx' ),
								    	'hover'			=> __( 'On Hover', 'btnsx' )
								    ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_animation' ) )
							    ),
							    array(
	    							'type'			=>	'icon-animation',
	    							'id'			=>	'btnsx_opt_icon_animation_type',
	    							'name'			=>	'btnsx_opt_icon_animation_type',
	    							'placeholder'	=>	__( 'Choose animation type', 'btnsx' ),
	    							'label'			=>	__( 'Animation Type', 'btnsx' ),
	    							'tooltip'		=>	__( 'Select type of animation. Choose from many different types.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_animation_type' ) )
	    						),
							)
						),
						array(
							'text'			=>	__( 'Padding', 'btnsx' ),
							'elements'		=> array(
								array(
        							'type'			=>	'trbl',
        							'id'			=>	'btnsx_opt_icon_padding',
        							'name'			=>	'btnsx_opt_icon_padding',
        							'placeholder'	=>	'',
        							'tooltip'		=>	array(
        								'all'			=>	__( 'Set padding for all sides. This field is not saved. It should be used to apply same padding value to all sides.', 'btnsx' ),
        								'top'			=>	__( 'Set top padding for icon.', 'btnsx' ),
        								'bottom'		=>	__( 'Set bottom padding for icon.', 'btnsx' ),
        								'left'			=>	__( 'Set left padding for icon.', 'btnsx' ),
        								'right'			=>	__( 'Set right padding for icon.', 'btnsx' ),
        							),
        							'value'			=>	array(
	    								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_padding', 'field2' => 'top', 'value' => '0' ) ),
	    								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_padding', 'field2' => 'bottom', 'value' => '0' ) ),
	    								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_padding', 'field2' => 'left', 'value' => '0' ) ),
	    								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_icon_padding', 'field2' => 'right', 'value' => '0' ) )
	    							)
        						)
							)
						)
					)
				),
				array(
					'icon_class'	=>	'fas fa-font',
					'text'			=>	__( 'Primary Text', 'btnsx' ),
					'group'			=>	'content',
					'inner_group'	=>	array(
						array(
							'text'			=>	__( 'Text', 'btnsx' ),
							'id'			=>	'btnsx_primary_text_1',
							'elements'		=>	array(
								array(
									'type'			=>	'text',
									'id'			=>	'btnsx_opt_text',
									'name'			=>	'btnsx_opt_text',
									'label'			=>	__( 'Text', 'btnsx' ),
									'tooltip'		=>	__( 'Add main button text.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text', 'value' => 'Button' ) )
								),
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_text_transform',
									'name'			=>	'btnsx_opt_text_transform',
									'placeholder'	=>	__( 'Choose option', 'btnsx' ),
									'label'			=>	__( 'Transform', 'btnsx' ),
									'tooltip'		=>	__( 'This field controls the capitalization of text.', 'btnsx' ),
									'options'		=>	array(
										''				=> __( 'None', 'btnsx' ),
										'capitalize'	=> __( 'Capitalize', 'btnsx' ),
										'uppercase'		=> __( 'Uppercase', 'btnsx' ),
										'lowercase'		=> __( 'Lowercase', 'btnsx' ),
										'inherit'		=> __( 'Inherit', 'btnsx' )
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_transform' ) )
								),
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_text_alignment',
									'name'			=>	'btnsx_opt_text_alignment',
									'placeholder'	=>	__( 'Choose alignment', 'btnsx' ),
									'label'			=>	__( 'Alignment', 'btnsx' ),
									'tooltip'		=>	__( 'Align the additional text as required.', 'btnsx' ),
									'options'		=>	array(
										'left'		=> __( 'Left', 'btnsx' ),
										'right'		=> __( 'Right', 'btnsx' ),
										'center'	=> __( 'Center', 'btnsx' )
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_alignment', 'value' => 'center' ) )
								),
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_text_vertical_space',
									'name'			=>	'btnsx_opt_text_vertical_space',
									'label'			=>	__( 'Vertical Space', 'btnsx' ),
									'tooltip'		=>	__( 'Adjust text line spacing. Defaults to font size if no value provided.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_vertical_space', 'value' => '21' ) )
								),
							)
						),
						array(
							'text'			=>	__( 'Font', 'btnsx' ),
							'elements'		=> array(
								array(
	    							'type'			=>	'font',
	    							'id'			=>	'btnsx_opt_text_font',
	    							'name'			=>	'btnsx_opt_text_font',
	    							'placeholder'	=>	' ',
	    							'tooltip'		=>	array(
	    								'size'			=>	__( 'Add font size in pixels. This will make your primary text bigger or smaller depending up on the value specified.', 'btnsx' ),
	    								'style'			=>	__( 'Select font style. This will style your primary text. Normal means as it is, italic means the text will appear slanted, oblique makes the text slanted + bold and inherit will get the style from parent element.', 'btnsx' ),
	    								'weight'		=>	__( 'Select font weight. This adds weight to text like bold makes the text stronger. 100 is lightest and 900 is boldest.', 'btnsx' ),
	    								'family'		=>	__( 'Select font family. Choose from among 100\'s of Google Web Fonts to style primary text.', 'btnsx' )
	    							),
	    							'value'			=>	array(
	    								'size'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_font', 'field2' => 'size', 'value' => '21' ) ),
	    								'style'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_font', 'field2' => 'style', 'value' => 'normal' ) ),
	    								'weight'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_font', 'field2' => 'weight', 'value' => 'normal' ) ),
	    								'family'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_font', 'field2' => 'family' ) )
	    							)
	    						),
							)
						),
						array(
							'text'			=>	__( 'Color', 'btnsx' ),
							'id'			=>	'btnsx_text_color_collapsible',
							'elements'		=> array(
								array(
	    							'type'			=>	'color-states',
	    							'id'			=>	'btnsx_opt_text_color',
	    							'name'			=>	'btnsx_opt_text_color',
	    							'placeholder'	=>	' ',
	    							'tooltip'		=>	array(
	    								'normal'		=>	__( 'Select text color.', 'btnsx' ),
	    								'hover'			=>	__( 'Select text color for when button is hovered.', 'btnsx' )
	    							),
	    							'value'			=>	array(
	    								'normal'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_color', 'field2' => 'normal', 'value' => '#999' ) ),
	    								'hover'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_color', 'field2' => 'hover', 'value' => '#777' ) )
	    							),
	    							'copy'			=>	true,
									'copy_text'		=>	array(
										'normal'	=>	'hover',
										'hover'		=>	'normal'
									),
									'copy_ids'		=>	array(
										'normal' => array(
											'highlight'		=>	'#btnsx_text_color_collapsible_body',
											'old_color'		=>	'#btnsx_opt_text_color_normal',
											'new_color'		=>	'#btnsx_opt_text_color_hover'
										),
										'hover' => array(
											'highlight'		=>	'#btnsx_text_color_collapsible_body',
											'old_color'		=>	'#btnsx_opt_text_color_hover',
											'new_color'		=>	'#btnsx_opt_text_color_normal'
										)
									)
	    						)
							)
						),
						array(
							'text'			=>	__( 'Shadow', 'btnsx' ),
							'elements'		=> array(
								array(
	    							'type'			=>	'text-shadow',
	    							'id'			=>	'btnsx_opt_text_shadow',
	    							'name'			=>	'btnsx_opt_text_shadow',
	    							'placeholder'	=>	' ',
	    							'tooltip'		=>	array(
	    								'horizontal'	=>	__( 'Add position of the horizontal shadow in pixels.', 'btnsx' ),
	    								'vertical'		=>	__( 'Add position of the vertical shadow in pixels.', 'btnsx' ),
	    								'blur'			=>	__( 'Add blur radius in pixels.', 'btnsx' ),
	    								'color'			=>	__( 'Select shadow color.', 'btnsx' )
	    							),
	    							'value'			=>	array(
	    								'horizontal'	=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_shadow', 'field2' => 'horizontal' ) ),
	    								'vertical'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_shadow', 'field2' => 'vertical' ) ),
	    								'blur'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_shadow', 'field2' => 'blur' ) ),
	    								'color'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_shadow', 'field2' => 'color' ) )
	    							),
	    						)
							)
						),
						array(
							'text'			=>	__( 'Padding', 'btnsx' ),
							'elements'		=> array(
								array(
        							'type'			=>	'trbl',
        							'id'			=>	'btnsx_opt_text_padding',
        							'name'			=>	'btnsx_opt_text_padding',
        							'placeholder'	=>	'',
        							'tooltip'		=>	array(
        								'all'			=>	__( 'Set padding for all sides. This field is not saved. It should be used to apply same padding value to all sides.', 'btnsx' ),
        								'top'			=>	__( 'Set top padding for primary text.', 'btnsx' ),
        								'bottom'		=>	__( 'Set bottom padding for primary text.', 'btnsx' ),
        								'left'			=>	__( 'Set left padding for primary text.', 'btnsx' ),
        								'right'			=>	__( 'Set right padding for primary text.', 'btnsx' ),
        							),
        							'value'			=>	array(
	    								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_padding', 'field2' => 'top', 'value' => '0' ) ),
	    								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_padding', 'field2' => 'bottom', 'value' => '0' ) ),
	    								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_padding', 'field2' => 'left', 'value' => '0' ) ),
	    								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_padding', 'field2' => 'right', 'value' => '0' ) )
	    							),
        						)
							)
						)
					)
				),
				array(
					'icon_class'	=>	'fas fa-bold',
					'text'			=>	__( 'Secondary Text', 'btnsx' ),
					'group'			=>	'content',
					'inner_group'	=>	array(
						array(
							'text'			=>	__( 'Text', 'btnsx' ),
							'elements'		=>	array(
								array(
									'type'			=>	'text',
									'id'			=>	'btnsx_opt_text_secondary',
									'name'			=>	'btnsx_opt_text_secondary',
									'label'			=>	__( 'Text', 'btnsx' ),
									'tooltip'		=>	__( 'Add additional text for button.', 'btnsx' ),
									'placeholder'	=>	' ',
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary' ) )
								),
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_text_secondary_transform',
									'name'			=>	'btnsx_opt_text_secondary_transform',
									'placeholder'	=>	__( 'Choose option', 'btnsx' ),
									'label'			=>	__( 'Transform', 'btnsx' ),
									'tooltip'		=>	__( 'This field controls the capitalization of text.', 'btnsx' ),
									'options'		=>	array(
										''				=> __( 'None', 'btnsx' ),
										'capitalize'	=> __( 'Capitalize', 'btnsx' ),
										'uppercase'		=> __( 'Uppercase', 'btnsx' ),
										'lowercase'		=> __( 'Lowercase', 'btnsx' ),
										'inherit'		=> __( 'Inherit', 'btnsx' )
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_transform' ) )
								),
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_text_secondary_position',
									'name'			=>	'btnsx_opt_text_secondary_position',
									'placeholder'	=>	__( 'Choose position', 'btnsx' ),
									'label'			=>	__( 'Position', 'btnsx' ),
									'tooltip'		=>	__( 'Select additonal text position. Put the text on the same line as primary text or move it to a new line.', 'btnsx' ),
									'options'		=>	array(
										'inline'		=> __( 'Same Line', 'btnsx' ),
										'block'			=> __( 'New Line', 'btnsx' )
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_position' ) )
								),
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_text_secondary_alignment',
									'name'			=>	'btnsx_opt_text_secondary_alignment',
									'placeholder'	=>	__( 'Choose alignment', 'btnsx' ),
									'label'			=>	__( 'Alignment', 'btnsx' ),
									'tooltip'		=>	__( 'Align the additional text as required.', 'btnsx' ),
									'options'		=>	array(
										'left'		=> __( 'Left', 'btnsx' ),
										'right'		=> __( 'Right', 'btnsx' ),
										'center'	=> __( 'Center', 'btnsx' )
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_alignment' ) )
								),
	    						array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_text_secondary_vertical_space',
									'name'			=>	'btnsx_opt_text_secondary_vertical_space',
									'label'			=>	__( 'Vertical Space', 'btnsx' ),
									'tooltip'		=>	__( 'Adjust secondary text vertcial space. Defaults to font size if no value provided.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_vertical_space', 'value' => '21' ) )
								)
							)
						),
						array(
							'text'			=>	__( 'Font', 'btnsx' ),
							'elements'		=> array(
								array(
	    							'type'			=>	'font',
	    							'id'			=>	'btnsx_opt_text_secondary_font',
	    							'name'			=>	'btnsx_opt_text_secondary_font',
	    							'placeholder'	=>	' ',
	    							'tooltip'		=>	array(
	    								'size'			=>	__( 'Add font size in pixels. This will make your additional text bigger or smaller depending up on the value specified.', 'btnsx' ),
	    								'style'			=>	__( 'Select font style. This will style your additional text. Normal means as it is, italic means the text will appear slanted, oblique makes the text slanted + bold and inherit will get the style from parent element.', 'btnsx' ),
	    								'weight'		=>	__( 'Select font weight. This adds weight to text like bold makes the text stronger. 100 is lightest and 900 is boldest.', 'btnsx' ),
	    								'family'		=>	__( 'Select font family. Choose from among 100\'s of Google Web Fonts to style primary text.', 'btnsx' )
	    							),
	    							'value'			=>	array(
	    								'size'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_font', 'field2' => 'size', 'value' => '21' ) ),
	    								'style'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_font', 'field2' => 'style', 'value' => 'normal' ) ),
	    								'weight'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_font', 'field2' => 'weight', 'value' => 'normal' ) ),
	    								'family'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_font', 'field2' => 'family' ) )
	    							)
	    						),
							)
						),
						array(
							'text'			=>	__( 'Color', 'btnsx' ),
							'id'			=>	'btnsx_text_secondary_color_collapsible',
							'elements'		=> array(
								array(
	    							'type'			=>	'color-states',
	    							'id'			=>	'btnsx_opt_text_secondary_color',
	    							'name'			=>	'btnsx_opt_text_secondary_color',
	    							'placeholder'	=>	' ',
	    							'tooltip'		=>	array(
	    								'normal'		=>	__( 'Select text color.', 'btnsx' ),
	    								'hover'			=>	__( 'Select text color for when button is hovered.', 'btnsx' )
	    							),
	    							'value'			=>	array(
	    								'normal'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_color', 'field2' => 'normal', 'value' => '#999' ) ),
	    								'hover'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_color', 'field2' => 'hover', 'value' => '#777' ) )
	    							),
	    							'copy'			=>	true,
									'copy_text'		=>	array(
										'normal'	=>	'hover',
										'hover'		=>	'normal'
									),
									'copy_ids'		=>	array(
										'normal' => array(
											'highlight'		=>	'#btnsx_text_secondary_color_collapsible_body',
											'old_color'		=>	'#btnsx_opt_text_secondary_color_normal',
											'new_color'		=>	'#btnsx_opt_text_secondary_color_hover'
										),
										'hover' => array(
											'highlight'		=>	'#btnsx_text_color_collapsible_body',
											'old_color'		=>	'#btnsx_opt_text_secondary_color_hover',
											'new_color'		=>	'#btnsx_opt_text_secondary_color_normal'
										)
									)
	    						)
							)
						),
						array(
							'text'			=>	__( 'Shadow', 'btnsx' ),
							'elements'		=> array(
								array(
	    							'type'			=>	'text-shadow',
	    							'id'			=>	'btnsx_opt_text_secondary_shadow',
	    							'name'			=>	'btnsx_opt_text_secondary_shadow',
	    							'placeholder'	=>	' ',
	    							'tooltip'		=>	array(
	    								'horizontal'	=>	__( 'Add position of the horizontal shadow in pixels.', 'btnsx' ),
	    								'vertical'		=>	__( 'Add position of the vertical shadow in pixels.', 'btnsx' ),
	    								'blur'			=>	__( 'Add blur radius in pixels.', 'btnsx' ),
	    								'color'			=>	__( 'Select shadow color.', 'btnsx' )
	    							),
	    							'value'			=>	array(
	    								'horizontal'	=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_shadow', 'field2' => 'horizontal' ) ),
	    								'vertical'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_shadow', 'field2' => 'vertical' ) ),
	    								'blur'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_shadow', 'field2' => 'blur' ) ),
	    								'color'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_shadow', 'field2' => 'color' ) ),
	    							)
	    						)
							)
						),
						array(
							'text'			=>	__( 'Padding', 'btnsx' ),
							'elements'		=> array(
								array(
        							'type'			=>	'trbl',
        							'id'			=>	'btnsx_opt_text_secondary_padding',
        							'name'			=>	'btnsx_opt_text_secondary_padding',
        							'placeholder'	=>	'',
        							'tooltip'		=>	array(
        								'all'			=>	__( 'Set padding for all sides. This field is not saved. It should be used to apply same padding value to all sides.', 'btnsx' ),
        								'top'			=>	__( 'Set top padding for secondary text.', 'btnsx' ),
        								'bottom'		=>	__( 'Set bottom padding for secondary text.', 'btnsx' ),
        								'left'			=>	__( 'Set left padding for secondary text.', 'btnsx' ),
        								'right'			=>	__( 'Set right padding for secondary text.', 'btnsx' ),
        							),
        							'value'			=>	array(
	    								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_padding', 'field2' => 'top', 'value' => '0' ) ),
	    								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_padding', 'field2' => 'bottom', 'value' => '0' ) ),
	    								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_padding', 'field2' => 'left', 'value' => '0' ) ),
	    								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_text_secondary_padding', 'field2' => 'right', 'value' => '0' ) ),
	    							)
        						)
							)
						)
					)
				),
				array(
					'icon_class'	=>	'fa fa-cube',
					'group'			=>	'advanced',
					'text'			=>	__( 'Shadow', 'btnsx' ),
					'inner_group'	=>	$box_shadow_options
				),
				array(
					'icon_class'	=>	'fa fa-tablet',
					'group'			=>	'advanced',
					'text'			=>	__( 'Responsive', 'btnsx' ),
					'inner_group'	=>	array(
						array(
							'id'			=> 'btnsx_responsive_tablet_collapsible',
							'text'			=>	__( 'Tablet', 'btnsx' ),
							'copy'			=>	true,
							'copy_text'		=>	__( 'Mobile', 'btnsx' ),
							'copy_ids'		=>	array(
								'highlight'		=>	'#btnsx_responsive_mobile_collapsible_header,#btnsx_responsive_mobile_collapsible_body',
								'old_input'		=>	'#btnsx_opt_tablet_width,#btnsx_opt_tablet_height,#btnsx_opt_tablet_text_font_size,#btnsx_opt_tablet_text_padding_top,#btnsx_opt_tablet_text_padding_bottom,#btnsx_opt_tablet_text_padding_left,#btnsx_opt_tablet_text_padding_right,#btnsx_opt_tablet_text_secondary_font_size,#btnsx_opt_tablet_text_secondary_padding_top,#btnsx_opt_tablet_text_secondary_padding_bottom,#btnsx_opt_tablet_text_secondary_padding_left,#btnsx_opt_tablet_text_secondary_padding_right,#btnsx_opt_tablet_icon_size,#btnsx_opt_tablet_icon_divider_size,#btnsx_opt_tablet_icon_divider_position,#btnsx_opt_tablet_icon_padding_top,#btnsx_opt_tablet_icon_padding_bottom,#btnsx_opt_tablet_icon_padding_left,#btnsx_opt_tablet_icon_padding_right,#btnsx_opt_tablet_padding_top,#btnsx_opt_tablet_padding_bottom,#btnsx_opt_tablet_padding_left,#btnsx_opt_tablet_padding_right',
								'new_input'		=>	'#btnsx_opt_mobile_width,#btnsx_opt_mobile_height,#btnsx_opt_mobile_text_font_size,#btnsx_opt_mobile_text_padding_top,#btnsx_opt_mobile_text_padding_bottom,#btnsx_opt_mobile_text_padding_left,#btnsx_opt_mobile_text_padding_right,#btnsx_opt_mobile_text_secondary_font_size,#btnsx_opt_mobile_text_secondary_padding_top,#btnsx_opt_mobile_text_secondary_padding_bottom,#btnsx_opt_mobile_text_secondary_padding_left,#btnsx_opt_mobile_text_secondary_padding_right,#btnsx_opt_mobile_icon_size,#btnsx_opt_mobile_icon_divider_size,#btnsx_opt_mobile_icon_divider_position,#btnsx_opt_mobile_icon_padding_top,#btnsx_opt_mobile_icon_padding_bottom,#btnsx_opt_mobile_icon_padding_left,#btnsx_opt_mobile_icon_padding_right,#btnsx_opt_mobile_padding_top,#btnsx_opt_mobile_padding_bottom,#btnsx_opt_mobile_padding_left,#btnsx_opt_mobile_padding_right',
							),
							'copy_class'		=>	'btnsx-responsive-tablet-copy',
							'elements'		=>	array(
								array(
									'type'			=>	'html',
									'id'			=> '',
									'value'			=>	'<div class="row"><div class="col m12"><a href="#btnsx_opt_tablet_width,#btnsx_opt_tablet_height" class="btnsx-responsive-accordion"><h6 class="header">'.__('Layout','btnsx').'<i class="fa fa-caret-up" style="float:right;"></i></h6></a><hr class="light"></div></div>'
								),
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_tablet_width',
									'name'			=>	'btnsx_opt_tablet_width',
									'placeholder'	=>	' ',
									'label'			=>	__( 'Width', 'btnsx' ),
									'tooltip'		=>	__( 'Add button width in pixels. This gives the button a fixed width. Clearing the field removes fixed width.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_width' ) )
								),
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_tablet_height',
									'name'			=>	'btnsx_opt_tablet_height',
									'placeholder'	=>	' ',
									'label'			=>	__( 'Height', 'btnsx' ),
									'tooltip'		=>	__( 'Add button height in pixels. This gives the button a fixed height. Clearing the field removes fixed height.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_height' ) )
								),
								array(
									'type'			=>	'html',
									'value'			=>	'<div class="row"><div class="col m12"><a href="#btnsx_opt_tablet_text_font_size,#btnsx_opt_tablet_text_padding_all,#btnsx_opt_tablet_text_padding_top,#btnsx_opt_tablet_text_padding_bottom,#btnsx_opt_tablet_text_padding_left,#btnsx_opt_tablet_text_padding_right" class="btnsx-responsive-accordion"><h6 class="header">'.__('Primary Text','btnsx').'<i class="fa fa-caret-up" style="float:right;"></i></h6></a><hr class="light"></div></div>'
								),
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_tablet_text_font_size',
									'name'			=>	'btnsx_opt_tablet_text_font_size',
									'label'			=>	__( 'Font Size', 'btnsx' ),
									'tooltip'		=>	__( 'Primary text font size for tablet view.', 'btnsx' ),
									'placeholder'	=>	' ',
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_text_font', 'field2' => 'size' ))
								),
								array(
        							'type'			=>	'padding',
        							'id'			=>	'btnsx_opt_tablet_text_padding',
        							'name'			=>	'btnsx_opt_tablet_text_padding',
        							'placeholder'	=>	'',
        							'tooltip'		=>	array(
        								'all'			=>	__( 'Set padding for all sides. This field is not saved. It should be used to apply same padding value to all sides.', 'btnsx' ),
        								'top'			=>	__( 'Set top padding for primary text.', 'btnsx' ),
        								'bottom'		=>	__( 'Set bottom padding for primary text.', 'btnsx' ),
        								'left'			=>	__( 'Set left padding for primary text.', 'btnsx' ),
        								'right'			=>	__( 'Set right padding for primary text.', 'btnsx' ),
        							),
        							'value'			=>	array(
	    								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_text_padding', 'field2' => 'top', 'value' => '' ) ),
	    								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_text_padding', 'field2' => 'bottom', 'value' => '' ) ),
	    								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_text_padding', 'field2' => 'left', 'value' => '' ) ),
	    								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_text_padding', 'field2' => 'right', 'value' => '' ) )
	    							),
        						),
        						array(
									'type'			=>	'html',
									'value'			=>	'<div class="row"><div class="col m12"><a href="#btnsx_opt_tablet_text_secondary_font_size,#btnsx_opt_tablet_text_secondary_padding_all,#btnsx_opt_tablet_text_secondary_padding_top,#btnsx_opt_tablet_text_secondary_padding_bottom,#btnsx_opt_tablet_text_secondary_padding_left,#btnsx_opt_tablet_text_secondary_padding_right" class="btnsx-responsive-accordion"><h6 class="header">'.__('Secondary Text','btnsx').'<i class="fa fa-caret-up" style="float:right;"></i></h6></a><hr class="light"></div></div>'
								),
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_tablet_text_secondary_font_size',
									'name'			=>	'btnsx_opt_tablet_text_secondary_font_size',
									'label'			=>	__( 'Font Size', 'btnsx' ),
									'tooltip'		=>	__( 'Secondary text font size for tablet view.', 'btnsx' ),
									'placeholder'	=>	' ',
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_text_secondary_font', 'field2' => 'size' ))
								),
								array(
        							'type'			=>	'padding',
        							'id'			=>	'btnsx_opt_tablet_text_secondary_padding',
        							'name'			=>	'btnsx_opt_tablet_text_secondary_padding',
        							'placeholder'	=>	'',
        							'tooltip'		=>	array(
        								'all'			=>	__( 'Set padding for all sides. This field is not saved. It should be used to apply same padding value to all sides.', 'btnsx' ),
        								'top'			=>	__( 'Set top padding for primary text.', 'btnsx' ),
        								'bottom'		=>	__( 'Set bottom padding for primary text.', 'btnsx' ),
        								'left'			=>	__( 'Set left padding for primary text.', 'btnsx' ),
        								'right'			=>	__( 'Set right padding for primary text.', 'btnsx' ),
        							),
        							'value'			=>	array(
	    								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_text_secondary_padding', 'field2' => 'top', 'value' => '' ) ),
	    								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_text_secondary_padding', 'field2' => 'bottom', 'value' => '' ) ),
	    								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_text_secondary_padding', 'field2' => 'left', 'value' => '' ) ),
	    								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_text_secondary_padding', 'field2' => 'right', 'value' => '' ) )
	    							),
        						),
        						array(
									'type'			=>	'html',
									'value'			=>	'<div class="row"><div class="col m12"><a href="#btnsx_opt_tablet_icon_size,#btnsx_opt_tablet_icon_divider_size,#btnsx_opt_tablet_icon_divider_position,#btnsx_opt_tablet_icon_padding_all,#btnsx_opt_tablet_icon_padding_top,#btnsx_opt_tablet_icon_padding_bottom,#btnsx_opt_tablet_icon_padding_left,#btnsx_opt_tablet_icon_padding_right" class="btnsx-responsive-accordion"><h6 class="header">'.__('Icon','btnsx').'<i class="fa fa-caret-up" style="float:right;"></i></h6></a><hr class="light"></div></div>'
								),
								array(
								    'type'			=>	'range',
								    'id'			=>	'btnsx_opt_tablet_icon_size',
								    'name'			=>	'btnsx_opt_tablet_icon_size',
								    'placeholder'	=>	' ',
								    'label'			=>	__( 'Size', 'btnsx' ),
								    'tooltip'		=>	__( 'Add font size in pixels. This will make the icon bigger or smaller depending up on the value. Best is to keep the icon size similar to primary text size.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_icon_size', 'value' => '' ) )
							    ),
							    array(
								    'type'			=>	'range',
								    'id'			=>	'btnsx_opt_tablet_icon_divider_size',
								    'name'			=>	'btnsx_opt_tablet_icon_divider_size',
								    'placeholder'	=>	' ',
								    'label'			=>	__( 'Divider Size', 'btnsx' ),
								    'tooltip'		=>	__( 'Add divider size in pixels. This will make the divider bigger or smaller depending up on the value. Best is to keep the divider size little smaller or equal to icon size.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_icon_divider_size', 'value' => '' ) )
							    ),
							    array(
								    'type'			=>	'range',
								    'id'			=>	'btnsx_opt_tablet_icon_divider_position',
								    'name'			=>	'btnsx_opt_tablet_icon_divider_position',
								    'placeholder'	=>	' ',
								    'label'			=>	__( 'Divider Position', 'btnsx' ),
								    'tooltip'		=>	__( 'Select divider position. Position the divider to left or right of icon. Negative values are accepted.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_icon_divider_position', 'value' => '' ) )
							    ),
							    array(
        							'type'			=>	'padding',
        							'id'			=>	'btnsx_opt_tablet_icon_padding',
        							'name'			=>	'btnsx_opt_tablet_icon_padding',
        							'placeholder'	=>	'',
        							'tooltip'		=>	array(
        								'all'			=>	__( 'Set padding for all sides. This field is not saved. It should be used to apply same padding value to all sides.', 'btnsx' ),
        								'top'			=>	__( 'Set top padding for primary text.', 'btnsx' ),
        								'bottom'		=>	__( 'Set bottom padding for primary text.', 'btnsx' ),
        								'left'			=>	__( 'Set left padding for primary text.', 'btnsx' ),
        								'right'			=>	__( 'Set right padding for primary text.', 'btnsx' ),
        							),
        							'value'			=>	array(
	    								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_icon_padding', 'field2' => 'top', 'value' => '' ) ),
	    								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_icon_padding', 'field2' => 'bottom', 'value' => '' ) ),
	    								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_icon_padding', 'field2' => 'left', 'value' => '' ) ),
	    								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_icon_padding', 'field2' => 'right', 'value' => '' ) )
	    							),
        						),
								array(
									'type'			=>	'html',
									'value'			=>	'<div class="row"><div class="col m12"><a href="#btnsx_opt_tablet_padding_all,#btnsx_opt_tablet_padding_top,#btnsx_opt_tablet_padding_bottom,#btnsx_opt_tablet_padding_left,#btnsx_opt_tablet_padding_right" class="btnsx-responsive-accordion"><h6 class="header">'.__('Padding','btnsx').'<i class="fa fa-caret-up" style="float:right;"></i></h6></a><hr class="light"></div></div>'
								),
								array(
        							'type'			=>	'padding',
        							'id'			=>	'btnsx_opt_tablet_padding',
        							'name'			=>	'btnsx_opt_tablet_padding',
        							'placeholder'	=>	'',
        							'tooltip'		=>	array(
        								'all'			=>	__( 'Set padding for all sides. This field is not saved. It should be used to apply same padding value to all sides.', 'btnsx' ),
        								'top'			=>	__( 'Set top padding for primary text.', 'btnsx' ),
        								'bottom'		=>	__( 'Set bottom padding for primary text.', 'btnsx' ),
        								'left'			=>	__( 'Set left padding for primary text.', 'btnsx' ),
        								'right'			=>	__( 'Set right padding for primary text.', 'btnsx' ),
        							),
        							'value'			=>	array(
	    								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_padding', 'field2' => 'top', 'value' => '' ) ),
	    								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_padding', 'field2' => 'bottom', 'value' => '' ) ),
	    								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_padding', 'field2' => 'left', 'value' => '' ) ),
	    								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tablet_padding', 'field2' => 'right', 'value' => '' ) )
	    							),
        						),
							)
						),
						array(
							'id'			=>	'btnsx_responsive_mobile_collapsible',
							'text'			=>	__( 'Mobile', 'btnsx' ),
							'copy'			=>	true,
							'copy_text'		=>	__( 'Tablet', 'btnsx' ),
							'copy_ids'		=>	array(
								'highlight'		=>	'#btnsx_responsive_tablet_collapsible_header,#btnsx_responsive_tablet_collapsible_body',
								'old_input'		=>	'#btnsx_opt_mobile_width,#btnsx_opt_mobile_height,#btnsx_opt_mobile_text_font_size,#btnsx_opt_mobile_text_padding_top,#btnsx_opt_mobile_text_padding_bottom,#btnsx_opt_mobile_text_padding_left,#btnsx_opt_mobile_text_padding_right,#btnsx_opt_mobile_text_secondary_font_size,#btnsx_opt_mobile_text_secondary_padding_top,#btnsx_opt_mobile_text_secondary_padding_bottom,#btnsx_opt_mobile_text_secondary_padding_left,#btnsx_opt_mobile_text_secondary_padding_right,#btnsx_opt_mobile_icon_size,#btnsx_opt_mobile_icon_divider_size,#btnsx_opt_mobile_icon_divider_position,#btnsx_opt_mobile_icon_padding_top,#btnsx_opt_mobile_icon_padding_bottom,#btnsx_opt_mobile_icon_padding_left,#btnsx_opt_mobile_icon_padding_right,#btnsx_opt_mobile_padding_top,#btnsx_opt_mobile_padding_bottom,#btnsx_opt_mobile_padding_left,#btnsx_opt_mobile_padding_right',
								'new_input'		=>	'#btnsx_opt_tablet_width,#btnsx_opt_tablet_height,#btnsx_opt_tablet_text_font_size,#btnsx_opt_tablet_text_padding_top,#btnsx_opt_tablet_text_padding_bottom,#btnsx_opt_tablet_text_padding_left,#btnsx_opt_tablet_text_padding_right,#btnsx_opt_tablet_text_secondary_font_size,#btnsx_opt_tablet_text_secondary_padding_top,#btnsx_opt_tablet_text_secondary_padding_bottom,#btnsx_opt_tablet_text_secondary_padding_left,#btnsx_opt_tablet_text_secondary_padding_right,#btnsx_opt_tablet_icon_size,#btnsx_opt_tablet_icon_divider_size,#btnsx_opt_tablet_icon_divider_position,#btnsx_opt_tablet_icon_padding_top,#btnsx_opt_tablet_icon_padding_bottom,#btnsx_opt_tablet_icon_padding_left,#btnsx_opt_tablet_icon_padding_right,#btnsx_opt_tablet_padding_top,#btnsx_opt_tablet_padding_bottom,#btnsx_opt_tablet_padding_left,#btnsx_opt_tablet_padding_right',
							),
							'copy_class'		=>	'btnsx-responsive-tablet-copy',
							'elements'		=>	array(
								array(
									'type'			=>	'html',
									'value'			=>	'<div class="row"><div class="col m12"><a href="#btnsx_opt_mobile_width,#btnsx_opt_mobile_height" class="btnsx-responsive-accordion"><h6 class="header">'.__('Layout','btnsx').'<i class="fa fa-caret-up" style="float:right;"></i></h6></a><hr class="light"></div></div>'
								),
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_mobile_width',
									'name'			=>	'btnsx_opt_mobile_width',
									'placeholder'	=>	' ',
									'label'			=>	__( 'Width', 'btnsx' ),
									'tooltip'		=>	__( 'Add button width in pixels. This gives the button a fixed width. Clearing the field removes fixed width.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_width' ) )
								),
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_mobile_height',
									'name'			=>	'btnsx_opt_mobile_height',
									'placeholder'	=>	' ',
									'label'			=>	__( 'Height', 'btnsx' ),
									'tooltip'		=>	__( 'Add button height in pixels. This gives the button a fixed height. Clearing the field removes fixed height.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_height' ) )
								),
								array(
									'type'			=>	'html',
									'value'			=>	'<div class="row"><div class="col m12"><a href="#btnsx_opt_mobile_text_font_size,#btnsx_opt_mobile_text_padding_all,#btnsx_opt_mobile_text_padding_top,#btnsx_opt_mobile_text_padding_bottom,#btnsx_opt_mobile_text_padding_left,#btnsx_opt_mobile_text_padding_right" class="btnsx-responsive-accordion"><h6 class="header">'.__('Primary Text','btnsx').'<i class="fa fa-caret-up" style="float:right;"></i></h6></a><hr class="light"></div></div>'
								),
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_mobile_text_font_size',
									'name'			=>	'btnsx_opt_mobile_text_font_size',
									'label'			=>	__( 'Font Size', 'btnsx' ),
									'tooltip'		=>	__( 'Primary text font size for mobile view.', 'btnsx' ),
									'placeholder'	=>	' ',
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_text_font', 'field2' => 'size' ))
								),
								array(
        							'type'			=>	'padding',
        							'id'			=>	'btnsx_opt_mobile_text_padding',
        							'name'			=>	'btnsx_opt_mobile_text_padding',
        							'placeholder'	=>	'',
        							'tooltip'		=>	array(
        								'all'			=>	__( 'Set padding for all sides. This field is not saved. It should be used to apply same padding value to all sides.', 'btnsx' ),
        								'top'			=>	__( 'Set top padding for primary text.', 'btnsx' ),
        								'bottom'		=>	__( 'Set bottom padding for primary text.', 'btnsx' ),
        								'left'			=>	__( 'Set left padding for primary text.', 'btnsx' ),
        								'right'			=>	__( 'Set right padding for primary text.', 'btnsx' ),
        							),
        							'value'			=>	array(
	    								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_text_padding', 'field2' => 'top', 'value' => '' ) ),
	    								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_text_padding', 'field2' => 'bottom', 'value' => '' ) ),
	    								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_text_padding', 'field2' => 'left', 'value' => '' ) ),
	    								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_text_padding', 'field2' => 'right', 'value' => '' ) )
	    							),
        						),
        						array(
									'type'			=>	'html',
									'value'			=>	'<div class="row"><div class="col m12"><a href="#btnsx_opt_mobile_text_secondary_font_size,#btnsx_opt_mobile_text_secondary_padding_all,#btnsx_opt_mobile_text_secondary_padding_top,#btnsx_opt_mobile_text_secondary_padding_bottom,#btnsx_opt_mobile_text_secondary_padding_left,#btnsx_opt_mobile_text_secondary_padding_right" class="btnsx-responsive-accordion"><h6 class="header">'.__('Secondary Text','btnsx').'<i class="fa fa-caret-up" style="float:right;"></i></h6></a><hr class="light"></div></div>'
								),
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_mobile_text_secondary_font_size',
									'name'			=>	'btnsx_opt_mobile_text_secondary_font_size',
									'label'			=>	__( 'Font Size', 'btnsx' ),
									'tooltip'		=>	__( 'Secondary text font size for mobile view.', 'btnsx' ),
									'placeholder'	=>	' ',
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_text_secondary_font', 'field2' => 'size' ))
								),
								array(
        							'type'			=>	'padding',
        							'id'			=>	'btnsx_opt_mobile_text_secondary_padding',
        							'name'			=>	'btnsx_opt_mobile_text_secondary_padding',
        							'placeholder'	=>	'',
        							'tooltip'		=>	array(
        								'all'			=>	__( 'Set padding for all sides. This field is not saved. It should be used to apply same padding value to all sides.', 'btnsx' ),
        								'top'			=>	__( 'Set top padding for primary text.', 'btnsx' ),
        								'bottom'		=>	__( 'Set bottom padding for primary text.', 'btnsx' ),
        								'left'			=>	__( 'Set left padding for primary text.', 'btnsx' ),
        								'right'			=>	__( 'Set right padding for primary text.', 'btnsx' ),
        							),
        							'value'			=>	array(
	    								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_text_secondary_padding', 'field2' => 'top', 'value' => '' ) ),
	    								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_text_secondary_padding', 'field2' => 'bottom', 'value' => '' ) ),
	    								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_text_secondary_padding', 'field2' => 'left', 'value' => '' ) ),
	    								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_text_secondary_padding', 'field2' => 'right', 'value' => '' ) )
	    							),
        						),
        						array(
									'type'			=>	'html',
									'value'			=>	'<div class="row"><div class="col m12"><a href="#btnsx_opt_mobile_icon_size,#btnsx_opt_mobile_icon_divider_size,#btnsx_opt_mobile_icon_divider_position,#btnsx_opt_mobile_icon_padding_all,#btnsx_opt_mobile_icon_padding_top,#btnsx_opt_mobile_icon_padding_bottom,#btnsx_opt_mobile_icon_padding_left,#btnsx_opt_mobile_icon_padding_right" class="btnsx-responsive-accordion"><h6 class="header">'.__('Icon','btnsx').'<i class="fa fa-caret-up" style="float:right;"></i></h6></a><hr class="light"></div></div>'
								),
								array(
								    'type'			=>	'range',
								    'id'			=>	'btnsx_opt_mobile_icon_size',
								    'name'			=>	'btnsx_opt_mobile_icon_size',
								    'placeholder'	=>	' ',
								    'label'			=>	__( 'Size', 'btnsx' ),
								    'tooltip'		=>	__( 'Add font size in pixels. This will make the icon bigger or smaller depending up on the value. Best is to keep the icon size similar to primary text size.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_icon_size', 'value' => '' ) )
							    ),
							    array(
								    'type'			=>	'range',
								    'id'			=>	'btnsx_opt_mobile_icon_divider_size',
								    'name'			=>	'btnsx_opt_mobile_icon_divider_size',
								    'placeholder'	=>	' ',
								    'label'			=>	__( 'Divider Size', 'btnsx' ),
								    'tooltip'		=>	__( 'Add divider size in pixels. This will make the divider bigger or smaller depending up on the value. Best is to keep the divider size little smaller or equal to icon size.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_icon_divider_size', 'value' => '' ) )
							    ),
							    array(
								    'type'			=>	'range',
								    'id'			=>	'btnsx_opt_mobile_icon_divider_position',
								    'name'			=>	'btnsx_opt_mobile_icon_divider_position',
								    'placeholder'	=>	' ',
								    'label'			=>	__( 'Divider Position', 'btnsx' ),
								    'tooltip'		=>	__( 'Select divider position. Position the divider to left or right of icon. Negative values are accepted.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_icon_divider_position', 'value' => '' ) )
							    ),
							    array(
        							'type'			=>	'padding',
        							'id'			=>	'btnsx_opt_mobile_icon_padding',
        							'name'			=>	'btnsx_opt_mobile_icon_padding',
        							'placeholder'	=>	'',
        							'tooltip'		=>	array(
        								'all'			=>	__( 'Set padding for all sides. This field is not saved. It should be used to apply same padding value to all sides.', 'btnsx' ),
        								'top'			=>	__( 'Set top padding for primary text.', 'btnsx' ),
        								'bottom'		=>	__( 'Set bottom padding for primary text.', 'btnsx' ),
        								'left'			=>	__( 'Set left padding for primary text.', 'btnsx' ),
        								'right'			=>	__( 'Set right padding for primary text.', 'btnsx' ),
        							),
        							'value'			=>	array(
	    								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_icon_padding', 'field2' => 'top', 'value' => '' ) ),
	    								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_icon_padding', 'field2' => 'bottom', 'value' => '' ) ),
	    								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_icon_padding', 'field2' => 'left', 'value' => '' ) ),
	    								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_icon_padding', 'field2' => 'right', 'value' => '' ) )
	    							),
        						),
								array(
									'type'			=>	'html',
									'value'			=>	'<div class="row"><div class="col m12"><a href="#btnsx_opt_mobile_padding_all,#btnsx_opt_mobile_padding_top,#btnsx_opt_mobile_padding_bottom,#btnsx_opt_mobile_padding_left,#btnsx_opt_mobile_padding_right" class="btnsx-responsive-accordion"><h6 class="header">'.__('Padding','btnsx').'<i class="fa fa-caret-up" style="float:right;"></i></h6></a><hr class="light"></div></div>'
								),
								array(
        							'type'			=>	'padding',
        							'id'			=>	'btnsx_opt_mobile_padding',
        							'name'			=>	'btnsx_opt_mobile_padding',
        							'placeholder'	=>	'',
        							'tooltip'		=>	array(
        								'all'			=>	__( 'Set padding for all sides. This field is not saved. It should be used to apply same padding value to all sides.', 'btnsx' ),
        								'top'			=>	__( 'Set top padding for primary text.', 'btnsx' ),
        								'bottom'		=>	__( 'Set bottom padding for primary text.', 'btnsx' ),
        								'left'			=>	__( 'Set left padding for primary text.', 'btnsx' ),
        								'right'			=>	__( 'Set right padding for primary text.', 'btnsx' ),
        							),
        							'value'			=>	array(
	    								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_padding', 'field2' => 'top', 'value' => '' ) ),
	    								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_padding', 'field2' => 'bottom', 'value' => '' ) ),
	    								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_padding', 'field2' => 'left', 'value' => '' ) ),
	    								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_mobile_padding', 'field2' => 'right', 'value' => '' ) )
	    							),
        						),
							)
						),
					)
				)
	        );

			// filter to add custom options
        	$btnsx_filtered_options = apply_filters( 'btnsx_options_filter', array(), $btnsx_default_options );
        	$btnsx_options = wp_parse_args( $btnsx_filtered_options, $btnsx_default_options );
        	$btnsx_form_design->tabs(
        		array(
        			'id'				=>	'btnsx-tabs',
        			'show_group'		=>	true,
        			'outer_group'		=>	$btnsx_options
        		)
        	);
	    }

	    /**
	     * When the post is saved, saves our custom data.
	     * @param int $post->ID_id The ID of the post being saved.
	     * @since 0.1
	     */
	    public function save_data( $post_id ) {

	        /*
	         * We need to verify this came from our screen and with proper authorization,
	         * because the save_post action can be triggered at other times.
	         */

	        // Check if our nonce is set.
	        if ( !isset( $_POST[ 'btnsx_options_nonce' ] ) ) {
	            return;
	        }

	        // Verify that the nonce is valid.
	        if ( !wp_verify_nonce( $_POST[ 'btnsx_options_nonce' ], 'btnsx' ) ) {
	            return;
	        }

	        // If this is an autosave, our form has not been submitted, so we don't want to do anything.
	        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
	            return;
	        }

	        // Check the user's permissions.
	        if ( isset( $_POST[ 'post_type' ] ) && 'page' == $_POST[ 'post_type' ] ) {
	            if ( !current_user_can( 'edit_page', $post_id ) ) {
	                return;
	            }
	        } else {
	            if ( !current_user_can( 'edit_post', $post_id ) ) {
	                return;
	            }
	        }

	        /* OK, its safe for us to save the data now. */
	        $btnsx_data = array();

	        // Sanitize user input.
	        $btnsx_data = array(
	        	// General
		        	'btnsx_preview_background' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_preview_background'] ) ? $_POST['btnsx_opt_preview_background'] : '' ),
		        	'btnsx_preview_background_image' 	=> array(
		            	'image' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_preview_background_image_image'] ) ? $_POST['btnsx_opt_preview_background_image_image'] : '' ),
		            	'position' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_preview_background_image_position'] ) ? $_POST['btnsx_opt_preview_background_image_position'] : '' )
		            ),
		            'btnsx_preview_background_overlay' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_preview_background_overlay'] ) ? $_POST['btnsx_opt_preview_background_overlay'] : '' ),
		            'btnsx_id' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_id'] ) ? $_POST['btnsx_opt_id'] : '' ),
		            'btnsx_width' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_width'] ) ? $_POST['btnsx_opt_width'] : '' ),
		            'btnsx_height' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_height'] ) ? $_POST['btnsx_opt_height'] : '' ),
		            'btnsx_size' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_size'] ) ? $_POST['btnsx_opt_size'] : '' ),
		            'btnsx_disabled' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_disabled'] ) ? $_POST['btnsx_opt_disabled'] : '' ),
		            'btnsx_embossed' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_embossed'] ) ? $_POST['btnsx_opt_embossed'] : '' ),
		            'btnsx_container' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_container'] ) ? $_POST['btnsx_opt_container'] : '' ),
		            'btnsx_wrap_center' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_wrap_center'] ) ? $_POST['btnsx_opt_wrap_center'] : '' ),
		            'btnsx_full_width' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_full_width'] ) ? $_POST['btnsx_opt_full_width'] : '' ),
		            'btnsx_link_type' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_link_type'] ) ? $_POST['btnsx_opt_link_type'] : '' ),
		            'btnsx_link_target' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_link_target'] ) ? $_POST['btnsx_opt_link_target'] : '' ),
		            'btnsx_link_relationship' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_link_relationship'] ) ? $_POST['btnsx_opt_link_relationship'] : '' ),
		            'btnsx_link_post' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_link_post'] ) ? $_POST['btnsx_opt_link_post'] : '' ),
		            'btnsx_link_menu' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_link_menu'] ) ? $_POST['btnsx_opt_link_menu'] : '' ),
		            'btnsx_link_menu_display' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_link_menu_display'] ) ? $_POST['btnsx_opt_link_menu_display'] : '' ),
		            'btnsx_link' 						=> isset( $_POST['btnsx_opt_link_type'] ) && $_POST['btnsx_opt_link_type'] == 'url_unescaped' ? esc_url_raw( isset( $_POST['btnsx_opt_link'] ) ? $_POST['btnsx_opt_link'] : '' ) : sanitize_text_field( isset( $_POST['btnsx_opt_link'] ) ? $_POST['btnsx_opt_link'] : '' ),
		            'btnsx_link_edd_id' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_link_edd_id'] ) ? $_POST['btnsx_opt_link_edd_id'] : '' ),
		            'btnsx_link_redirect_url' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_link_redirect_url'] ) ? $_POST['btnsx_opt_link_redirect_url'] : '' ),
		            'btnsx_link_woocommerce_id' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_link_woocommerce_id'] ) ? $_POST['btnsx_opt_link_woocommerce_id'] : '' ),
		            'btnsx_link_frame_width' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_link_frame_width'] ) ? $_POST['btnsx_opt_link_frame_width'] : '' ),
		            'btnsx_link_frame_height' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_link_frame_height'] ) ? $_POST['btnsx_opt_link_frame_height'] : '' ),
		            'btnsx_link_email' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_link_email'] ) ? $_POST['btnsx_opt_link_email'] : '' ),
		            'btnsx_link_email_subject' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_link_email_subject'] ) ? $_POST['btnsx_opt_link_email_subject'] : '' ),
		            'btnsx_link_skype_id' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_link_skype_id'] ) ? $_POST['btnsx_opt_link_skype_id'] : '' ),
		            'btnsx_link_telephone' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_link_telephone'] ) ? $_POST['btnsx_opt_link_telephone'] : '' ),
		            'btnsx_link_sms_content' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_link_sms_content'] ) ? $_POST['btnsx_opt_link_sms_content'] : '' ),
		            'btnsx_link_menu_type' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_link_menu_type'] ) ? $_POST['btnsx_opt_link_menu_type'] : '' ),
		            'btnsx_link_menu_custom' 	=> array(
		            	'label'	=>	sanitize_text_field( isset( $_POST['btnsx_opt_link_menu_custom_label'] ) ? serialize( $_POST['btnsx_opt_link_menu_custom_label'] ) : '' ),
		            	'url'	=> sanitize_text_field( isset( $_POST['btnsx_opt_link_menu_custom_url'] ) ? serialize( $_POST['btnsx_opt_link_menu_custom_url'] ) : '' )
		            ),
		            'btnsx_link_wistia_video_id' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_link_wistia_video_id'] ) ? $_POST['btnsx_opt_link_wistia_video_id'] : '' ),

		            'btnsx_link_dropdown_font' 			=> array(
		            	'size' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_font_size'] ) ? $_POST['btnsx_opt_link_dropdown_font_size'] : '' ),
		            	'style' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_font_style'] ) ? $_POST['btnsx_opt_link_dropdown_font_style'] : '' ),
		            	'weight' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_font_weight'] ) ? $_POST['btnsx_opt_link_dropdown_font_weight'] : '' ),
		            	'family' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_font_family'] ) ? $_POST['btnsx_opt_link_dropdown_font_family'] : '' )
		            ),
		            'btnsx_link_dropdown_border_normal' 	=> array(
		            	'size' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_border_normal_size'] ) ? $_POST['btnsx_opt_link_dropdown_border_normal_size'] : '' ),
		            	'style' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_border_normal_style'] ) ? $_POST['btnsx_opt_link_dropdown_border_normal_style'] : '' ),
		            	'color' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_border_normal_color'] ) ? $_POST['btnsx_opt_link_dropdown_border_normal_color'] : '' ),
		            	'top' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_border_normal_top'] ) ? $_POST['btnsx_opt_link_dropdown_border_normal_top'] : '0' ),
		            	'bottom' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_border_normal_bottom'] ) ? $_POST['btnsx_opt_link_dropdown_border_normal_bottom'] : '0' ),
		            	'left' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_border_normal_left'] ) ? $_POST['btnsx_opt_link_dropdown_border_normal_left'] : '0' ),
		            	'right' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_border_normal_right'] ) ? $_POST['btnsx_opt_link_dropdown_border_normal_right'] : '0' ),
		            ),
		            'btnsx_link_dropdown_border_normal_radius' 		=> array(
		            	'top_left' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_border_normal_radius_top_left'] ) ? $_POST['btnsx_opt_link_dropdown_border_normal_radius_top_left'] : '' ),
		            	'top_right' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_border_normal_radius_top_right'] ) ? $_POST['btnsx_opt_link_dropdown_border_normal_radius_top_right'] : '' ),
		            	'bottom_left' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_border_normal_radius_bottom_left'] ) ? $_POST['btnsx_opt_link_dropdown_border_normal_radius_bottom_left'] : '' ),
		            	'bottom_right' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_border_normal_radius_bottom_right'] ) ? $_POST['btnsx_opt_link_dropdown_border_normal_radius_bottom_right'] : '' )
		            ),
		            'btnsx_link_dropdown_shadow_hide' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_link_dropdown_shadow_hide'] ) ? $_POST['btnsx_opt_link_dropdown_shadow_hide'] : '' ),
		            'btnsx_margin' 						=> array(
		            	'top' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_margin_top'] ) ? $_POST['btnsx_opt_margin_top'] : '' ),
		            	'right' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_margin_right'] ) ? $_POST['btnsx_opt_margin_right'] : '' ),
		            	'bottom' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_margin_bottom'] ) ? $_POST['btnsx_opt_margin_bottom'] : '' ),
		            	'left' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_margin_left'] ) ? $_POST['btnsx_opt_margin_left'] : '' ),
		            ),
		            'btnsx_padding' 					=> array(
		            	'top' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_padding_top'] ) ? $_POST['btnsx_opt_padding_top'] : '' ),
		            	'right' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_padding_right'] ) ? $_POST['btnsx_opt_padding_right'] : '' ),
		            	'bottom' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_padding_bottom'] ) ? $_POST['btnsx_opt_padding_bottom'] : '' ),
		            	'left' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_padding_left'] ) ? $_POST['btnsx_opt_padding_left'] : '' ),
		            ),
		            'btnsx_class' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_class'] ) ? $_POST['btnsx_opt_class'] : '' ),
		            'btnsx_css' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_css'] ) ? $_POST['btnsx_opt_css'] : '' ),

	            // Primary Text
		            'btnsx_text' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_text'] ) ? $_POST['btnsx_opt_text'] : '' ),
		            'btnsx_text_transform' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_text_transform'] ) ? $_POST['btnsx_opt_text_transform'] : '' ),
		            'btnsx_text_alignment' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_text_alignment'] ) ? $_POST['btnsx_opt_text_alignment'] : '' ),
		            'btnsx_text_font' 					=> array(
		            	'size' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_text_font_size'] ) ? $_POST['btnsx_opt_text_font_size'] : '' ),
		            	'style' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_font_style'] ) ? $_POST['btnsx_opt_text_font_style'] : '' ),
		            	'weight' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_font_weight'] ) ? $_POST['btnsx_opt_text_font_weight'] : '' ),
		            	'family' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_font_family'] ) ? $_POST['btnsx_opt_text_font_family'] : '' )
		            ),
		            'btnsx_text_vertical_space' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_text_vertical_space'] ) ? $_POST['btnsx_opt_text_vertical_space'] : '' ),
		            'btnsx_text_color' 					=> array(
		            	'normal' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_color_normal'] ) ? $_POST['btnsx_opt_text_color_normal'] : '' ),
		            	'hover' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_color_hover'] ) ? $_POST['btnsx_opt_text_color_hover'] : '' )
		            ),
		            'btnsx_text_shadow' 				=> array(
		            	'horizontal' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_text_shadow_horizontal'] ) ? $_POST['btnsx_opt_text_shadow_horizontal'] : '' ),
		            	'vertical' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_shadow_vertical'] ) ? $_POST['btnsx_opt_text_shadow_vertical'] : '' ),
		            	'blur' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_text_shadow_blur'] ) ? $_POST['btnsx_opt_text_shadow_blur'] : '' ),
		            	'color' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_shadow_color'] ) ? $_POST['btnsx_opt_text_shadow_color'] : '' )
		            ),
		            'btnsx_text_padding' 				=> array(
		            	'top' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_text_padding_top'] ) ? $_POST['btnsx_opt_text_padding_top'] : '' ),
		            	'bottom' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_padding_bottom'] ) ? $_POST['btnsx_opt_text_padding_bottom'] : '' ),
		            	'left' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_text_padding_left'] ) ? $_POST['btnsx_opt_text_padding_left'] : '' ),
		            	'right' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_padding_right'] ) ? $_POST['btnsx_opt_text_padding_right'] : '' )
		            ),

	            // Secondary Text
		            'btnsx_text_secondary' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary'] ) ? $_POST['btnsx_opt_text_secondary'] : '' ),
		            'btnsx_text_secondary_transform' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_transform'] ) ? $_POST['btnsx_opt_text_secondary_transform'] : '' ),
		            'btnsx_text_secondary_position' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_position'] ) ? $_POST['btnsx_opt_text_secondary_position'] : '' ),
		            'btnsx_text_secondary_alignment' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_alignment'] ) ? $_POST['btnsx_opt_text_secondary_alignment'] : '' ),
		            'btnsx_text_secondary_font' 		=> array(
		            	'size' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_font_size'] ) ? $_POST['btnsx_opt_text_secondary_font_size'] : '' ),
		            	'style' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_font_style'] ) ? $_POST['btnsx_opt_text_secondary_font_style'] : '' ),
		            	'weight' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_font_weight'] ) ? $_POST['btnsx_opt_text_secondary_font_weight'] : '' ),
		            	'family' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_font_family'] ) ? $_POST['btnsx_opt_text_secondary_font_family'] : '' )
		            ),
		            'btnsx_text_secondary_vertical_space' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_vertical_space'] ) ? $_POST['btnsx_opt_text_secondary_vertical_space'] : '' ),
		            'btnsx_text_secondary_color' 		=> array(
		            	'normal' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_color_normal'] ) ? $_POST['btnsx_opt_text_secondary_color_normal'] : '' ),
		            	'hover' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_color_hover'] ) ? $_POST['btnsx_opt_text_secondary_color_hover'] : '' )
		            ),
		            'btnsx_text_secondary_shadow' 		=> array(
		            	'horizontal' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_shadow_horizontal'] ) ? $_POST['btnsx_opt_text_secondary_shadow_horizontal'] : '' ),
		            	'vertical' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_shadow_vertical'] ) ? $_POST['btnsx_opt_text_secondary_shadow_vertical'] : '' ),
		            	'blur' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_shadow_blur'] ) ? $_POST['btnsx_opt_text_secondary_shadow_blur'] : '' ),
		            	'color' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_shadow_color'] ) ? $_POST['btnsx_opt_text_secondary_shadow_color'] : '' )
		            ),
		            'btnsx_text_secondary_padding' 		=> array(
		            	'top' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_padding_top'] ) ? $_POST['btnsx_opt_text_secondary_padding_top'] : '' ),
		            	'bottom' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_padding_bottom'] ) ? $_POST['btnsx_opt_text_secondary_padding_bottom'] : '' ),
		            	'left' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_padding_left'] ) ? $_POST['btnsx_opt_text_secondary_padding_left'] : '' ),
		            	'right' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_text_secondary_padding_right'] ) ? $_POST['btnsx_opt_text_secondary_padding_right'] : '' )
		            ),

	            // Icon
		            'btnsx_icon' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_icon'] ) ? $_POST['btnsx_opt_icon'] : '' ),
		            'btnsx_icon_size' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_size'] ) ? $_POST['btnsx_opt_icon_size'] : '' ),
		            'btnsx_icon_alignment' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_alignment'] ) ? $_POST['btnsx_opt_icon_alignment'] : '' ),
		            'btnsx_icon_vertical_position' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_vertical_position'] ) ? $_POST['btnsx_opt_icon_vertical_position'] : '' ),
		            'btnsx_icon_color' 					=> array(
		            	'normal' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_color_normal'] ) ? $_POST['btnsx_opt_icon_color_normal'] : '' ),
		            	'hover' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_color_hover'] ) ? $_POST['btnsx_opt_icon_color_hover'] : '' )
		            ),
		            'btnsx_icon_image' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_image'] ) ? $_POST['btnsx_opt_icon_image'] : '' ),
		            'btnsx_icon_image_hover' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_image_hover'] ) ? $_POST['btnsx_opt_icon_image_hover'] : '' ),
		            'btnsx_icon_image_position_enable' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_image_position_enable'] ) ? $_POST['btnsx_opt_icon_image_position_enable'] : '' ),
		            'btnsx_icon_image_position' 		=> array(
		            	'top' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_image_position_top'] ) ? $_POST['btnsx_opt_icon_image_position_top'] : '' ),
		            	'bottom' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_image_position_bottom'] ) ? $_POST['btnsx_opt_icon_image_position_bottom'] : '' ),
		            	'left' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_image_position_left'] ) ? $_POST['btnsx_opt_icon_image_position_left'] : '' ),
		            	'right' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_image_position_right'] ) ? $_POST['btnsx_opt_icon_image_position_right'] : '' ),
		            ),
		            'btnsx_icon_shadow' 				=> array(
		            	'horizontal' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_shadow_horizontal'] ) ? $_POST['btnsx_opt_icon_shadow_horizontal'] : '' ),
		            	'vertical' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_shadow_vertical'] ) ? $_POST['btnsx_opt_icon_shadow_vertical'] : '' ),
		            	'blur' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_shadow_blur'] ) ? $_POST['btnsx_opt_icon_shadow_blur'] : '' ),
		            	'color' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_shadow_color'] ) ? $_POST['btnsx_opt_icon_shadow_color'] : '' )
		            ),
		            'btnsx_icon_divider' 				=> array(
		            	'position' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_divider_position'] ) ? $_POST['btnsx_opt_icon_divider_position'] : '' ),
		            	'size' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_divider_size'] ) ? $_POST['btnsx_opt_icon_divider_size'] : '' ),
		            	'color' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_divider_color'] ) ? $_POST['btnsx_opt_icon_divider_color'] : '' )
		            ),
		            'btnsx_icon_animation' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_animation'] ) ? $_POST['btnsx_opt_icon_animation'] : '' ),
		            'btnsx_icon_animation_type' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_animation_type'] ) ? $_POST['btnsx_opt_icon_animation_type'] : '' ),
		            'btnsx_icon_padding' 				=> array(
		            	'top' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_padding_top'] ) ? $_POST['btnsx_opt_icon_padding_top'] : '' ),
		            	'bottom' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_padding_bottom'] ) ? $_POST['btnsx_opt_icon_padding_bottom'] : '' ),
		            	'left' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_padding_left'] ) ? $_POST['btnsx_opt_icon_padding_left'] : '' ),
		            	'right' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_icon_padding_right'] ) ? $_POST['btnsx_opt_icon_padding_right'] : '' ),
		            ),

	            // Background
		            'btnsx_background_color' 			=> array(
		            	'normal' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_background_color_normal'] ) ? $_POST['btnsx_opt_background_color_normal'] : '' ),
		            	'hover' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_background_color_hover'] ) ? $_POST['btnsx_opt_background_color_hover'] : '' )
		            ),
		            'btnsx_background_image_normal' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_background_image_normal'] ) ? $_POST['btnsx_opt_background_image_normal'] : '' ),
		            'btnsx_background_image_hover' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_background_image_hover'] ) ? $_POST['btnsx_opt_background_image_hover'] : '' ),
		            'btnsx_background_image_repeat' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_background_image_repeat'] ) ? $_POST['btnsx_opt_background_image_repeat'] : '' ),
		            'btnsx_background_image_position' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_background_image_position'] ) ? $_POST['btnsx_opt_background_image_position'] : '' ),

	            // Gradient
	            	'btnsx_gradient_type_normal' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_gradient_type_normal'] ) ? $_POST['btnsx_opt_gradient_type_normal'] : '' ),
		            'btnsx_gradient_type_hover' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_gradient_type_hover'] ) ? $_POST['btnsx_opt_gradient_type_hover'] : '' ),
		            'btnsx_gradient_stop_normal' 		=> array(
		            	'color' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_gradient_stop_normal_color'] ) ? serialize( $_POST['btnsx_opt_gradient_stop_normal_color'] ) : '' ),
		            	'location' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_gradient_stop_normal_location'] ) ? serialize(  $_POST['btnsx_opt_gradient_stop_normal_location'] ) : '' )
		            ),
		            'btnsx_gradient_stop_hover' 		=> array(
		            	'color' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_gradient_stop_hover_color'] ) ? serialize( $_POST['btnsx_opt_gradient_stop_hover_color'] ) : '' ),
		            	'location' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_gradient_stop_hover_location'] ) ? serialize( $_POST['btnsx_opt_gradient_stop_hover_location'] ) : '' )
		            ),
		            'btnsx_gradient_css_normal' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_gradient_css_normal'] ) ? $_POST['btnsx_opt_gradient_css_normal'] : '' ),
		            'btnsx_gradient_css_hover' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_gradient_css_hover'] ) ? $_POST['btnsx_opt_gradient_css_hover'] : '' ),

	            // Border
		            'btnsx_border_normal' 				=> array(
		            	'size' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_border_normal_size'] ) ? $_POST['btnsx_opt_border_normal_size'] : '' ),
		            	'style' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_border_normal_style'] ) ? $_POST['btnsx_opt_border_normal_style'] : '' ),
		            	'color' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_border_normal_color'] ) ? $_POST['btnsx_opt_border_normal_color'] : '' ),
		            	'top' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_border_normal_top'] ) ? $_POST['btnsx_opt_border_normal_top'] : '0' ),
		            	'bottom' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_border_normal_bottom'] ) ? $_POST['btnsx_opt_border_normal_bottom'] : '0' ),
		            	'left' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_border_normal_left'] ) ? $_POST['btnsx_opt_border_normal_left'] : '0' ),
		            	'right' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_border_normal_right'] ) ? $_POST['btnsx_opt_border_normal_right'] : '0' ),
		            ),
		            'btnsx_border_hover' 				=> array(
		            	'size' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_border_hover_size'] ) ? $_POST['btnsx_opt_border_hover_size'] : '' ),
		            	'style' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_border_hover_style'] ) ? $_POST['btnsx_opt_border_hover_style'] : '' ),
		            	'color' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_border_hover_color'] ) ? $_POST['btnsx_opt_border_hover_color'] : '' ),
		            	'top' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_border_hover_top'] ) ? $_POST['btnsx_opt_border_hover_top'] : '0' ),
		            	'bottom' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_border_hover_bottom'] ) ? $_POST['btnsx_opt_border_hover_bottom'] : '0' ),
		            	'left' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_border_hover_left'] ) ? $_POST['btnsx_opt_border_hover_left'] : '0' ),
		            	'right' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_border_hover_right'] ) ? $_POST['btnsx_opt_border_hover_right'] : '0' ),
		            ),
		            'btnsx_border_normal_radius' 		=> array(
		            	'top_left' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_border_normal_radius_top_left'] ) ? $_POST['btnsx_opt_border_normal_radius_top_left'] : '' ),
		            	'top_right' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_border_normal_radius_top_right'] ) ? $_POST['btnsx_opt_border_normal_radius_top_right'] : '' ),
		            	'bottom_left' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_border_normal_radius_bottom_left'] ) ? $_POST['btnsx_opt_border_normal_radius_bottom_left'] : '' ),
		            	'bottom_right' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_border_normal_radius_bottom_right'] ) ? $_POST['btnsx_opt_border_normal_radius_bottom_right'] : '' )
		            ),
		            'btnsx_border_hover_radius' 		=> array(
		            	'top_left' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_border_hover_radius_top_left'] ) ? $_POST['btnsx_opt_border_hover_radius_top_left'] : '' ),
		            	'top_right' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_border_hover_radius_top_right'] ) ? $_POST['btnsx_opt_border_hover_radius_top_right'] : '' ),
		            	'bottom_left' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_border_hover_radius_bottom_left'] ) ? $_POST['btnsx_opt_border_hover_radius_bottom_left'] : '' ),
		            	'bottom_right' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_border_hover_radius_bottom_right'] ) ? $_POST['btnsx_opt_border_hover_radius_bottom_right'] : '' )
		            ),

	            // Shadow
		            'btnsx_box_shadow_normal' 			=> array(
		            	'horizontal' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_box_shadow_normal_horizontal'] ) ? serialize( $_POST['btnsx_opt_box_shadow_normal_horizontal'] ) : '' ),
		            	'vertical' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_box_shadow_normal_vertical'] ) ? serialize( $_POST['btnsx_opt_box_shadow_normal_vertical'] ) : '' ),
		            	'blur' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_box_shadow_normal_blur'] ) ? serialize( $_POST['btnsx_opt_box_shadow_normal_blur'] ) : '' ),
		            	'spread' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_box_shadow_normal_spread'] ) ? serialize( $_POST['btnsx_opt_box_shadow_normal_spread'] ) : '' ),
		            	'position' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_box_shadow_normal_position'] ) ? serialize( $_POST['btnsx_opt_box_shadow_normal_position'] ) : '' ),
		            	'color' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_box_shadow_normal_color'] ) ? serialize( $_POST['btnsx_opt_box_shadow_normal_color'] ) : '' )
		            ),
					'btnsx_box_shadow_hover' 			=> array(
		            	'horizontal' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_box_shadow_hover_horizontal'] ) ? serialize( $_POST['btnsx_opt_box_shadow_hover_horizontal'] ) : '' ),
		            	'vertical' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_box_shadow_hover_vertical'] ) ? serialize( $_POST['btnsx_opt_box_shadow_hover_vertical'] ) : '' ),
		            	'blur' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_box_shadow_hover_blur'] ) ? serialize( $_POST['btnsx_opt_box_shadow_hover_blur'] ) : '' ),
		            	'spread' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_box_shadow_hover_spread'] ) ? serialize( $_POST['btnsx_opt_box_shadow_hover_spread'] ) : '' ),
		            	'position' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_box_shadow_hover_position'] ) ? serialize( $_POST['btnsx_opt_box_shadow_hover_position'] ) : '' ),
		            	'color' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_box_shadow_hover_color'] ) ? serialize( $_POST['btnsx_opt_box_shadow_hover_color'] ) : '' )
		            ),
					'btnsx_box_shadow_css_normal' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_box_shadow_css_normal'] ) ? $_POST['btnsx_opt_box_shadow_css_normal'] : '' ),
					'btnsx_box_shadow_css_hover' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_box_shadow_css_hover'] ) ? $_POST['btnsx_opt_box_shadow_css_hover'] : '' ),

				// Animations
					'btnsx_animation_reveal' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_animation_reveal'] ) ? $_POST['btnsx_opt_animation_reveal'] : '' ),
					'btnsx_animation_hover' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_animation_hover'] ) ? $_POST['btnsx_opt_animation_hover'] : '' ),

				// Responsive
					// Tablet
						// Layout
							'btnsx_tablet_width'		=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_width'] ) ? $_POST['btnsx_opt_tablet_width'] : '' ),
							'btnsx_tablet_height'		=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_height'] ) ? $_POST['btnsx_opt_tablet_height'] : '' ),
						// Primary Text
							'btnsx_tablet_text_font' 					=> array(
				            	'size' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_text_font_size'] ) ? $_POST['btnsx_opt_tablet_text_font_size'] : '' )
				            ),
							'btnsx_tablet_text_padding' 		=> array(
				            	'top' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_text_padding_top'] ) ? $_POST['btnsx_opt_tablet_text_padding_top'] : '' ),
				            	'right' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_text_padding_right'] ) ? $_POST['btnsx_opt_tablet_text_padding_right'] : '' ),
				            	'bottom' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_text_padding_bottom'] ) ? $_POST['btnsx_opt_tablet_text_padding_bottom'] : '' ),
				            	'left' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_text_padding_left'] ) ? $_POST['btnsx_opt_tablet_text_padding_left'] : '' ),
				            ),
						// Secondary Text
							'btnsx_tablet_text_secondary_font' 					=> array(
				            	'size' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_text_secondary_font_size'] ) ? $_POST['btnsx_opt_tablet_text_secondary_font_size'] : '' )
				            ),
							'btnsx_tablet_text_secondary_padding' 		=> array(
				            	'top' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_text_secondary_padding_top'] ) ? $_POST['btnsx_opt_tablet_text_secondary_padding_top'] : '' ),
				            	'right' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_text_secondary_padding_right'] ) ? $_POST['btnsx_opt_tablet_text_secondary_padding_right'] : '' ),
				            	'bottom' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_text_secondary_padding_bottom'] ) ? $_POST['btnsx_opt_tablet_text_secondary_padding_bottom'] : '' ),
				            	'left' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_text_secondary_padding_left'] ) ? $_POST['btnsx_opt_tablet_text_secondary_padding_left'] : '' ),
				            ),
						// Icon
							'btnsx_tablet_icon_size'		=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_icon_size'] ) ? $_POST['btnsx_opt_tablet_icon_size'] : '' ),
							'btnsx_tablet_icon_divider_size'		=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_icon_divider_size'] ) ? $_POST['btnsx_opt_tablet_icon_divider_size'] : '' ),
							'btnsx_tablet_icon_divider_position'		=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_icon_divider_position'] ) ? $_POST['btnsx_opt_tablet_icon_divider_position'] : '' ),
							'btnsx_tablet_icon_padding' 		=> array(
				            	'top' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_icon_padding_top'] ) ? $_POST['btnsx_opt_tablet_icon_padding_top'] : '' ),
				            	'right' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_icon_padding_right'] ) ? $_POST['btnsx_opt_tablet_icon_padding_right'] : '' ),
				            	'bottom' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_icon_padding_bottom'] ) ? $_POST['btnsx_opt_tablet_icon_padding_bottom'] : '' ),
				            	'left' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_icon_padding_left'] ) ? $_POST['btnsx_opt_tablet_icon_padding_left'] : '' ),
				            ),
						// Padding
							'btnsx_tablet_padding' 					=> array(
				            	'top' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_padding_top'] ) ? $_POST['btnsx_opt_tablet_padding_top'] : '' ),
				            	'right' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_padding_right'] ) ? $_POST['btnsx_opt_tablet_padding_right'] : '' ),
				            	'bottom' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_padding_bottom'] ) ? $_POST['btnsx_opt_tablet_padding_bottom'] : '' ),
				            	'left' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_tablet_padding_left'] ) ? $_POST['btnsx_opt_tablet_padding_left'] : '' ),
				            ),
					// Mobile
						// Layout
							'btnsx_mobile_width'		=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_width'] ) ? $_POST['btnsx_opt_mobile_width'] : '' ),
							'btnsx_mobile_height'		=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_height'] ) ? $_POST['btnsx_opt_mobile_height'] : '' ),
						// Primary Text
							'btnsx_mobile_text_font' 		=> array(
				            	'size' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_text_font_size'] ) ? $_POST['btnsx_opt_mobile_text_font_size'] : '' )
				            ),
							'btnsx_mobile_text_padding' 		=> array(
				            	'top' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_text_padding_top'] ) ? $_POST['btnsx_opt_mobile_text_padding_top'] : '' ),
				            	'right' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_text_padding_right'] ) ? $_POST['btnsx_opt_mobile_text_padding_right'] : '' ),
				            	'bottom' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_text_padding_bottom'] ) ? $_POST['btnsx_opt_mobile_text_padding_bottom'] : '' ),
				            	'left' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_text_padding_left'] ) ? $_POST['btnsx_opt_mobile_text_padding_left'] : '' ),
				            ),
						// Secondary Text
							'btnsx_mobile_text_secondary_font' 					=> array(
				            	'size' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_text_secondary_font_size'] ) ? $_POST['btnsx_opt_mobile_text_secondary_font_size'] : '' )
				            ),
							'btnsx_mobile_text_secondary_padding' 		=> array(
				            	'top' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_text_secondary_padding_top'] ) ? $_POST['btnsx_opt_mobile_text_secondary_padding_top'] : '' ),
				            	'right' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_text_secondary_padding_right'] ) ? $_POST['btnsx_opt_mobile_text_secondary_padding_right'] : '' ),
				            	'bottom' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_text_secondary_padding_bottom'] ) ? $_POST['btnsx_opt_mobile_text_secondary_padding_bottom'] : '' ),
				            	'left' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_text_secondary_padding_left'] ) ? $_POST['btnsx_opt_mobile_text_secondary_padding_left'] : '' ),
				            ),
						// Icon
							'btnsx_mobile_icon_size'		=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_icon_size'] ) ? $_POST['btnsx_opt_mobile_icon_size'] : '' ),
							'btnsx_mobile_icon_divider_size'		=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_icon_divider_size'] ) ? $_POST['btnsx_opt_mobile_icon_divider_size'] : '' ),
							'btnsx_mobile_icon_divider_position'		=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_icon_divider_position'] ) ? $_POST['btnsx_opt_mobile_icon_divider_position'] : '' ),
							'btnsx_mobile_icon_padding' 		=> array(
				            	'top' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_icon_padding_top'] ) ? $_POST['btnsx_opt_mobile_icon_padding_top'] : '' ),
				            	'right' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_icon_padding_right'] ) ? $_POST['btnsx_opt_mobile_icon_padding_right'] : '' ),
				            	'bottom' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_icon_padding_bottom'] ) ? $_POST['btnsx_opt_mobile_icon_padding_bottom'] : '' ),
				            	'left' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_icon_padding_left'] ) ? $_POST['btnsx_opt_mobile_icon_padding_left'] : '' ),
				            ),
						// Padding
							'btnsx_mobile_padding' 					=> array(
				            	'top' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_padding_top'] ) ? $_POST['btnsx_opt_mobile_padding_top'] : '' ),
				            	'right' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_padding_right'] ) ? $_POST['btnsx_opt_mobile_padding_right'] : '' ),
				            	'bottom' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_padding_bottom'] ) ? $_POST['btnsx_opt_mobile_padding_bottom'] : '' ),
				            	'left' 								=> sanitize_text_field( isset( $_POST['btnsx_opt_mobile_padding_left'] ) ? $_POST['btnsx_opt_mobile_padding_left'] : '' ),
				            ),

				// JS
					'btnsx_js'							=> sanitize_text_field( isset( $_POST['btnsx_opt_js'] ) ? $_POST['btnsx_opt_js'] : '' ),

				// Tab
					'btnsx_tab'							=> sanitize_text_field( isset( $_POST['btnsx_opt_tab'] ) ? $_POST['btnsx_opt_tab'] : '' ),
					'btnsx_tab_content'					=> sanitize_text_field( isset( $_POST['btnsx_opt_tab_content'] ) ? $_POST['btnsx_opt_tab_content'] : '' ),
					'btnsx_tab_group_content'			=> sanitize_text_field( isset( $_POST['btnsx_opt_tab_group_content'] ) ? $_POST['btnsx_opt_tab_group_content'] : '' ),
					'btnsx_tab_group_style'				=> sanitize_text_field( isset( $_POST['btnsx_opt_tab_group_style'] ) ? $_POST['btnsx_opt_tab_group_style'] : '' ),
					'btnsx_tab_group_advanced'			=> sanitize_text_field( isset( $_POST['btnsx_opt_tab_group_advanced'] ) ? $_POST['btnsx_opt_tab_group_advanced'] : '' ),
					'btnsx_tab_group_expert'			=> sanitize_text_field( isset( $_POST['btnsx_opt_tab_group_expert'] ) ? $_POST['btnsx_opt_tab_group_expert'] : '' ),

				// Override Styles
					'btnsx_override_style_type' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_override_style_type'] ) ? serialize( $_POST['btnsx_opt_override_style_type'] ) : '' ),
					'btnsx_override_style_custom_class' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_override_style_custom_class'] ) ? $_POST['btnsx_opt_override_style_custom_class'] : '' ),

				// Gravity form
					'btnsx_gravity_form_id' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_gravity_form_id'] ) ? $_POST['btnsx_opt_gravity_form_id'] : '' ),
				// Hide Buttons
					'btnsx_hide_button_desktop' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_hide_button_desktop'] ) ? $_POST['btnsx_opt_hide_button_desktop'] : '' ),
					'btnsx_hide_button_tablet' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_hide_button_tablet'] ) ? $_POST['btnsx_opt_hide_button_tablet'] : '' ),
					'btnsx_hide_button_mobile' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_hide_button_mobile'] ) ? $_POST['btnsx_opt_hide_button_mobile'] : '' ),
				// Display button
					'btnsx_display_button' 		=> isset( $_POST['btnsx_opt_display_button'] ) ? $_POST['btnsx_opt_display_button'] : array()
	        );

			// filter to save custom options
			$btnsx_filtered_data = apply_filters( 'btnsx_save_data_filter', array(), $btnsx_data );
        	$btnsx_data_mixed = wp_parse_args( $btnsx_filtered_data, $btnsx_data );

        	// WMPL
		    /**
		     * register strings for translation
		     */
		    if( has_action('wpml_register_single_string') ) {
		    	do_action( 'wpml_register_single_string', 'btnsx-'.$post_id, 'Primary Text', $btnsx_data_mixed['btnsx_text'] );
		    }
		    // WMPL

        	// var_dump( $btnsx_data_mixed );
        	// wp_die();

	        // Update the meta field in the database.
	        update_post_meta( $post_id, 'btnsx', $btnsx_data_mixed );
	    }

	    /**
	     * Function to check whether the given value is serializable/unserializable without throwing error
	     * @since  0.1
	     * @param  mixed    $str
	     * @return boolean
	     */
	    public function is_serialized( $str ) {
	    	if( $str != '' )
		    	return ( $str == serialize( false ) || @unserialize( $str ) !== false );
		    else
		    	return false;
		}

	    /**
	     * Function to check short code paramter values, if empty fetch values from meta data
	     * @since  0.1
	     * @param  string    $variable passed parameter value in short code
	     * @param  string    $id post ID
	     * @param  array     $field meta values function parameters
	     * @param  array     $type parameter use type. Used as css, class or attribute.
	     * @return string
	     */
	    public function empty_check_definition( $variable = '', $id = '', $field = array(), $type = array() ) {

	    	$defaults = array(
	    		'css' => false,
	    		'css_prefix' => '',
	    		'css_suffix' => '',
	    		'class' => false,
	    		'class_name' => '',
	    		'attribute' => false,
	    		'attribute_name' => ''
	    	);

	    	$type = array_merge( $defaults, $type );

	    	if( is_array( $field ) && $field != null ){
	    		// check if value is serialized
	    		$serializable = $this->is_serialized( $this->meta_values( $id, $field ) ); // @TODO - FIX - removed (string) before $this->meta..
	    		// if serialized, unserialize value
	    		$meta_value = $serializable != false ? unserialize( $this->meta_values( $id, $field ) ) : $this->meta_values( $id, $field );
	    		// store value
		    	$variable = $variable != '' ? $variable : $meta_value;

				if( $type['css'] === true && $type['class'] === false && $type['attribute'] === false ) {
					if( $variable != '' ){
						$variable = sanitize_text_field( $type['css_prefix'] ) . ':' . sanitize_text_field( $variable ) . sanitize_text_field( $type['css_suffix'] ) . ';';
					}
				}

				if( $type['css'] === false && $type['class'] === true && $type['attribute'] === false ) {
					if( $variable == '1' ){
						$variable = ' ' . esc_attr( $type['class_name'] );
					}
				}

				if( $type['css'] === false && $type['class'] === false && $type['attribute'] === true ) {
					if( $variable != '' ){
						$variable = ' ' . sanitize_text_field( $type['attribute_name'] ) . '="' . esc_attr( $variable ) . '"';
					}
				}

				return $variable;

			}
	    }

	    /**
	     * Function to generate general css styles
	     * @since  1.3
	     * @param  string    $normal Normal selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function general_css( $id, $normal, $forced, $compact ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	if( $normal != '' ){
	    		$css .= ( $compact === true ) ? '' : $normal .'{';
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_width' ), array( 'css' => true, 'css_prefix' => 'width', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_height' ), array( 'css' => true, 'css_prefix' => 'height', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_alignment' ), array( 'css' => true, 'css_prefix' => 'text-align', 'css_suffix' =>  $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_margin', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'margin-top', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_margin', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'margin-bottom', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_margin', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'margin-left', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_margin', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'margin-right', 'css_suffix' => 'px' . $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_padding', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'padding-top', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_padding', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'padding-bottom', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_padding', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'padding-left', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_padding', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'padding-right', 'css_suffix' => 'px' . $important ) );
	    		$hide = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_hide_button_desktop' ), array() );
	    		if( $hide == '1' ){
	    			$css .= 'display:none;';
	    		}
	    		$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
	    	}
			return $css;
	    }

	    /**
	     * Function to generate primary text css styles
	     * @since  1.3
	     * @param  string    $normal Normal selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function primary_text_css( $id, $normal, $forced, $compact ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	if( $normal != '' ){
	    		$css .= ( $compact === true ) ? '' : $normal .'{';
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_transform' ), array( 'css' => true, 'css_prefix' => 'text-transform', 'css_suffix' =>  $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_font', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'font-size', 'css_suffix' => 'px' . $important ) );
	    		$line_height = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_vertical_space' ), array() );
	    		if( $line_height ){
	    			$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_vertical_space' ), array( 'css' => true, 'css_prefix' => 'line-height', 'css_suffix' => 'px' . $important ) );
	    		} else {
	    			$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_font', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'line-height', 'css_suffix' => 'px' . $important ) );
	    		}
	    		$text_primary_font_weight = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_font', 'field2' => 'weight' ), array() );
	    		if( preg_match('/[0-9]+[a-z]+/', $text_primary_font_weight) ) {
	    			$css .= 'font-weight:' . preg_replace('/[^0-9]/', '', $text_primary_font_weight ) . ';';
	    			$css .= 'font-style:italic;';
	    		} else {
	    			if($text_primary_font_weight){
	    				$css .= 'font-weight:' . $text_primary_font_weight . ';';
	    			}
	    			$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_font', 'field2' => 'style' ), array( 'css' => true, 'css_prefix' => 'font-style', 'css_suffix' => $important ) );
	    		}
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_font', 'field2' => 'family' ), array( 'css' => true, 'css_prefix' => 'font-family', 'css_suffix' => $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_color', 'field2' => 'normal' ), array( 'css' => true, 'css_prefix' => 'color', 'css_suffix' => $important ) );

				$text_primary_shadow_horizontal = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_shadow', 'field2' => 'horizontal' ), array() );
				$text_primary_shadow_vertical = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_shadow', 'field2' => 'vertical' ), array() );
				$text_primary_shadow_blur = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_shadow', 'field2' => 'blur' ), array() );
				$text_primary_shadow_color = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_shadow', 'field2' => 'color' ), array() );
				if( !empty($text_primary_shadow_horizontal) || !empty($text_primary_shadow_vertical) ) {
					$css .= 'text-shadow:' . $text_primary_shadow_horizontal . 'px ' . $text_primary_shadow_vertical . 'px ' . $text_primary_shadow_blur . 'px ' . $text_primary_shadow_color . $important . ';';
				}

				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_padding', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'padding-top', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_padding', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'padding-bottom', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_padding', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'padding-left', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_padding', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'padding-right', 'css_suffix' => 'px' . $important ) );
	    		$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
	    	}
			return $css;
	    }

	    /**
	     * Function to generate primary text hover css styles
	     * @since  1.3
	     * @param  string    $hover Hover selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function primary_text_hover_css( $id, $hover, $forced, $compact ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	if( $hover != '' ){
	    		$text_primary_color_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_color', 'field2' => 'hover' ), array() );
				if( $text_primary_color_hover != '' ){
					$css .= ( $compact === true ) ? '' : $hover . '{';
					$css .= 'color:' . $text_primary_color_hover . $important . ';';
					$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
				}
	    	}
			return $css;
	    }

	    /**
	     * Function to generate background css styles
	     * @since  1.3
	     * @param  string    $normal Normal selector
	     * @param  boolean    $before Hover selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function background_css( $id, $normal, $before, $forced, $compact ) {
	    	// Animation
				$animation_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_animation_hover' ), array() );
				$animation_hover_no_bg = array( 'hvr-bounce-to-bottom', 'hvr-bounce-to-top', 'hvr-bounce-to-left', 'hvr-bounce-to-right', 'hvr-radial-in', 'hvr-radial-out', 'hvr-rectangle-in', 'hvr-rectangle-out', 'hvr-shutter-in-horizontal', 'hvr-shutter-in-vertical', 'hvr-shutter-out-horizontal', 'hvr-shutter-out-vertical', 'hvr-sweep-to-bottom', 'hvr-sweep-to-top', 'hvr-sweep-to-left', 'hvr-sweep-to-right', 'hvr-overline-from-center', 'hvr-overline-from-left', 'hvr-overline-from-right', 'hvr-overline-reveal', 'hvr-trim', 'hvr-underline-from-center', 'hvr-underline-from-left', 'hvr-underline-from-right', 'hvr-underline-reveal'  );
				$animation_hover_no_bg_before = array( 'hvr-trim', 'hvr-bounce-in', 'hvr-curl-top-right', 'hvr-curl-bottom-left', 'hvr-curl-bottom-right', 'hvr-curl-top-left'  );
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	if( $normal != '' ){
	    		$css .= ( $compact === true ) ? '' : $normal .'{';
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_background_color', 'field2' => 'normal' ), array( 'css' => true, 'css_prefix' => 'background-color', 'css_suffix' => $important ) );
				$background_image = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_background_image_normal' ), array() );
				if( $background_image != '' ){
					$css .= 'background-image:url(' . $background_image . ')' . $important .';';
				}
				$background_image_repeat = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_background_image_repeat' ), array() );
				if( $background_image_repeat != '' ){
					$css .= 'background-repeat:' . $background_image_repeat . $important .';';
				}
				$background_image_position = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_background_image_position' ), array() );
				if( $background_image_position != '' ){
					$css .= 'background-position:' . $background_image_position . $important .';';
				}
				$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
				// Background image flicker fix on button hover
				$background_image_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_background_image_hover' ), array() );
				if( $background_image_hover != '' ){
					$css .= '#btnsx-' . $id . ':after{';
					$css .= 'position:absolute;width:0;height:0;overflow:hidden;z-index:-1;';
					$css .= 'content:url('. $background_image_hover .')';
					$css .= '}' . PHP_EOL;
				}
	    	}
	    	if( $before != '' ){
	    		// before
				if( !in_array( $animation_hover, $animation_hover_no_bg_before ) ) {
					$css .= '#btnsx-' . $id . ':before{';
					$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_background_color', 'field2' => 'hover' ), array( 'css' => true, 'css_prefix' => 'background-color', 'css_suffix' => $important ) );
					$css .= '}' . PHP_EOL;
				}
	    	}
			return $css;
	    }

	    /**
	     * Function to generate background css styles
	     * @since  1.3
	     * @param  string    $hover Hover selector
	     * @param  boolean    $before Hover selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function background_hover_css( $id, $hover, $forced, $compact ) {
	    	// Animation
				$animation_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_animation_hover' ), array() );
				$animation_hover_no_bg = array( 'hvr-bounce-to-bottom', 'hvr-bounce-to-top', 'hvr-bounce-to-left', 'hvr-bounce-to-right', 'hvr-radial-in', 'hvr-radial-out', 'hvr-rectangle-in', 'hvr-rectangle-out', 'hvr-shutter-in-horizontal', 'hvr-shutter-in-vertical', 'hvr-shutter-out-horizontal', 'hvr-shutter-out-vertical', 'hvr-sweep-to-bottom', 'hvr-sweep-to-top', 'hvr-sweep-to-left', 'hvr-sweep-to-right', 'hvr-overline-from-center', 'hvr-overline-from-left', 'hvr-overline-from-right', 'hvr-overline-reveal', 'hvr-trim', 'hvr-underline-from-center', 'hvr-underline-from-left', 'hvr-underline-from-right', 'hvr-underline-reveal' );
				$animation_hover_no_bg_before = array( 'hvr-trim', 'hvr-bounce-in', 'hvr-curl-top-right', 'hvr-curl-bottom-left', 'hvr-curl-bottom-right', 'hvr-curl-top-left'  );
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	if( $hover != '' ){
	    		$css .= ( $compact === true ) ? '' : $hover . '{';
					if( !in_array( $animation_hover, $animation_hover_no_bg ) ) {
						$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_background_color', 'field2' => 'hover' ), array( 'css' => true, 'css_prefix' => 'background-color', 'css_suffix' => $important ) );
					}
					$background_image_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_background_image_hover' ), array() );
					if( $background_image_hover != '' ){
						$css .= 'background-image:url(' . $background_image_hover . ')' . $important .';';
					}
					$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
	    	}
			return $css;
	    }

	    /**
	     * Function to generate gradient css styles
	     * @since  1.3
	     * @param  string    $normal Normal selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function gradient_css( $id, $normal, $forced, $compact ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	if( $normal != '' ){
	    		$gradient_type = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_gradient_type_normal' ), array() );

	    		if($gradient_type === 'none') {
	    			return $css;
	    		}

				$gradient_stop_color = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_gradient_stop_normal', 'field2' => 'color' ), array() );
				$gradient_stop_location = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_gradient_stop_normal', 'field2' => 'location' ), array() );

				$prefixMozilla			= '-moz-linear-gradient';
	    		$prefixWebkit 			= '-webkit-gradient';
	    		$prefixWebkit2			= '-webkit-linear-gradient';
	    		$prefixOpera			= '-o-linear-gradient';
	    		$prefixMicrosoft		= '-ms-linear-gradient';
	    		$prefix 				= 'linear-gradient';
	    		$angle;$angle2;$angle3;

	    		if( $gradient_type === 'vertical' ){
		    		$angle				= 'top,';
		    		$angle2				= 'linear, left top, left bottom,';
		    		$angle3				= 'to bottom,';
		    	} else if( $gradient_type === 'horizontal' ){
		    		$angle				= 'left,';
		    		$angle2				= 'linear, left top, right top,';
		    		$angle3				= 'to right,';
		    	} else if( $gradient_type === 'diagonal_top' ){
		    		$angle				= '-45deg,';
		    		$angle2				= 'linear, left top, right bottom,';
		    		$angle3				= '135deg,';
		    	} else if( $gradient_type === 'diagonal_bottom' ){
		    		$angle				= '45deg,';
		    		$angle2				= 'linear, left bottom, right top,';
		    		$angle3				= '45deg,';
		    	} else {
		    		$prefixMozilla		= '-moz-radial-gradient';
		    		$prefixWebkit2		= '-webkit-radial-gradient';
		    		$prefixOpera		= '-o-radial-gradient';
		    		$prefixMicrosoft	= '-ms-radial-gradient';
		    		$prefix 			= 'radial-gradient';
		    		$angle				= 'center, ellipse cover,';
		    		$angle2				= 'radial, center center, 0px, center center, 100%,';
		    		$angle3				= 'ellipse at center,';
		    	}

		        $gradient_stops = '';$gradient_stops2 = '';$start_color = '';$end_color = '';$val_check = '';
		        $gradient_count = is_array( $gradient_stop_color ) ? count( $gradient_stop_color ) : '';
		        if( $gradient_count != '' ){
		        	for ( $i = 0; $i < $gradient_count; $i++ ) {
			        	if( isset( $gradient_stop_color[$i] ) ){
				        	if( $gradient_stop_color[$i] != '' ) {
			            		$gradient_stop_color[$i] = $gradient_stop_color[$i];
			            	}
			            	if( $gradient_stop_location[$i] != '' ) {
			            		$gradient_stop_location[$i] = $gradient_stop_location[$i];
			            	}
			            	if( $i === 0 ) {
			            		$start_color = $gradient_stop_color[$i];
			            		if( $gradient_stop_location[$i] != '' ) {
			            			$val_check = 1;
			            		}
			            	}
				            if ( $i == $gradient_count - 1 ) {
				                $gradient_stops .= $gradient_stop_color[$i] . ' ' . $gradient_stop_location[$i] . '%';
				                $gradient_stops2 .= 'color-stop(' . $gradient_stop_location[$i] . '%,' . $gradient_stop_color[$i] . ')';
				                $end_color = $gradient_stop_color[$i];
				            } else {
				                $gradient_stops .= $gradient_stop_color[$i] . ' ' . $gradient_stop_location[$i] . '%,';
				                $gradient_stops2 .= 'color-stop(' . $gradient_stop_location[$i] . '%,' . $gradient_stop_color[$i] . '),';
				            }
				        }
			        }
			        if( $val_check === 1 ) {
			        	$css .= ( $compact === true ) ? '' : $normal . '{';
		        		$css .= 'background: ' . $prefixMozilla . '(' . $angle . ' ' . $gradient_stops . ')' . $important . ';background: '.$prefixWebkit.'('.$angle2.' '.$gradient_stops2.')' . $important . ';background: '.$prefixWebkit2.'('.$angle.' '.$gradient_stops.')' . $important . ';background: '.$prefixOpera.'('.$angle.' '.$gradient_stops.')' . $important . ';background: '.$prefixMicrosoft.'('.$angle.' '.$gradient_stops.')' . $important . ';background: '.$prefix.'('.$angle3.' '.$gradient_stops.')' . $important . ';filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="'.$start_color.'", endColorstr="'.$end_color.'",GradientType=0 )' . $important . ';';
		        		$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
			        }
		        }

				$gradient_css = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_gradient_css_normal' ), array() );
				if( $gradient_css != '' ){
					$css .= ( $compact === true ) ? '' : $normal . '{';
					$css .= 'background: ' . $gradient_css . ';';
					$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
				}
	    	}
			return $css;
	    }

	    /**
	     * Function to generate gradient css styles
	     * @since  1.3
	     * @param  string    $hover Hover selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function gradient_hover_css( $id, $hover, $forced, $compact ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	if( $hover != '' ){
	    		$gradient_type_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_gradient_type_hover' ), array() );
	    		if($gradient_type_hover === 'none') {
	    			return $css;
	    		}
	    		$gradient_stop_color_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_gradient_stop_hover', 'field2' => 'color' ), array() );
				$gradient_stop_location_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_gradient_stop_hover', 'field2' => 'location' ), array() );

				$prefixMozilla			= '-moz-linear-gradient';
	    		$prefixWebkit 			= '-webkit-gradient';
	    		$prefixWebkit2			= '-webkit-linear-gradient';
	    		$prefixOpera			= '-o-linear-gradient';
	    		$prefixMicrosoft		= '-ms-linear-gradient';
	    		$prefix 				= 'linear-gradient';
	    		$angle;$angle2;$angle3;

	    		if( $gradient_type_hover === 'vertical' ){
		    		$angle				= 'top,';
		    		$angle2				= 'linear, left top, left bottom,';
		    		$angle3				= 'to bottom,';
		    	} else if( $gradient_type_hover === 'horizontal' ){
		    		$angle				= 'left,';
		    		$angle2				= 'linear, left top, right top,';
		    		$angle3				= 'to right,';
		    	} else if( $gradient_type_hover === 'diagonal_top' ){
		    		$angle				= '-45deg,';
		    		$angle2				= 'linear, left top, right bottom,';
		    		$angle3				= '135deg,';
		    	} else if( $gradient_type_hover === 'diagonal_bottom' ){
		    		$angle				= '45deg,';
		    		$angle2				= 'linear, left bottom, right top,';
		    		$angle3				= '45deg,';
		    	} else {
		    		$prefixMozilla		= '-moz-radial-gradient';
		    		$prefixWebkit2		= '-webkit-radial-gradient';
		    		$prefixOpera		= '-o-radial-gradient';
		    		$prefixMicrosoft	= '-ms-radial-gradient';
		    		$prefix 			= 'radial-gradient';
		    		$angle				= 'center, ellipse cover,';
		    		$angle2				= 'radial, center center, 0px, center center, 100%,';
		    		$angle3				= 'ellipse at center,';
		    	}

				$gradient_stops_hover = '';$gradient_stops2_hover = '';$start_color_hover = '';$end_color_hover = '';$val_check_hover = '';
		        $gradient_count_hover = is_array( $gradient_stop_color_hover ) ? count( $gradient_stop_color_hover ) : '';
		        for ( $i = 0; $i < $gradient_count_hover; $i++ ) {
		        	if( isset( $gradient_stop_color_hover[$i] ) ){
			        	if( $gradient_stop_color_hover[$i] != '' ) {
		            		$gradient_stop_color_hover[$i] = $gradient_stop_color_hover[$i];
		            	}
		            	if( $gradient_stop_location_hover[$i] != '' ) {
		            		$gradient_stop_location_hover[$i] = $gradient_stop_location_hover[$i];
		            	}
		            	if( $i === 0 ) {
		            		$start_color_hover = $gradient_stop_color_hover[$i];
		            		if( $gradient_stop_location_hover[$i] != '' ) {
		            			$val_check_hover = 1;
		            		}
		            	}
			            if ( $i == $gradient_count_hover - 1 ) {
			                $gradient_stops_hover .= $gradient_stop_color_hover[$i] . ' ' . $gradient_stop_location_hover[$i] . '%';
			                $gradient_stops2_hover .= 'color-stop(' . $gradient_stop_location_hover[$i] . '%,' . $gradient_stop_color_hover[$i] . ')';
			                $end_color_hover = $gradient_stop_color_hover[$i];
			            } else {
			                $gradient_stops_hover .= $gradient_stop_color_hover[$i] . ' ' . $gradient_stop_location_hover[$i] . '%,';
			                $gradient_stops2_hover .= 'color-stop(' . $gradient_stop_location_hover[$i] . '%,' . $gradient_stop_color_hover[$i] . '),';
			            }
			        }
		        }
		        if( $gradient_count_hover != '' ){
		        	if( $val_check_hover === 1 ) {
		        		$css .= ( $compact === true ) ? '' : $hover . '{';
		        		$css .= 'background: ' . $prefixMozilla . '(' . $angle . ' ' . $gradient_stops_hover . ')' . $important . ';background: '.$prefixWebkit.'('.$angle2.' '.$gradient_stops2_hover.')' . $important . ';background: '.$prefixWebkit2.'('.$angle.' '.$gradient_stops_hover.')' . $important . ';background: '.$prefixOpera.'('.$angle.' '.$gradient_stops_hover.')' . $important . ';background: '.$prefixMicrosoft.'('.$angle.' '.$gradient_stops_hover.')' . $important . ';background: '.$prefix.'('.$angle3.' '.$gradient_stops_hover.')' . $important . ';filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="'.$start_color_hover.'", endColorstr="'.$end_color_hover.'",GradientType=0 )' . $important . ';';
		        		$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
		        	}
		        }

            	$gradient_css_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_gradient_css_hover' ), array() );
            	if( $gradient_css_hover != '' ){
					$css .= ( $compact === true ) ? '' : $hover . '{';
					$css .= 'background: ' . $gradient_css_hover . ';';
					$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
				}
	    	}
			return $css;
	    }

	    /**
	     * Function to generate border css styles
	     * @since  1.3
	     * @param  string    $normal Normal selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function border_css( $id, $normal, $forced, $compact ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	$border_normal_top = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_normal', 'field2' => 'top' ), array() );
	    	$border_normal_bottom = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_normal', 'field2' => 'bottom' ), array() );
	    	$border_normal_left = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_normal', 'field2' => 'left' ), array() );
	    	$border_normal_right = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_normal', 'field2' => 'right' ), array() );
	    	if( $normal != '' ){
	    		$css .= ( $compact === true ) ? '' : $normal . '{';
	    		if( $border_normal_top != '0' ){
					$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_normal', 'field2' => 'size', 'value' => 0 ), array( 'css' => true, 'css_prefix' => 'border-top-width', 'css_suffix' => 'px' . $important ) );
				}
				if( $border_normal_bottom != '0' ){
					$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_normal', 'field2' => 'size', 'value' => 0 ), array( 'css' => true, 'css_prefix' => 'border-bottom-width', 'css_suffix' => 'px' . $important ) );
				}
				if( $border_normal_left != '0' ){
					$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_normal', 'field2' => 'size', 'value' => 0 ), array( 'css' => true, 'css_prefix' => 'border-left-width', 'css_suffix' => 'px' . $important ) );
				}
				if( $border_normal_right != '0' ){
					$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_normal', 'field2' => 'size', 'value' => 0 ), array( 'css' => true, 'css_prefix' => 'border-right-width', 'css_suffix' => 'px' . $important ) );
				}
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_normal', 'field2' => 'style' ), array( 'css' => true, 'css_prefix' => 'border-style', 'css_suffix' => $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_normal', 'field2' => 'color' ), array( 'css' => true, 'css_prefix' => 'border-color', 'css_suffix' => $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_normal_radius', 'field2' => 'top_left' ), array( 'css' => true, 'css_prefix' => 'border-top-left-radius', 'css_suffix' => 'px' . $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_normal_radius', 'field2' => 'top_right' ), array( 'css' => true, 'css_prefix' => 'border-top-right-radius', 'css_suffix' => 'px' . $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_normal_radius', 'field2' => 'bottom_left' ), array( 'css' => true, 'css_prefix' => 'border-bottom-left-radius', 'css_suffix' => 'px' . $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_normal_radius', 'field2' => 'bottom_right' ), array( 'css' => true, 'css_prefix' => 'border-bottom-right-radius', 'css_suffix' => 'px' . $important ) );
				$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
	    	}
			return $css;
	    }

	    /**
	     * Function to generate border hover css styles
	     * @since  1.3
	     * @param  string    $hover Hover selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function border_hover_css( $id, $hover, $forced, $compact ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	$border_hover_top = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_hover', 'field2' => 'top', 'value' => '0' ), array() );
	    	$border_hover_bottom = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_hover', 'field2' => 'bottom', 'value' => '0' ), array() );
	    	$border_hover_left = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_hover', 'field2' => 'left', 'value' => '0' ), array() );
	    	$border_hover_right = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_hover', 'field2' => 'right', 'value' => '0' ), array() );
	    	if( $hover != '' ){
	    		$css .= ( $compact === true ) ? '' : $hover .'{';
	    		if( $border_hover_top != '0' ){
					$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_hover', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'border-top-width', 'css_suffix' => 'px' . $important ) );
				}
				if( $border_hover_bottom != '0' ){
					$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_hover', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'border-bottom-width', 'css_suffix' => 'px' . $important ) );
				}
				if( $border_hover_left != '0' ){
					$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_hover', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'border-left-width', 'css_suffix' => 'px' . $important ) );
				}
				if( $border_hover_right != '0' ){
					$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_hover', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'border-right-width', 'css_suffix' => 'px' . $important ) );
				}
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_hover', 'field2' => 'style' ), array( 'css' => true, 'css_prefix' => 'border-style', 'css_suffix' => $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_hover', 'field2' => 'color' ), array( 'css' => true, 'css_prefix' => 'border-color', 'css_suffix' => $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_hover_radius', 'field2' => 'top_left' ), array( 'css' => true, 'css_prefix' => 'border-top-left-radius', 'css_suffix' => 'px' . $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_hover_radius', 'field2' => 'top_right' ), array( 'css' => true, 'css_prefix' => 'border-top-right-radius', 'css_suffix' => 'px' . $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_hover_radius', 'field2' => 'bottom_left' ), array( 'css' => true, 'css_prefix' => 'border-bottom-left-radius', 'css_suffix' => 'px' . $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_border_hover_radius', 'field2' => 'bottom_right' ), array( 'css' => true, 'css_prefix' => 'border-bottom-right-radius', 'css_suffix' => 'px' . $important ) );
				$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
	    	}
			return $css;
	    }

	    /**
	     * Function to generate box shadow css styles
	     * @since  1.3
	     * @param  int   	$id button id
	     * @param  string    $normal Normal selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function box_shadow_css( $id, $normal, $forced, $compact ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	if( $normal != '' ){
	    		$shadow_horizontal = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_box_shadow_normal', 'field2' => 'horizontal' ), array() );
				$shadow_vertical = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_box_shadow_normal', 'field2' => 'vertical' ), array() );
				$shadow_blur = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_box_shadow_normal', 'field2' => 'blur' ), array() );
				$shadow_spread = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_box_shadow_normal', 'field2' => 'spread' ), array() );
				$shadow_position = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_box_shadow_normal', 'field2' => 'position' ), array() );
				$shadow_color = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_box_shadow_normal', 'field2' => 'color' ), array() );

		        $box_shadow = '';

		        if( is_array($shadow_horizontal) ){
		        	$shadow_horizontal = array_filter($shadow_horizontal,'is_numeric');
		        }
		        if( is_array($shadow_vertical) ){
		        	$shadow_vertical = array_filter($shadow_vertical,'is_numeric');
		        }

		        if( empty($shadow_horizontal) && empty($shadow_vertical)  ){
		        	$css .= ( $compact === true ) ? '' : $normal .'{';
		        	$css .= '-webkit-box-shadow:none;box-shadow:none;';
		        	$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
		        }

		        $shadow_count = is_array( $shadow_horizontal ) ? count( $shadow_horizontal ) : '';
		        for ( $i = 0; $i < $shadow_count; $i++ ) {
		        	if( isset( $shadow_horizontal[$i] ) ){
			        	if( $shadow_horizontal[$i] != '' ) {
		            		$shadow_horizontal[$i] = $shadow_horizontal[$i] . 'px ';
		            	}
		            	if( $shadow_vertical[$i] != '' ) {
		            		$shadow_vertical[$i] = $shadow_vertical[$i] . 'px ';
		            	}
		            	if( $shadow_blur[$i] != '' ) {
		            		$shadow_blur[$i] = $shadow_blur[$i] . 'px ';
		            	}
		            	if( $shadow_spread[$i] != '' ) {
		            		$shadow_spread[$i] = $shadow_spread[$i] . 'px ';
		            	}
		            	if( $shadow_color[$i] != '' ) {
		            		$shadow_color[$i] = $shadow_color[$i] . ' ';
		            	}
			            if( !is_array( $shadow_horizontal ) ) {
			            	if( $shadow_horizontal != '' ) {
			            		$shadow_horizontal = $shadow_horizontal . 'px ';
			            	}
			            	if( $shadow_vertical != '' ) {
			            		$shadow_vertical = $shadow_vertical . 'px ';
			            	}
			            	if( $shadow_blur != '' ) {
			            		$shadow_blur = $shadow_blur . 'px ';
			            	}
			            	if( $shadow_spread != '' ) {
			            		$shadow_spread = $shadow_spread . 'px ';
			            	}
			            	if( $shadow_color != '' ) {
			            		$shadow_color = $shadow_color . ' ';
			            	}
			                $box_shadow .= $shadow_horizontal . $shadow_vertical . $shadow_blur . $shadow_spread . $shadow_color . $shadow_position;
			            } elseif ( $i == $shadow_count - 1 ){
			            	$shadow_horizontal[ $i ] = isset( $shadow_horizontal[ $i ] ) ? $shadow_horizontal[ $i ] : '';
			            	$shadow_vertical[ $i ] = isset( $shadow_vertical[ $i ] ) ? $shadow_vertical[ $i ] : '';
			            	$shadow_blur[ $i ] = isset( $shadow_blur[ $i ] ) ? $shadow_blur[ $i ] : '';
			            	$shadow_spread[ $i ] = isset( $shadow_spread[ $i ] ) ? $shadow_spread[ $i ] : '';
			            	$shadow_color[ $i ] = isset( $shadow_color[ $i ] ) ? $shadow_color[ $i ] : '';
			            	$shadow_position[ $i ] = isset( $shadow_position[ $i ] ) ? $shadow_position[ $i ] : 'outset';
			                $box_shadow .= $shadow_horizontal[ $i ] . $shadow_vertical[ $i ] . $shadow_blur[ $i ] . $shadow_spread[ $i ] . $shadow_color[ $i ] . $shadow_position[ $i ];
			            } else {
			                $box_shadow .= $shadow_horizontal[ $i ] . $shadow_vertical[ $i ] . $shadow_blur[ $i ] . $shadow_spread[ $i ] . $shadow_color[ $i ] . $shadow_position[ $i ] . ',';
			            }
			        }
		        }
		        if( $shadow_count != '' ){
			        if( $box_shadow != '' ){
			        	$css .= ( $compact === true ) ? '' : $normal .'{';
			        	$css .= '-webkit-box-shadow:' . $box_shadow . $important . ';box-shadow:' . $box_shadow . $important . ';';
			        	$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
			        }
			    }
			    $shadow_css = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_box_shadow_css_normal' ), array() );
		        if( $shadow_css != '' ) {
		        	$css .= ( $compact === true ) ? '' : $normal .'{';
		        	$css .= '-webkit-box-shadow:' . $shadow_css . $important . ';box-shadow:' . $shadow_css . $important . ';';
		        	$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
		        }
	    	}
			return $css;
	    }

	    /**
	     * Function to generate box shadow hover css styles
	     * @since  1.3
	     * @param  string    $hover Hover selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function box_shadow_hover_css( $id, $hover, $forced, $compact ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	if( $hover != '' ){
	    		$shadow_horizontal_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_box_shadow_hover', 'field2' => 'horizontal' ), array() );
				$shadow_vertical_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_box_shadow_hover', 'field2' => 'vertical' ), array() );
				$shadow_blur_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_box_shadow_hover', 'field2' => 'blur' ), array() );
				$shadow_spread_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_box_shadow_hover', 'field2' => 'spread' ), array() );
				$shadow_position_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_box_shadow_hover', 'field2' => 'position' ), array() );
				$shadow_color_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_box_shadow_hover', 'field2' => 'color' ), array() );

		        $box_shadow_hover = '';

		        if( is_array($shadow_horizontal_hover) ){
		        	$shadow_horizontal_hover = array_filter($shadow_horizontal_hover,'is_numeric');
		        }
		        if( is_array($shadow_vertical_hover) ){
		        	$shadow_vertical_hover = array_filter($shadow_vertical_hover,'is_numeric');
		        }

		        if( empty($shadow_horizontal_hover) && empty($shadow_vertical_hover)  ){
		        	$css .= ( $compact === true ) ? '' : $hover .'{';
		        	$css .= '-webkit-box-shadow:none;box-shadow:none;';
		        	$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
		        }

		        $shadow_count_hover = is_array( $shadow_horizontal_hover ) ? count( $shadow_horizontal_hover ) : '';
		        for ( $i = 0; $i < $shadow_count_hover; $i++ ) {
		        	if( isset( $shadow_horizontal_hover[$i] ) ){
			        	if( isset($shadow_horizontal_hover) && $shadow_horizontal_hover[$i] != '' ) {
		            		$shadow_horizontal_hover[$i] = $shadow_horizontal_hover[$i] . 'px ';
		            	}
		            	if( isset($shadow_vertical_hover[$i]) && $shadow_vertical_hover[$i] != '' ) {
		            		$shadow_vertical_hover[$i] = $shadow_vertical_hover[$i] . 'px ';
		            	}
		            	if( isset($shadow_blur_hover[$i]) && $shadow_blur_hover[$i] != '' ) {
		            		$shadow_blur_hover[$i] = $shadow_blur_hover[$i] . 'px ';
		            	}
		            	if( isset($shadow_spread_hover[$i]) && $shadow_spread_hover[$i] != '' ) {
		            		$shadow_spread_hover[$i] = $shadow_spread_hover[$i] . 'px ';
		            	}
		            	if( isset($shadow_color_hover[$i]) && $shadow_color_hover[$i] != '' ) {
		            		$shadow_color_hover[$i] = $shadow_color_hover[$i] . ' ';
		            	}
			            if( !is_array( $shadow_horizontal_hover ) ) {
			            	if( isset($shadow_horizontal_hover) && $shadow_horizontal_hover != '' ) {
			            		$shadow_horizontal_hover = $shadow_horizontal_hover . 'px ';
			            	}
			            	if( isset($shadow_vertical_hover) && $shadow_vertical_hover != '' ) {
			            		$shadow_vertical_hover = $shadow_vertical_hover . 'px ';
			            	}
			            	if( isset($shadow_blur_hover) && $shadow_blur_hover != '' ) {
			            		$shadow_blur_hover = $shadow_blur_hover . 'px ';
			            	}
			            	if( isset($shadow_spread_hover) && $shadow_spread_hover != '' ) {
			            		$shadow_spread_hover = $shadow_spread_hover . 'px ';
			            	}
			            	if( isset($shadow_color_hover) && $shadow_color_hover != '' ) {
			            		$shadow_color_hover = $shadow_color_hover . ' ';
			            	}
			                $box_shadow_hover .= $shadow_horizontal_hover . $shadow_vertical_hover . $shadow_blur_hover . $shadow_spread_hover . $shadow_color_hover . $shadow_position_hover;
			            } elseif ( $i == $shadow_count_hover - 1 ){
			            	$shadow_horizontal_hover[ $i ] = isset( $shadow_horizontal_hover[ $i ] ) ? $shadow_horizontal_hover[ $i ] : '';
			            	$shadow_vertical_hover[ $i ] = isset( $shadow_vertical_hover[ $i ] ) ? $shadow_vertical_hover[ $i ] : '';
			            	$shadow_blur_hover[ $i ] = isset( $shadow_blur_hover[ $i ] ) ? $shadow_blur_hover[ $i ] : '';
			            	$shadow_spread_hover[ $i ] = isset( $shadow_spread_hover[ $i ] ) ? $shadow_spread_hover[ $i ] : '';
			            	$shadow_color_hover[ $i ] = isset( $shadow_color_hover[ $i ] ) ? $shadow_color_hover[ $i ] : '';
			            	$shadow_position_hover[ $i ] = isset( $shadow_position_hover[ $i ] ) ? $shadow_position_hover[ $i ] : 'outset';
			                $box_shadow_hover .= $shadow_horizontal_hover[ $i ] . $shadow_vertical_hover[ $i ] . $shadow_blur_hover[ $i ] . $shadow_spread_hover[$i ] . $shadow_color_hover[ $i ] . $shadow_position_hover[ $i ];
			            } else {
			                $box_shadow_hover .= $shadow_horizontal_hover[ $i ] . $shadow_vertical_hover[ $i ] . $shadow_blur_hover[ $i ] . $shadow_spread_hover[ $i ] . $shadow_color_hover[ $i ] . $shadow_position_hover[ $i ] . ',';
			            }
			        }
		        }
		        if( $box_shadow_hover != '' ){
		        	$css .= ( $compact === true ) ? '' : $hover .'{';
		        	$css .= '-webkit-box-shadow:' . $box_shadow_hover . $important . ';box-shadow:' . $box_shadow_hover . $important . ';';
		        	$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
		        }
		        $shadow_css_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_box_shadow_css_hover' ), array() );
		        if( $shadow_css_hover != '' ) {
		        	$css .= ( $compact === true ) ? '' : $hover .'{';
		        	$css .= '-webkit-box-shadow:' . $shadow_css_hover . $important . ';box-shadow:' . $shadow_css_hover . $important . ';';
		        	$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
		        }
	    	}
			return $css;
	    }

	    /**
	     * Function to generate dropdown css styles
	     * @since  1.9.60
	     * @param  string    $normal Normal selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function link_dropdown_css( $id, $normal, $forced, $compact ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	if( $normal != '' ){
	    		$css .= ( $compact === true ) ? '' : $normal .'{';
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_font', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'font-size', 'css_suffix' => 'px' . $important ) );
	    		$dropdown_font_weight = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_font', 'field2' => 'weight' ), array() );
	    		if( preg_match('/[0-9]+[a-z]+/', $dropdown_font_weight) ) {
	    			$css .= 'font-weight:' . preg_replace('/[^0-9]/', '', $dropdown_font_weight ) . ';';
	    		} else {
	    			if($dropdown_font_weight){
	    				$css .= 'font-weight:' . $dropdown_font_weight . ';';
	    			}
	    			$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_font', 'field2' => 'style' ), array( 'css' => true, 'css_prefix' => 'font-style', 'css_suffix' => $important ) );
	    		}
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_font', 'field2' => 'family' ), array( 'css' => true, 'css_prefix' => 'font-family', 'css_suffix' => $important ) );
	    		$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
	    	}
			return $css;
	    }

	    /**
	     * Function to generate dropdown border css styles
	     * @since  1.9.60
	     * @param  string    $normal Normal selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function link_dropdown_border_css( $id, $normal, $forced, $compact ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	$border_size = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'size' ), array() );
	    	$border_normal_top = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'top' ), array() );
	    	$border_normal_bottom = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'bottom' ), array() );
	    	$border_normal_left = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'left' ), array() );
	    	$border_normal_right = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'right' ), array() );
	    	if( $normal != '' ){
	    		$css .= ( $compact === true ) ? '' : $normal . '{';
	    		if( $border_normal_top != '0' ){
					$css .= 'border-top-width:' . $border_size . 'px' . $important . ';';
				}
				if( $border_normal_top == '0' ){
					$css .= 'border-top-width:0' . $important . ';';
				}

				if( $border_normal_bottom != '0' ){
					$css .= 'border-bottom-width:' . $border_size . 'px' . $important . ';';
				}
				if( $border_normal_bottom == '0' ){
					$css .= 'border-bottom-width:0' . $important . ';';
				}

				if( $border_normal_left != '0' ){
					$css .= 'border-left-width:' . $border_size . 'px' . $important . ';';
				}
				if( $border_normal_left == '0' ){
					$css .= 'border-left-width:0' . $important . ';';
				}

				if( $border_normal_right != '0' ){
					$css .= 'border-right-width:' . $border_size . 'px' . $important . ';';
				}
				if( $border_normal_right == '0' ){
					$css .= 'border-right-width:0' . $important . ';';
				}
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'style' ), array( 'css' => true, 'css_prefix' => 'border-style', 'css_suffix' => $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'color' ), array( 'css' => true, 'css_prefix' => 'border-color', 'css_suffix' => $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal_radius', 'field2' => 'top_left' ), array( 'css' => true, 'css_prefix' => 'border-top-left-radius', 'css_suffix' => 'px' . $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal_radius', 'field2' => 'top_right' ), array( 'css' => true, 'css_prefix' => 'border-top-right-radius', 'css_suffix' => 'px' . $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal_radius', 'field2' => 'bottom_left' ), array( 'css' => true, 'css_prefix' => 'border-bottom-left-radius', 'css_suffix' => 'px' . $important ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal_radius', 'field2' => 'bottom_right' ), array( 'css' => true, 'css_prefix' => 'border-bottom-right-radius', 'css_suffix' => 'px' . $important ) );
				$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
	    	}
			return $css;
	    }

	    /**
	     * Function to generate dropdown border css styles
	     * @since  1.9.60
	     * @param  string    $normal Normal selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function link_dropdown_border_before_css( $id, $normal, $forced, $compact ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	$border_normal_top = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'top' ), array() );
	    	if( $normal != '' ){
	    		$css .= ( $compact === true ) ? '' : $normal . '{';
	    		if( $border_normal_top != '0' ){
					$css .= 'border-width:' . ( 7 + (float) $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'size', 'value' => 1 ) ) ) . 'px' . $important . ';';
					$css .= 'margin-left:' . ( - 7 - (float) $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'size', 'value' => 1 ) ) ) . 'px' . $important . ';';
				}
				if( $border_normal_top == '0' ){
					$css .= 'border-width:7px' . $important . ';';
					$css .= 'margin-left:-7px' . $important . ';';
				}
				$css .= 'border-bottom-color:' . $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'color' ) ) . $important;
				$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
	    	}
			return $css;
	    }

	    /**
	     * Function to generate dropdown border css styles
	     * @since  1.9.60
	     * @param  string    $normal Normal selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function link_dropdown_border_after_css( $id, $normal, $forced, $compact ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	$border_normal_top = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'top' ), array() );
	    	if( $normal != '' ){
	    		$css .= ( $compact === true ) ? '' : $normal . '{';
	    		if( $border_normal_top != '0' && (float) $border_normal_top >= 1 ){
					$css .= 'border-width:6px' . $important . ';';
					$css .= 'margin-left:-6px' . $important . ';';
				}
				if( $border_normal_top == '0' ){
					$css .= 'border-width:8px' . $important . ';';
					$css .= 'margin-left:-8px' . $important . ';';
				}
				// $css .= 'border-bottom-color:' . $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_border_normal', 'field2' => 'color' ) ) . $important;
				$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
	    	}
			return $css;
	    }

	    /**
	     * Function to generate dropdown border css styles
	     * @since  1.9.60
	     * @param  string    $normal Normal selector
	     * @param  boolean    $forced Force !important
	     * @param  boolean    $compact Don't use selectors
	     * @return string
	     */
	    public function link_dropdown_shadow_css( $id, $normal, $forced, $compact ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	$shadow_hide = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_link_dropdown_shadow_hide' ) );
	    	if( $normal != '' ){
	    		$css .= ( $compact === true ) ? '' : $normal . '{';
	    		if( $shadow_hide == '1' ){
					$css .= 'box-shadow:none'. $important .';-webkit-box-shadow:none'. $important .';';
				}
				$css .= ( $compact === true ) ? '' : '}' . PHP_EOL;
	    	}
			return $css;
	    }

	    /**
	     * Function to generate override css
	     * @since  1.3
	     * @param  int    $id
	     * @return string
	     */
	    public function generate_override_css( $id, $override_normal = '', $override_hover = '', $css_type = 'inline' ) {
    		$css = '';

    		if( $css_type == 'external' ){
    			$override_style_type = maybe_unserialize( $this->meta_values( $id, array( 'field' => 'btnsx_override_style_type' ) ) );
				if( $override_style_type != '' && is_array( $override_style_type ) ){
					foreach ( $override_style_type as $override_type ) {
						if( $override_type === 'woocommerce_button' ) {
							$override_normal = $this->overrides['woocommerce']['normal'];
							$override_hover = $this->overrides['woocommerce']['hover'];
						}
						if( $override_type === 'woocommerce_button_alt' ) {
							$override_normal .= ( $override_normal != '' ) ? ',' . $this->overrides['woocommerce_alt']['normal'] : $this->overrides['woocommerce_alt']['normal'];
							$override_hover .= ( $override_hover != '' ) ? ',' . $this->overrides['woocommerce_alt']['hover'] : $this->overrides['woocommerce_alt']['hover'];
						}
						if( $override_type === 'contact_form_7' ) {
							$override_normal .= ( $override_normal != '' ) ? ',' . $this->overrides['contact_form_7']['normal'] : $this->overrides['contact_form_7']['normal'];
							$override_hover .= ( $override_hover != '' ) ? ',' . $this->overrides['contact_form_7']['hover'] : $this->overrides['contact_form_7']['hover'];
						}
						if( $override_type === 'caldera_form' ) {
							$override_normal .= ( $override_normal != '' ) ? ',' . $this->overrides['caldera_form']['normal'] : $this->overrides['caldera_form']['normal'];
							$override_hover .= ( $override_hover != '' ) ? ',' . $this->overrides['caldera_form']['hover'] : $this->overrides['caldera_form']['hover'];
						}
						if( $override_type === 'ninja_form' ) {
							$override_normal .= ( $override_normal != '' ) ? ',' . $this->overrides['ninja_form']['normal'] : $this->overrides['ninja_form']['normal'];
							$override_hover .= ( $override_hover != '' ) ? ',' . $this->overrides['ninja_form']['hover'] : $this->overrides['ninja_form']['hover'];
						}
						if( $override_type === 'jetpack_subscribe_widget' ) {
							$override_normal .= ( $override_normal != '' ) ? ',' . $this->overrides['jetpack_subscribe_widget']['normal'] : $this->overrides['jetpack_subscribe_widget']['normal'];
							$override_hover .= ( $override_hover != '' ) ? ',' . $this->overrides['jetpack_subscribe_widget']['hover'] : $this->overrides['jetpack_subscribe_widget']['hover'];
						}
						if( $override_type === 'formidable_form' ) {
							$override_normal .= ( $override_normal != '' ) ? ',' . $this->overrides['formidable_form']['normal'] : $this->overrides['formidable_form']['normal'];
							$override_hover .= ( $override_hover != '' ) ? ',' . $this->overrides['formidable_form']['hover'] : $this->overrides['formidable_form']['hover'];
						}
					}
				}
    		}

			// Custom classes
			$override_style_custom_class = $this->meta_values( $id, array( 'field' => 'btnsx_override_style_custom_class' ) );

			if( $override_style_custom_class != '' ){
				$override_normal .= $override_normal != '' ? ',' . $override_style_custom_class : $override_style_custom_class;
				// Apply hover styles for custom classes
				if( $override_hover != '' ){
					$override_hover .= ',';
				}
				$override_hover_array = array_filter( explode( ',', $override_style_custom_class ) );

				$oha_count = count( $override_hover_array );
				$oha_i = 1;

				foreach ( $override_hover_array as $hover_class ) {
					if( $hover_class != '' ){
						if( $oha_i == $oha_count ){
							$override_hover .= $hover_class . ':hover';
						} else {
							$override_hover .= $hover_class . ':hover,';
						}
					}
					$oha_i++;
				}
			}
			// Generate CSS
			if( $override_normal != '' ) {
				$css .= $override_normal . '{';
		    		$css .= $this->primary_text_css( $id, $override_normal, true, true );
		    		$css .= $this->gradient_css( $id, $override_normal, true, true );
		    		$css .= $this->border_css( $id, $override_normal, true, true );
		    		$css .= $this->box_shadow_css( $id, $override_normal, true, true );
		    		$css .= $this->background_css( $id, $override_normal, false, true, true );
		    		$css .= $this->general_css( $id, $override_normal, true, true );
		    	$css .= '}' . PHP_EOL;
		    	$css .= $this->responsive_tablet_css( $id, true, $override_normal );
				$css .= $this->responsive_mobile_css( $id, true, $override_normal );
		    }
			if( $override_hover != '' ) {
				$css .= $override_hover . '{';
					$css .= $this->primary_text_hover_css( $id, $override_hover, true, true );
		    		$css .= $this->gradient_hover_css( $id, $override_hover, true, true );
		    		$css .= $this->border_hover_css( $id, $override_hover, true, true );
		    		$css .= $this->box_shadow_hover_css( $id, $override_hover, true, true );
		    		$css .= $this->background_hover_css( $id, $override_hover, true, true );
				$css .= '}' . PHP_EOL;
			}

			return $css;
	    }

	    /**
	     * Function to generate responsive tablet css styles
	     * @since  1.9.0
	     * @param  string    $normal Normal selector
	     * @param  boolean   $forced Force !important
	     * @param  string    $override_id custom selector
	     * @return string
	     */
	    public function responsive_tablet_css( $id, $forced, $override_id ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	$selector = '';
	    	if( $id != '' ){
	    		$selector = '#btnsx-' . $id;
	    	}
	    	if( $override_id != '' ){
	    		$selector = $override_id;
	    	}
	    	$settings = get_option( 'btnsx_settings' );
	    	$width = isset( $btnsx_settings['responsive_tablet_width'] ) && $btnsx_settings['responsive_tablet_width'] != '0' ? $btnsx_settings['responsive_tablet_width'] : '768';
	    	$hide = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_hide_button_tablet' ), array() );
	    	$css .= '@media screen and (max-width: '.$width.'px) {' . PHP_EOL;
	    		$css .= $selector . ' {';
	    		if( $hide == '1' ){
	    			$css .= 'display:none' . $important .';';
	    		}else{
	    			$css .= 'display:inline-block' . $important .';';
	    		}
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_width' ), array( 'css' => true, 'css_prefix' => 'width', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_height' ), array( 'css' => true, 'css_prefix' => 'height', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_padding', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'padding-top', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_padding', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'padding-bottom', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_padding', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'padding-left', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_padding', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'padding-right', 'css_suffix' => 'px' . $important ) );
	    		$css .= '}' . PHP_EOL;

	    	if( $override_id == '' ){
	    		$css .= $selector . ' .btnsx-text-primary {';
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_text_font', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'font-size', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_text_padding', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'padding-top', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_text_padding', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'padding-bottom', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_text_padding', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'padding-left', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_text_padding', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'padding-right', 'css_suffix' => 'px' . $important ) );
	    		$css .= '}' . PHP_EOL;

	    		$css .= $selector . ' .btnsx-text-secondary {';
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_text_secondary_font', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'font-size', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_text_secondary_padding', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'padding-top', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_text_secondary_padding', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'padding-bottom', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_text_secondary_padding', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'padding-left', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_text_secondary_padding', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'padding-right', 'css_suffix' => 'px' . $important ) );
	    		$css .= '}' . PHP_EOL;

	    		$css .= $selector . ' .btnsx-icon {';
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_icon_font', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'font-size', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_icon_padding', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'padding-top', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_icon_padding', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'padding-bottom', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_icon_padding', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'padding-left', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_icon_padding', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'padding-right', 'css_suffix' => 'px' . $important ) );
	    		$css .= '}' . PHP_EOL;

	    		$css .= $selector . ' .btnsx-divider {';
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_icon_divider', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'border-left-width', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_tablet_icon_divider', 'field2' => 'position' ), array( 'css' => true, 'css_prefix' => 'left', 'css_suffix' => 'px' . $important ) );
	    		$css .= '}' . PHP_EOL;

	    	}

	    	$css .= '}';
			return $css;
	    }

	    /**
	     * Function to generate responsive mobile css styles
	     * @since  1.9.0
	     * @param  string    $normal Normal selector
	     * @param  boolean    $forced Force !important
	     * @param  string    $override_id custom selector
	     * @return string
	     */
	    public function responsive_mobile_css( $id, $forced, $override_id ) {
	    	$css = '';$important = '';
	    	if( $forced === true ){
	    		$important = '!important';
	    	}
	    	$selector = '';
	    	if( $id != '' ){
	    		$selector = '#btnsx-' . $id;
	    	}
	    	if( $override_id != '' ){
	    		$selector = $override_id;
	    	}
	    	$width = isset( $btnsx_settings['responsive_mobile_width'] ) && $btnsx_settings['responsive_mobile_width'] != '0' ? $btnsx_settings['responsive_mobile_width'] : '480';
	    	$hide = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_hide_button_mobile' ), array() );
	    	$css .= '@media screen and (max-width: '.$width.'px) {' . PHP_EOL;
	    		$css .= $selector . ' {';
	    		if( $hide == '1' ){
	    			$css .= 'display:none' . $important .';';
	    		} else {
	    			$css .= 'display:inline-block' . $important .';';
	    		}
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_width' ), array( 'css' => true, 'css_prefix' => 'width', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_height' ), array( 'css' => true, 'css_prefix' => 'height', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_padding', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'padding-top', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_padding', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'padding-bottom', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_padding', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'padding-left', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_padding', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'padding-right', 'css_suffix' => 'px' . $important ) );
	    		$css .= '}' . PHP_EOL;

	    	if( $override_id == '' ){

	    		$css .= $selector . ' .btnsx-text-primary {';
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_text_font', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'font-size', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_text_padding', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'padding-top', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_text_padding', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'padding-bottom', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_text_padding', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'padding-left', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_text_padding', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'padding-right', 'css_suffix' => 'px' . $important ) );
	    		$css .= '}' . PHP_EOL;

	    		$css .= $selector . ' .btnsx-text-secondary {';
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_text_secondary_font', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'font-size', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_text_secondary_padding', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'padding-top', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_text_secondary_padding', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'padding-bottom', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_text_secondary_padding', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'padding-left', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_text_secondary_padding', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'padding-right', 'css_suffix' => 'px' . $important ) );
	    		$css .= '}' . PHP_EOL;

	    		$css .= $selector . ' .btnsx-icon {';
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_icon_font', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'font-size', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_icon_padding', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'padding-top', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_icon_padding', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'padding-bottom', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_icon_padding', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'padding-left', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_icon_padding', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'padding-right', 'css_suffix' => 'px' . $important ) );
	    		$css .= '}' . PHP_EOL;

	    		$css .= $selector . ' .btnsx-divider {';
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_icon_divider', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'border-left-width', 'css_suffix' => 'px' . $important ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_mobile_icon_divider', 'field2' => 'position' ), array( 'css' => true, 'css_prefix' => 'left', 'css_suffix' => 'px' . $important ) );
	    		$css .= '}' . PHP_EOL;

	    	}

	    	$css .= '}';
			return $css;
	    }

	    /**
	     * Function to generate css
	     * @since  0.1
	     * @param  int    	$id
	     * @param  boolean  $override
	     * @return string
	     */
	    public function generate_css( $id, $override ) {
	    	// Start
	    		$css = '/*' . $id . '-start*/' . PHP_EOL;

	    	// General
	    		$css .= $this->general_css( $id, '#btnsx-' . $id, false, false );

	    	// Primary Text
	    		$css .= $this->primary_text_css( $id, '#btnsx-' . $id . ' .btnsx-text-primary', false, false );
	    		$css .= $this->primary_text_hover_css( $id, '#btnsx-' . $id . ':hover .btnsx-text-primary', false, false );

			// Secondary Text
				$css .= '#btnsx-' . $id . ' .btnsx-text-secondary{';
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_transform' ), array( 'css' => true, 'css_prefix' => 'text-transform' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_alignment' ), array( 'css' => true, 'css_prefix' => 'text-align' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_position' ), array( 'css' => true, 'css_prefix' => 'display' ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_font', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'font-size', 'css_suffix' => 'px' ) );
	    		$line_height = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_vertical_space' ), array() );
	    		if( $line_height ){
	    			$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_vertical_space' ), array( 'css' => true, 'css_prefix' => 'line-height', 'css_suffix' => 'px' ) );
	    		} else {
	    			$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_font', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'line-height', 'css_suffix' => 'px' ) );
	    		}

	    		$text_secondary_font_weight = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_font', 'field2' => 'weight' ), array() );
	    		
	    		if( preg_match('/[0-9]+[a-z]+/', $text_secondary_font_weight) ) {
	    			if($text_secondary_font_weight){
	    				$css .= 'font-weight:' . preg_replace('/[^0-9]/', '', $text_secondary_font_weight ) . ';';
	    			}
	    			$css .= 'font-style:italic;';
	    		} else {
	    			if($text_secondary_font_weight){
	    				$css .= 'font-weight:' . $text_secondary_font_weight . ';';
	    			}
	    			$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_font', 'field2' => 'style' ), array( 'css' => true, 'css_prefix' => 'font-style' ) );
	    		}

	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_font', 'field2' => 'family' ), array( 'css' => true, 'css_prefix' => 'font-family' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_color', 'field2' => 'normal' ), array( 'css' => true, 'css_prefix' => 'color' ) );

				$text_secondary_shadow_horizontal = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_shadow', 'field2' => 'horizontal' ), array() );
				$text_secondary_shadow_vertical = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_shadow', 'field2' => 'vertical' ), array() );
				$text_secondary_shadow_blur = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_shadow', 'field2' => 'blur' ), array() );
				$text_secondary_shadow_color = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_shadow', 'field2' => 'color' ), array() );
				if( !empty($text_secondary_shadow_horizontal) || !empty($text_secondary_shadow_vertical) ) {
					$css .= 'text-shadow:' . $text_secondary_shadow_horizontal . 'px ' . $text_secondary_shadow_vertical . 'px ' . $text_secondary_shadow_blur . 'px ' . $text_secondary_shadow_color . ';';
				}

				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_padding', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'padding-top', 'css_suffix' => 'px' ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_padding', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'padding-bottom', 'css_suffix' => 'px' ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_padding', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'padding-left', 'css_suffix' => 'px' ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_padding', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'padding-right', 'css_suffix' => 'px' ) );
	    		$css .= '}' . PHP_EOL;

	    		// Hover
				$text_secondary_color_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_text_secondary_color', 'field2' => 'hover' ), array() );
				if( $text_secondary_color_hover != '' ){
					$css .= '#btnsx-' . $id . ':hover .btnsx-text-secondary{color:' . $text_secondary_color_hover . ';}' . PHP_EOL;
				}

			// Icon
				$css .= '#btnsx-' . $id . ' .btnsx-icon{';
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_size' ), array( 'css' => true, 'css_prefix' => 'font-size', 'css_suffix' => 'px' ) );
				$icon_alignment = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_alignment' ) );
				if( $icon_alignment == 'extreme_left' ) {
					$css .= 'float:left;';
				}
				if( $icon_alignment == 'extreme_right' ) {
					$css .= 'float:right;';
				}
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_vertical_position' ), array( 'css' => true, 'css_prefix' => 'line-height', 'css_suffix' => 'px'  ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_color', 'field2' => 'normal' ), array( 'css' => true, 'css_prefix' => 'color' ) );
				// icon_background ??
				$icon_shadow_horizontal = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_shadow', 'field2' => 'horizontal' ), array() );
				$icon_shadow_vertical = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_shadow', 'field2' => 'vertical' ), array() );
				$icon_shadow_blur = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_shadow', 'field2' => 'blur' ), array() );
				$icon_shadow_color = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_shadow', 'field2' => 'color' ), array() );
				if( $icon_shadow_horizontal != '' && $icon_shadow_vertical != '' && $icon_shadow_blur != '' ) {
					$css .= 'text-shadow:' . $icon_shadow_horizontal . 'px ' . $icon_shadow_vertical . 'px ' . $icon_shadow_blur . 'px ' . $icon_shadow_color . ';';
				}

				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_padding', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'padding-top', 'css_suffix' => 'px' ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_padding', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'padding-bottom', 'css_suffix' => 'px' ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_padding', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'padding-left', 'css_suffix' => 'px' ) );
	    		$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_padding', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'padding-right', 'css_suffix' => 'px' ) );
	    		$css .= '}' . PHP_EOL;

	    		$icon_divider_position = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_divider', 'field2' => 'position' ), array() );
				$icon_divider_size = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_divider', 'field2' => 'size' ), array() );
				$icon_divider_color = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_divider', 'field2' => 'color' ), array() );
				if( $icon_divider_size != '' ) {
					$css .= '#btnsx-' . $id . ' .btnsx-divider{border-left:' . $icon_divider_size . 'px solid ' . $icon_divider_color . ';left:' . $icon_divider_position . 'px;}' . PHP_EOL;
				}

				$icon_color_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_color', 'field2' => 'hover' ), array() );
				if( $icon_color_hover != '' ){
					$css .= '#btnsx-' . $id . ':hover .btnsx-icon{color:' . $icon_color_hover . ';}' . PHP_EOL;
				}
				// icon background ??
				// icon image hover
				// $icon_image_hover = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_image_hover' ), array() );
				// if( $icon_image_hover != '' ){
				// 	$css .= '#btnsx-' . $id . ':hover .btnsx-icon{background-image: url(' . $icon_image_hover . ');}' . PHP_EOL;
				// }

				// Image Position
				$css .= '#btnsx-' . $id . ' .btnsx-icon-img{';
				$icon_image_position = $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_image_position_enable' ), array() );
				if( $icon_image_position == '1' ) {
					$css .= 'position:absolute;' . PHP_EOL;
				}
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_image_position', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'top', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_image_position', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'bottom', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_image_position', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'left', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_icon_image_position', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'right', 'css_suffix' => 'px' ) );
				$css .= '}' . PHP_EOL;

			// Background
				$css .= $this->background_css( $id, '#btnsx-' . $id, true, true, false );
				$css .= $this->background_hover_css( $id, '#btnsx-' . $id . ':hover', true, false );

			// Gradient
				$css .= $this->gradient_css( $id, '#btnsx-' . $id, false, false );
				$css .= $this->gradient_hover_css( $id, '#btnsx-' . $id . ':hover', false, false );

			// Border
				$css .= $this->border_css( $id, '#btnsx-' . $id, false, false );
				$css .= $this->border_hover_css( $id, '#btnsx-' . $id . ':hover', false, false );

			// Box Shadow
				$css .= $this->box_shadow_css( $id, '#btnsx-' . $id, false, false );
				$css .= $this->box_shadow_hover_css( $id, '#btnsx-' . $id . ':hover', false, false );

			// Dropdown CSS
				$css .= $this->link_dropdown_css( $id, '#btnsx-' . $id . '-dropdown .menu-item a', false, false );

			// Dropdown Border CSS
				$css .= $this->link_dropdown_border_css( $id, '#btnsx-' . $id . '-dropdown', false, false );

			// Dropdown Border Before CSS
				$css .= $this->link_dropdown_border_before_css( $id, '#btnsx-' . $id . '-dropdown:before', false, false );

			// Dropdown Border After CSS
				$css .= $this->link_dropdown_border_after_css( $id, '#btnsx-' . $id . '-dropdown:after', false, false );

			// Dropdown Shadow CSS
				$css .= $this->link_dropdown_shadow_css( $id, '#btnsx-' . $id . '-dropdown', false, false );

			// Responsive Tablet
				$css .= $this->responsive_tablet_css( $id, false, '' );

			// Responsive Mobile
				$css .= $this->responsive_mobile_css( $id, false, '' );

			// Override CSS
				if( $override === true ){
					$css .= $this->generate_override_css( $id, '', '', 'external' );
				}

		    // Filter - CSS
				$btn_css_filter = apply_filters( 'btnsx_css_filter', array(), $id );
				$btn_css_filter_as_string = '';
				foreach ( $btn_css_filter as $key => $value ) {
					$btn_css_filter_as_string .= implode( ' ', $value );
				}

	    	// End
	    		$css .= '/*' . $id . '-end*/' . PHP_EOL;

	    	return $css;
	    }

	    /**
		 * generate CSS when saving or updating a button
		 * @since  1.0.0
		 * @param  number    $post_id   current post ID
		 * @return string
		 */
		public function print_css( $post_id ) {
			// if function exists get_filesystem_method define access type
		    if( function_exists( 'get_filesystem_method' ) ) {
		        $access_type = get_filesystem_method();
		    } else {
		        $access_type = '';
		    }
		    // if access type is direct then only proceed else generate notice
		    if( $access_type === 'direct' ) {
		    	// custom post type slug
		        $slug = 'buttons-x';

		        // If this isn't a 'buttons-x' post, don't update it.
		        if ( $slug != get_post_type( $post_id ) ) {
		            return;
		        }

		        // check for filesystem credentials, if false return
		        $creds = request_filesystem_credentials( site_url() . '/wp-admin/', '', false, false, null );
		        if ( !WP_Filesystem( $creds ) ) {
		            return;
		        }

		        // if ( get_metadata('post', $post_id ) == false) {
		        //     return;
		        // }
		        global $wp_filesystem;

		        // dynamic file
		        if( is_multisite() ) {
		        	if( is_main_site() ) {
		        		$file = trailingslashit( $wp_filesystem->wp_content_dir() ) . 'uploads/btnsx/dynamic.css';
		        	} else {
		        		$blog_id = get_current_blog_id();
		        		$file = trailingslashit( $wp_filesystem->wp_content_dir() ) . 'uploads/sites/' . $blog_id . '/btnsx/dynamic.css';
		        	}
		        } else {
		        	$file = trailingslashit( $wp_filesystem->wp_content_dir() ) . 'uploads/btnsx/dynamic.css';
		        }
		        // store current file content
		        $file_content = $wp_filesystem->get_contents( $file );

		        $start = "/*" . $post_id . "-start*/";
            	$end   = "/*" . $post_id . "-end*/";
            	// remove existing css for the button
	    		$existing_css   = preg_replace( '#(' . preg_quote( $start ) . ')(.*)(' . preg_quote( $end ) . ')#si', '', $wp_filesystem->get_contents( $file, FS_CHMOD_FILE ) );
	    		$wp_filesystem->put_contents( $file, $existing_css, FS_CHMOD_FILE );
	    		// remove unwanted new lines
            	$empty_lines = preg_replace( '/^[\r\n]+|[\r\n]+$/m', '', $wp_filesystem->get_contents( $file, FS_CHMOD_FILE ) );
            	$wp_filesystem->put_contents( $file, $empty_lines, FS_CHMOD_FILE );
		        // fetch data and store css
		        $generated_css = $this->generate_css( $post_id, true );
		        // combine css
	            $css = $wp_filesystem->get_contents( $file, FS_CHMOD_FILE ) . $generated_css;
	            // write combined css to file
	            $wp_filesystem->put_contents( $file, $css, FS_CHMOD_FILE );
	            // remove empty declarations
	            $empty_declarations = preg_replace( '/^.*{}.*+$/m', '', $wp_filesystem->get_contents( $file, FS_CHMOD_FILE ) );
	            $wp_filesystem->put_contents( $file, $empty_declarations, FS_CHMOD_FILE );
	            // remove unwanted new lines
	            $empty_lines = preg_replace( '/^[\r\n]+|[\r\n]+$/m', '', $wp_filesystem->get_contents( $file, FS_CHMOD_FILE ) );
	            $wp_filesystem->put_contents( $file, $empty_lines, FS_CHMOD_FILE );

	            // Flush WP cache
	            if ( function_exists( 'wp_cache_flush' ) ) {
	            	wp_cache_flush();
	            }

	            // Flush W3TC cache
	            if ( function_exists( 'w3tc_pgcache_flush' ) ) {
					w3tc_pgcache_flush();
				}

				// Flush WPSC cache
	            if ( function_exists( 'wp_cache_clear_cache' ) ) {
					wp_cache_clear_cache();
				}

		    } else {
		    	// if file not accessible generate a notice
		        add_action( 'admin_notice', array( $this, 'error_notice_css' ) );
		    }
		}

		/**
		 * Notice when unable to save css
		 * @since  0.1
		 * @return string
		 */
		public function error_notice_css() {
		    ?>
		    <div class="error">
		        <p><?php _e( 'Buttons X needs permission to write custom styles in css file. Please change directory permission at ( wp-content/uploads/btnsx OR wp-content/uploads/sites/{site_id}/btnsx  ) to 644 or higher.', 'btnsx' ); ?></p>
		    </div>
		    <?php
		}

		/**
		 * Function to remove css when button is deleted
		 * @since  0.1
		 * @param  int   $post_id
		 * @return string
		 */
		public function remove_css( $post_id ) {
			// var_dump('works');
		    $access_type = get_filesystem_method();
		    if( $access_type === 'direct' )
		    {
		        $slug = 'buttons-x';

		        // If this isn't a 'buttons-x' post, don't update it.
		        if ( $slug != get_post_type( $post_id ) ) {
		            return;
		        }

		        $creds = request_filesystem_credentials( site_url() . '/wp-admin/', '', false, false, array() );

		        if ( !WP_Filesystem( $creds ) ) {
		            return false;
		        }

		        global $wp_filesystem;
		        $file = trailingslashit( $wp_filesystem->wp_content_dir() ) . 'uploads/btnsx/dynamic.css';
		        $file_content = $wp_filesystem->get_contents( $file, FS_CHMOD_FILE );

		        $button_id = $post_id;
		        if ( strpos( $file_content, (string) $button_id ) === FALSE) {
		        	// var_dump( false );
		            // do nothing
		        } else {
		            // var_dump( true );
		            $start = "/*" . $button_id . "-start*/";
		            $end = "/*" . $button_id . "-end*/";
		            $css = preg_replace( '#(' . preg_quote( $start ) . ')(.*)(' . preg_quote( $end ) . ')#si', '', $wp_filesystem->get_contents( $file, FS_CHMOD_FILE ) );
		            $wp_filesystem->put_contents( $file, $css, FS_CHMOD_FILE ) ;
		            $empty_lines = preg_replace( '/^[\r\n]+|[\r\n]+$/m', '', $wp_filesystem->get_contents( $file, FS_CHMOD_FILE ) );
		            $wp_filesystem->put_contents( $file, $empty_lines, FS_CHMOD_FILE );
		        }
		    }
		    else{
		        add_action( 'admin_notice', array( $this, 'error_notice_remove_css' ) );
		    }
		}

		/**
		 * Function to display error in case
		 * @since  0.1
		 * @return string
		 */
		public function error_notice_remove_css() {
		    ?>
		    <div class="error">
		        <p><b><?php _e( 'Buttons X CSS Remove Error : ', 'btnsx' ); ?></b><?php _e( 'Seems like you do not have file write access. Please contact your host to get write access to "/wp-content/uploads/btnsx" directory and files inside it OR "/wp-content/uploads/sites/{site_id}/btnsx".', 'btnsx' ); ?></p>
		    </div>
		    <?php
		}

		/**
		 * Add to cart attribute for WooCommerce button
		 */
		public function add_to_cart_attr( array $data, $options, $atts ) {
			$data[] = array(
				'data-addtocart="true"'
			);
			return $data;
		}

	    /**
	     * Button short code
	     * @param $atts
	     * @since 0.1
	     */
	    public function shortcode( $atts, $content = '' ) {

	    	$default = array(

				// General

					// main
					'id'								=>	'',
					'width'								=>	'',
					'height'							=>	'',
					'size'								=>	'',
					'disabled'							=>	'',
					'embossed'							=>	'',
					'full_width'						=>	'',
					'container'							=>	'',
					'wrap_center'						=>	'',

					// link
					'link_type'							=>	'',
					'link_target'						=>	'',
					'link_relationship'					=>	'',
					'link_post'							=>	'',
					'link_menu_type'					=>	'',
					'link_menu'							=>	'',
					'link_menu_custom'					=>	'',
					'link_menu_display'					=>	'',
					'link'								=>	'',
					'link_unescaped'					=>	'',
					'link_edd_id'						=>	'',
					'link_woocommerce_id'				=>	'',
					'link_redirect_url'					=>	'',
					'link_frame_width'					=>	'',
					'link_frame_height'					=>	'',
					'link_email'						=>	'',
					'link_email_subject'				=>	'',
					'link_skype_id'						=>	'',
					'link_telephone'					=>	'',
					'link_sms_content'					=>	'',
					'link_wistia_video_id'				=>	'',

					// margin
					'margin_top'						=>	'',
					'margin_bottom'						=>	'',
					'margin_left'						=>	'',
					'margin_right'						=>	'',

					// padding
					'padding_top'						=>	'',
					'padding_right'						=>	'',
					'padding_bottom'					=>	'',
					'padding_left'						=>	'',

					//custom css
					'class'								=>	'',
					'css'								=>	'',

				// Primary Text

					// text
					'text'								=>	'',
					'text_transform'					=>	'',
					'text_align'						=>	'',
					'text_vertical_space'				=>	'',

					// font
					'text_font_size'					=>	'',
					'text_font_style'					=>	'',
					'text_font_weight'					=>	'',
					'text_font_family'					=>	'',

					// color
					'text_color'						=>	'',
					'text_color_hover'					=>	'',

					// shadow
					'text_shadow_horizontal'			=>	'',
					'text_shadow_vertical'				=>	'',
					'text_shadow_blur'					=>	'',
					'text_shadow_color'					=>	'',

					// padding
					'text_padding_top'					=>	'',
					'text_padding_right'				=>	'',
					'text_padding_bottom'				=>	'',
					'text_padding_left'					=>	'',

				// Secondary Text

					// text
					'text_secondary'							=>	'',
					'text_secondary_transform'					=>	'',
					'text_secondary_align'						=>	'',
					'text_secondary_display'					=>	'',
					'text_secondary_vertical_space'				=>	'',

					// font
					'text_secondary_font_size'					=>	'',
					'text_secondary_font_style'					=>	'',
					'text_secondary_font_weight'				=>	'',
					'text_secondary_font_family'				=>	'',

					// color
					'text_secondary_color'						=>	'',
					'text_secondary_color_hover'				=>	'',

					// shadow
					'text_secondary_shadow_horizontal'			=>	'',
					'text_secondary_shadow_vertical'			=>	'',
					'text_secondary_shadow_blur'				=>	'',
					'text_secondary_shadow_color'				=>	'',

					// padding
					'text_secondary_padding_top'				=>	'',
					'text_secondary_padding_bottom'				=>	'',
					'text_secondary_padding_left'				=>	'',
					'text_secondary_padding_right'				=>	'',

				// Icon

					// main
					'icon'								=>	'',
					'icon_size'							=>	'',
					'icon_alignment'					=>	'',
					'icon_vertical_position'			=>	'',

					// color
					'icon_color'						=>	'',
					'icon_color_hover'					=>	'',
					// 'icon_background'					=>	'',
					// 'icon_background_hover'				=>	'',

					// image
					'icon_image'						=>	'',
					'icon_image_hover'						=>	'',
					'icon_image_position'				=>	'',
					'icon_image_position_top'			=>	'',
					'icon_image_position_bottom'		=>	'',
					'icon_image_position_left'			=>	'',
					'icon_image_position_right'			=>	'',

					// shadow
					'icon_shadow_horizontal'			=>	'',
					'icon_shadow_vertical'				=>	'',
					'icon_shadow_blur'					=>	'',
					'icon_shadow_color'					=>	'',

					// divider
					'icon_divider_position'				=>	'',
					'icon_divider_size'					=>	'',
					'icon_divider_color'				=>	'',

					// animation
					'icon_animation'					=> '',
					'icon_animation_type'				=> '',

					// padding
					'icon_padding_top'					=>	'',
					'icon_padding_bottom'				=>	'',
					'icon_padding_left'					=>	'',
					'icon_padding_right'				=>	'',

				// Background

					// color
					'background_color_normal'			=>	'',
					'background_color_hover'			=>	'',

					// image
					'background_image_normal'			=>	'',
					'background_image_hover'			=>	'',

				// Gradient

					// type
					'gradient_type_normal'				=>	'',
					'gradient_type_hover'				=>	'',

					// Stop (normal)
					'gradient_stop_color_normal'		=>	'',
					'gradient_stop_location_normal'		=>	'',

					// Stop (normal)
					'gradient_stop_color_hover'			=>	'',
					'gradient_stop_location_hover'		=>	'',

					// custom
					'gradient_css_normal'				=>	'',
					'gradient_css_hover'				=>	'',

				// Border

					// main
					'border_size_normal'				=>	'',
					'border_style_normal'				=>	'',
					'border_color_normal'				=>	'',
					'border_size_hover'					=>	'',
					'border_style_hover'				=>	'',
					'border_color_hover'				=>	'',

					// radius
					'border_top_left_radius_normal'		=>	'',
					'border_top_right_radius_normal'	=>	'',
					'border_bottom_left_radius_normal'	=>	'',
					'border_bottom_right_radius_normal'	=>	'',
					'border_top_left_radius_hover'		=>	'',
					'border_top_right_radius_hover'		=>	'',
					'border_bottom_left_radius_hover'	=>	'',
					'border_bottom_right_radius_hover'	=>	'',

				// Box Shadow

					// Normal
					'shadow_horizontal'					=>	'',
					'shadow_vertical'					=>	'',
					'shadow_blur'						=>	'',
					'shadow_spread'						=>	'',
					'shadow_position'					=>	'',
					'shadow_color'						=>	'',

					// Hover
					'shadow_horizontal_hover'			=>	'',
					'shadow_vertical_hover'				=>	'',
					'shadow_blur_hover'					=>	'',
					'shadow_spread_hover'				=>	'',
					'shadow_position_hover'				=>	'',
					'shadow_color_hover'				=>	'',

					// custom
					'shadow_css'						=>	'',
					'shadow_css_hover'					=>	'',

				// Dropdown
					'dropdown_font_family'				=>	'',
					'dropdown_font_weight'				=>	'',

				// Animation
					'animation_reveal'					=>	'',
					'animation_hover'					=>	'',

				// Miscellaneous

					'container'							=>	'',
					'wrap_center'						=>	'',

				// JS
					'js'								=>	'',

				// Additional

					// 'link_override'					=>  '',
					'css_inline'						=> '',
					'on_click_content'					=> ''

			);

			// Filter Short Code Attributes
			$filter = apply_filters( 'btnsx_shortcode_attributes', array(), $default );
			$filtered = array();
			// combine multiple arrays into one
			foreach ($filter as $key => $value) {
				foreach ($value as $k => $v) {
					$filtered[$k] = $v;
				}
			}
			$options = wp_parse_args( $filtered, $default );

	    	extract( shortcode_atts( $options, $atts ) );

	    	// Display button on spacific post/page
	    	global $post;
	    	$display_button = $this->meta_values( $id, array( 'field' => 'btnsx_display_button' ) );
	    	if( is_array( $display_button ) ) {
		    	$display_button = array_filter($display_button);
				if( !empty( $display_button ) && !in_array( $post->ID, $display_button ) ) {
					return;
				}
			}

			// General

				// $id // will be defined (required)
				// $size // used only for modifying other parameters during button creation
				$disabled							= $disabled != '' ? $disabled : $this->meta_values( $id, array( 'field' => 'btnsx_disabled' ) );
				if( $disabled == '1' ){
					$disabled = ' btnsx-btn-disabled';
				}
				$embossed							= $embossed != '' ? $embossed : $this->meta_values( $id, array( 'field' => 'btnsx_embossed' ) );
				if( $embossed == '1' ){
					$embossed = ' btnsx-btn-embossed';
				}
				$full_width							= $full_width != '' ? $full_width : $this->meta_values( $id, array( 'field' => 'btnsx_full_width' ) );
				if( $full_width == '1' ){
					$full_width = ' btnsx-btn-block';
				}

				// link
				$link_type							= $link_type != '' ? $link_type : $this->meta_values( $id, array( 'field' => 'btnsx_link_type' ) );
				$link_target						= $link_target != '' ? $link_target : $this->meta_values( $id, array( 'field' => 'btnsx_link_target' ) );
				$link_menu_type	= $link_menu_type != '' ? $link_menu_type : $this->meta_values( $id, array( 'field' => 'btnsx_link_menu_type', 'value' => 'wordpress' ) );
				$link_menu_custom	= $link_menu_custom != '' ? $link_menu_custom : $this->meta_values( $id, array( 'field' => 'btnsx_link_menu_custom' ) );
				if( $link_target === 'new_window' ){
					$link_target = ' target="_blank"';
				}elseif( $link_target === 'same_window' ){
					$link_target = ' target="_self"';
				}
				$link_relationship					= $link_relationship != '' ? $link_relationship : $this->meta_values( $id, array( 'field' => 'btnsx_link_relationship' ) );
				if( $link_relationship != '' ){
					$link_relationship = ' rel="' . esc_attr( $link_relationship ) . '"';
				}
				$link_post							= $link_post != '' ? $link_post : $this->meta_values( $id, array( 'field' => 'btnsx_link_post' ) );
				$link_menu							= $link_menu != '' ? $link_menu : $this->meta_values( $id, array( 'field' => 'btnsx_link_menu' ) );
				$link_menu_display					= $link_menu_display != '' ? $link_menu_display : $this->meta_values( $id, array( 'field' => 'btnsx_link_menu_display' ) );
				$link								= $link != '' ? $link : $this->meta_values( $id, array( 'field' => 'btnsx_link' ) );
				$link_edd_id						= $link_edd_id != '' ? $link_edd_id : $this->meta_values( $id, array( 'field' => 'btnsx_link_edd_id' ) );
				$link_woocommerce_id				= $link_woocommerce_id != '' ? $link_woocommerce_id : $this->meta_values( $id, array( 'field' => 'btnsx_link_woocommerce_id' ) );
				$link_redirect_url					= $link_redirect_url != '' ? $link_redirect_url : $this->meta_values( $id, array( 'field' => 'btnsx_link_redirect_url' ) );
				$link_frame_width					= $link_frame_width != '' ? $link_frame_width : $this->meta_values( $id, array( 'field' => 'btnsx_link_frame_width' ) );
				$link_frame_height					= $link_frame_height != '' ? $link_frame_height : $this->meta_values( $id, array( 'field' => 'btnsx_link_frame_height' ) );

				$link_email					= $link_email != '' ? $link_email : $this->meta_values( $id, array( 'field' => 'btnsx_link_email' ) );
				$link_email_subject			= $link_email_subject != '' ? $link_email_subject : $this->meta_values( $id, array( 'field' => 'btnsx_link_email_subject' ) );
				$link_skype_id				= $link_skype_id != '' ? $link_skype_id : $this->meta_values( $id, array( 'field' => 'btnsx_link_skype_id' ) );
				$link_telephone				= $link_telephone != '' ? $link_telephone : $this->meta_values( $id, array( 'field' => 'btnsx_link_telephone' ) );
				$link_sms_content			= $link_sms_content != '' ? $link_sms_content : $this->meta_values( $id, array( 'field' => 'btnsx_link_sms_content' ) );
				$link_wistia_video_id		= $link_wistia_video_id != '' ? $link_wistia_video_id : $this->meta_values( $id, array( 'field' => 'btnsx_link_wistia_video_id' ) );

				$backtotop_class = '';
				$menu_wrap_begin = '';
				$menu_wrap_end = '';
			   	$menu = '';
			   	$menu_class = '';
			   	$menu_data_attribute = '';
			   	$share_thumb_id = '';
    			$share_thumb = '';
   				$share_title = '';
    			$share_link = '';
    			$frame_w = '';
    			$frame_h = '';
    			$share_whatsapp_link = '';

			   	if( is_singular() ){
				   	$share_thumb_id = get_post_thumbnail_id();
	    			$share_thumb = wp_get_attachment_image_src($share_thumb_id,'large', true);
	   				$share_title = get_the_title();
	    			$share_link = urlencode(get_the_permalink());
	    			$home_link = urlencode(get_home_url());
	    			$share_fb_link = esc_url('http://www.facebook.com/sharer/sharer.php?u='.$share_link.'&title='.$share_title);
	    			$share_tw_link = esc_url('http://twitter.com/intent/tweet?status='.$share_title.'+'.$share_link);
	    			$share_pin_link = esc_url('http://pinterest.com/pin/create/bookmarklet/?media='.$share_thumb[0].'&url='.$share_link.'&is_video=false&description='.$share_title);
	    			$share_gplus_link = esc_url('https://plus.google.com/share?url='.$share_link);
	    			$share_reddit_link = esc_url('http://www.reddit.com/submit?url='.$share_link.'&title='.$share_title);
	    			$share_delicious_link = esc_url('http://del.icio.us/post?url='.$share_link.'&title='.$share_title);
	    			$share_digg_link = esc_url('https://digg.com/submit?url='.$share_link.'&title='.$share_title);
	    			$share_stumble_link = esc_url('http://www.stumbleupon.com/submit?url='.$share_link.'&title='.$share_title);
	    			$share_linkedin_link = esc_url('http://www.linkedin.com/shareArticle?mini=true&url='.$share_link.'&title='.$share_title.'&source='.$home_link);
	    			// $share_slashdot_link = esc_url('http://slashdot.org/bookmark.pl?url='.$share_link.'&title='.$share_title);
	    			$share_tumblr_link = esc_url('http://www.tumblr.com/share?v=3&u='.$share_link.'&t='.$share_title);
	    			$share_google_bookmarks_link = esc_url('http://www.google.com/bookmarks/mark?op=edit&bkmk='.$share_link.'&title='.$share_title);
	    			$share_newsvine_link = esc_url('http://www.newsvine.com/_tools/seed&save?u='.$share_link.'&h='.$share_title);
	    			$share_evernote_link = esc_url('http://www.evernote.com/clip.action?url='.$share_link.'&title='.$share_title);
	    			$share_buffer_link = esc_url('https://buffer.com/add?url='.$share_link.'&title='.$share_title);
	    			$share_whatsapp_link = 'whatsapp://send?text='.esc_url($share_link);
	    		}

			   	switch ($link_type) {
			   		case 'back_to_top':
			   			$link = "javascript:void(0)";
		   				$backtotop_class = " btnsx-top";
			   			break;
			   		case 'menu':
			   			$link = 'javascript:void(0)';
			   			$menu_wrap_block = isset( $full_width ) && $full_width == ' btnsx-btn-block' ? ' btnsx-btn-group-block' : '';
						$menu_wrap_begin = '<div class="btnsx-btn-group' . esc_attr($menu_wrap_block) . '">';
				   		$menu_wrap_end = '</div>';
				   		$menu_class = ' btnsx-btn-default btnsx-dropdown-toggle';
				   		if( $link_menu_display === 'on_hover' ) {
				   			$menu_data_attribute = ' data-toggle-hover="btnsx-dropdown" aria-expanded="false"';
				   		} else {
				   			$menu_data_attribute = ' data-toggle="btnsx-dropdown" aria-expanded="false"';
				   		}
			   			break;
			   		case 'post':
			   			$permalink = get_permalink($link_post);
			   			if( $permalink ){
			   				$link = $permalink;
			   			} else {
			   				$link = $link_post;
			   			}
			   			break;
			   		case 'admin_page':
			   			$link = admin_url();
			   			break;
			   		case 'home_page':
			   			$link = site_url();
			   			break;
			   		case 'edd_checkout':
			   			$link = site_url() . '/checkout?edd_action=add_to_cart&download_id=' . $link_edd_id;
			   			break;
			   		case 'edd_straight_to_gateway':
			   			$link = site_url() . '/checkout?edd_action=straight_to_gateway&download_id=' . $link_edd_id;
			   			break;
			   		case 'woocommerce_add_to_cart':
			   			$link = get_permalink() . '?add-to-cart=' . $link_woocommerce_id;
			   			break;
			   		case 'woocommerce_add_to_cart_auto_id':
			   			global $product;
			   			$product_id = !is_null($product) ? $product->id : null;
			   			$link = get_permalink() . '?add-to-cart=' . $product_id;
			   			break;
			   		case 'login':
			   			$link = wp_login_url();
			   			break;
			   		case 'login_redirect_current_page':
			   			$link = wp_login_url( get_permalink() );
			   			break;
			   		case 'login_redirect_home_page':
			   			$link = wp_login_url( home_url() );
			   			break;
			   		case 'login_redirect_custom_page':
			   			$link = wp_login_url( site_url( $link_redirect_url ) );
			   			break;
			   		case 'logout':
			   			$link = wp_logout_url();
			   			break;
			   		case 'logout_redirect_current_page':
			   			$link = wp_logout_url( get_permalink() );
			   			break;
			   		case 'logout_redirect_home_page':
			   			$link = wp_logout_url( home_url() );
			   			break;
			   		case 'logout_redirect_custom_page':
			   			$link = wp_logout_url( site_url( $link_redirect_url ) );
			   			break;
			   		case 'lost_password':
			   			$link = wp_lostpassword_url();
			   			break;
			   		case 'lost_password_redirect_current_page':
			   			$link = wp_lostpassword_url( get_permalink() );
			   			break;
			   		case 'lost_password_redirect_home_page':
			   			$link = wp_lostpassword_url( home_url() );
			   			break;
			   		case 'lost_password_redirect_custom_page':
			   			$link = wp_lostpassword_url( site_url( $link_redirect_url ) );
			   			break;
			   		case 'previous_page':
			   			$link = 'javascript:void(0)';
			   			break;
			   		case 'register':
			   			$link = wp_registration_url();
			   			break;
			   		case 'url':
			   			$link = esc_url($link);
			   			break;
			   		case 'url_unescaped':
			   			$link = $link;
			   			break;
			   		case 'facebook_share':
			   			$link = $share_fb_link;
			   			break;
			   		case 'pinterest_share':
			   			$link = $share_pin_link;
			   			break;
			   		case 'twitter_share':
			   			$link = $share_tw_link;
			   			break;
			   		case 'google_share':
			   			$link = $share_gplus_link;
			   			break;
			   		case 'reddit_share':
			   			$link = $share_reddit_link;
			   			break;
			   		case 'delicious_share':
			   			$link = $share_delicious_link;
			   			break;
			   		case 'digg_share':
			   			$link = $share_digg_link;
			   			break;
			   		case 'stumbleupon_share':
			   			$link = $share_stumble_link;
			   			break;
			   		case 'linkedin_share':
			   			$link = $share_linkedin_link;
			   			break;
			   		// case 'slashdot_share':
			   		// 	$link = $share_slashdot_link;
			   		// 	break;
			   		case 'tumblr_share':
			   			$link = $share_tumblr_link;
			   			break;
			   		case 'google_bookmarks_share':
			   			$link = $share_google_bookmarks_link;
			   			break;
			   		case 'newsvine_share':
			   			$link = $share_newsvine_link;
			   			break;
			   		case 'evernote_share':
			   			$link = $share_evernote_link;
			   			break;
			   		case 'buffer_share':
			   			$link = $share_buffer_link;
			   			break;
			   		case 'mailto':
			   			$link = 'mailto:' . $link_email;
			   			if( $link_email_subject != '' ){
			   				$link = esc_url( $link . '?subject=' . $link_email_subject );
			   			}
			   			break;
			   		case 'skype_call':
			   			$link = 'skype:' . esc_attr($link_skype_id) . '?call';
			   			break;
			   		case 'skype_chat':
			   			$link = 'skype:' . esc_attr($link_skype_id) . '?chat';
			   			break;
			   		case 'skype_video_call':
			   			$link = 'skype:' . esc_attr($link_skype_id) . '?call&video=true';
			   			break;
			   		case 'sms':
			   			$link = 'sms:' . esc_attr($link_telephone);
			   			if( $link_sms_content != '' ){
			   				$link = $link . '?body=' . esc_attr($link_sms_content);
			   			}
			   			break;
			   		case 'tel':
			   			$link = 'tel:' . esc_attr($link_telephone);
			   			break;
			   		case 'whatsapp_share':
			   			$link = $share_whatsapp_link;
			   			break;
			   		case 'print':
			   			$link = 'javascript:window.print()';
			   			break;
			   		case 'previous_post':
						if( get_adjacent_post(false, '', false) ) { 
							$link = get_permalink( get_adjacent_post( false, '', false ) );
						} else { 
							$args = array(
								'post_type' => get_post_type( get_the_ID() ),
								'posts_per_page' => 1,
								'order' => 'ASC'
							);
							$last = new WP_Query($args);
							if ( $last->have_posts() ) {
    							while ( $last->have_posts() ){ 
    								$last->the_post();
						    		$link =	get_permalink();
    							}
    						}
						    wp_reset_query();
						}
			   			break;
			   		case 'next_post':
			   			if( get_adjacent_post( false, '', true ) ) { 
							$link = get_permalink( get_adjacent_post( false, '', true ) );
						} else { 
							$args = array(
								'post_type' => get_post_type( get_the_ID() ),
								'posts_per_page' => 1,
								'order' => 'DESC'
							);
							$first = new WP_Query($args);
							if ( $first->have_posts() ) {
    							while ( $first->have_posts() ){ 
    								$first->the_post();
						    		$link =	get_permalink();
    							}
    						}
						    wp_reset_query();
						}
			   			break;
			   		case 'wistia_popover':
			   			$link = 'javascript:void(0)';
			   		default:
			   			$link = 'javascript:void(0)';
			   			break;
			   	}

			   	// WooCommerce product variations
			   		if( $link_type == 'woocommerce_add_to_cart' || $link_type == 'woocommerce_add_to_cart_auto_id' ){
				   		global $product;
				   		if( is_object( $product ) ){
					   		if( is_single( $product->id ) ){
				   				add_filter( 'btnsx_output_button_attributes_filter', array( $this,'add_to_cart_attr' ), 10, 3 );
				   			} else {
				   				if( $link_type == 'woocommerce_add_to_cart' || $link_type == 'woocommerce_add_to_cart_auto_id' ){
				   					$class	= $class != '' ? ' ' . 'ajax_add_to_cart' : 'ajax_add_to_cart';
				   				}
				   			}
				   		}
				   	}

			   	// Whatsapp Share
			   		if( $link_type == 'whatsapp_share' ){
			   			$whatsapp_attribute = 'data-action="share/whatsapp/share"';
			   		}else{
			   			$whatsapp_attribute = '';
			   		}

			   	// Iframe
			   		if( $link_frame_width ){
			   			$frame_w = ','.$link_frame_width;
			   		}
			   		if( $link_frame_height ){
			   			$frame_h = ','.$link_frame_height;
			   		}
			   		if( in_array( $link_type, array( 'facebook_share', 'pinterest_share', 'twitter_share', 'google_share', 'reddit_share', 'delicious_share', 'digg_share', 'stumbleupon_share', 'linkedin_share', 'tumblr_share', 'google_bookmarks_share', 'newsvine_share', 'evernote_share', 'buffer_share' ) ) ){
				   		$link_target == 'iframe';
						$on_click_content .= "btnsx_share_iframe('".$link."'".$frame_w.$frame_h.");";
						$link = 'javascript:void(0)';
					} else {
						if( $link_target == 'iframe' ) {
							$link_target = 'iframe';
							$on_click_content .= "btnsx_share_iframe('".$link."'".$frame_w.$frame_h.");";
							$link = 'javascript:void(0)';
						}
					}
					// var_dump($link_target);

				// Dropdown Menu
					if( $link_type == 'menu' && $link_menu_type == 'wordpress' ){
			   			$menu = $this->dropdown_menu( array( 'menu' => $link_menu, 'menu_id' => 'btnsx-' . $id . '-dropdown', 'menu_class' => 'btnsx-dropdown-menu' ) );
			   		} elseif( $link_type == 'menu' && $link_menu_type == 'custom' ){
			   			$menu = '<ul id="btnsx-' . $id . '-dropdown" class="btnsx-dropdown-menu">';
			   			if(is_array($link_menu_custom)){
			   				foreach ($link_menu_custom as $key => $item) {
			   					if( $key == 'url' ){
				   					foreach (maybe_unserialize($item) as $k => $url) {
				   						$label = maybe_unserialize($link_menu_custom['label']);
				   						$label = $label[$k];
				   						if( !$label ){
				   							$label = __('Insert Label','btnsx');
				   						}
				   						if( $link_target == 'iframe' ){
				   							$target = '';
				   							$frame_url = esc_url($url);
				   							$url = 'javascript:void(0)';
				   							$menu_li_onclick = 'onClick="btnsx_share_iframe(\''.$frame_url.'\''.$frame_w.$frame_h.');"';
				   						} else {
				   							$target = $link_target;
				   							$frame_url = '';
				   							$url = esc_url($url);
				   							$menu_li_onclick = '';
				   						}
				   						$menu .= '<li class="menu-item"><a '.$target.' href="'.$url.'"'.$menu_li_onclick.'>'.esc_html($label).'</a></li>';
				   					}
				   				}
			   				}
			   			}
			   			$menu .= '</ul>';
			   		}

				// Previous Page JS
					if( $link_type == 'previous_page' ) {
						$on_click_content .= 'window.history.go(-1);return false;';
					}

				// Custom Class
					$class				= $class != '' ? ' ' . $class : ' ' . $this->meta_values( $id, array( 'field' => 'btnsx_class' ) );

			// Primary Text

				// text
				$text = $text != '' ? $text : apply_filters( 'wpml_translate_single_string', $this->meta_values( $id, array( 'field' => 'btnsx_text' ) ), 'btnsx-'.$id, 'Primary Text' );
				$text_font_family = $text_font_family != '' ? $text_font_family : $this->meta_values( $id, array( 'field' => 'btnsx_text_font', 'field2' => 'family' ) );
				if( $text_font_family != '' ){
					$text_font_family = ' data-font-primary="' . esc_attr( $text_font_family ) . '"';
				}
				$text_font_weight					= $text_font_weight != '' ? $text_font_weight : $this->meta_values( $id, array( 'field' => 'btnsx_text_font', 'field2' => 'weight' ) );
				if( $text_font_weight != '' ){
					$text_font_weight = ' data-font-primary-weight="' . esc_attr( $text_font_weight ) . '"';
				}

			// Secondary Text

				// Filter - Button Secondary Text Class
				$btn_secondary_text_class_filter = apply_filters( 'btnsx_output_button_secondary_text_class_filter', array(), $options, $atts );
				$btn_secondary_text_class_filter_as_string = '';
				foreach ( $btn_secondary_text_class_filter as $key => $value ) {
					$btn_secondary_text_class_filter_as_string .= implode( ' ', $value );
				}

				// text
				$text_secondary						= $text_secondary != '' ? $text_secondary : $this->meta_values( $id, array( 'field' => 'btnsx_text_secondary' ) );
				if( $text_secondary != '' ){
					$text_secondary = '<span class="btnsx-text-secondary ' . $btn_secondary_text_class_filter_as_string . '">' . $text_secondary . '</span>';
				}
				$text_secondary_font_family			= $text_secondary_font_family != '' ? $text_secondary_font_family : $this->meta_values( $id, array( 'field' => 'btnsx_text_secondary_font', 'field2' => 'family' ) );
				if( $text_secondary_font_family != '' ){
					$text_secondary_font_family = ' data-font-secondary="' . esc_attr( $text_secondary_font_family ) . '"';
				}

			// Icon

				// Filter - Button Icon Class
					$btn_icon_class_filter = apply_filters( 'btnsx_output_button_icon_class_filter', array(), $options, $atts );
					$btn_icon_class_filter_as_string = '';
					foreach ( $btn_icon_class_filter as $key => $value ) {
						$btn_icon_class_filter_as_string .= implode( ' ', $value );
					}

				// main
				$icon								= $icon != '' ? $icon : $this->meta_values( $id, array( 'field' => 'btnsx_icon' ) );
				$icon_alignment						= $icon_alignment != '' ? $icon_alignment : $this->meta_values( $id, array( 'field' => 'btnsx_icon_alignment' ) );
				$icon_right 						= '';
				$icon_pull = '';

				// image
				$icon_image							= $icon_image != '' ? $icon_image : $this->meta_values( $id, array( 'field' => 'btnsx_icon_image' ) );
				$icon_image_hover					= $icon_image_hover != '' ? $icon_image_hover : $this->meta_values( $id, array( 'field' => 'btnsx_icon_image_hover' ) );
				if( $icon_image_hover != '' ){
					$icon_image_hover = ' data-hover="' . esc_url( $icon_image_hover ) . '"';
				}
				if( $icon_image != '' ) {
					$icon_image = '<img class="btnsx-icon-img" src="' . esc_url( $icon_image ) . '" '. $icon_image_hover .' />';
				}

				if( $icon != '' || $icon_image != '' ) {
					$icon = '<i class="btnsx-icon ' . esc_attr( $icon ) . esc_attr( $btn_icon_class_filter_as_string ) . '">'. $icon_image .'</i>';
				}

				if( $icon_alignment == 'right' ){
					$icon_right = $icon;
					$icon = '';
				}

				// animation
				$icon_animation						= $icon_animation != '' ? $icon_animation : $this->meta_values( $id, array( 'field' => 'btnsx_icon_animation' ) );
				if(	$icon_animation == 'hover' || $icon_animation == 'click' ){
					$icon_animation = ' data-animation="' . $icon_animation . '"';
				} else {
	                $icon_animation = '';
	            }
				$icon_animation_type				= $icon_animation_type != '' ? $icon_animation_type : $this->meta_values( $id, array( 'field' => 'btnsx_icon_animation_type' ) );
				if( $icon_animation_type !== '0' ){
					$icon_animation_type = ' data-animation-type="' . $icon_animation_type . '"';
				}else{
					$icon_animation_type = '';
				}

				// divider
				$icon_divider_size						= $icon_divider_size != '' ? $icon_divider_size : $this->meta_values( $id, array( 'field' => 'btnsx_icon_divider', 'field2' => 'size' ) );
				if( $icon_divider_size != '' ){
					$icon_divider = '<span class="btnsx-divider"></span>';
				} else {
					$icon_divider = '';
				}

			// Animation
				$animation_hover							= $animation_hover != '' ? $animation_hover : $this->meta_values( $id, array( 'field' => 'btnsx_animation_hover' ) );
				if( !empty( $animation_hover ) ){
					$animation_hover = ' btnsx-' . $animation_hover;
				} else {
					$animation_hover = '';
				}
				$animation_reveal							= $animation_reveal != '' ? $animation_reveal : $this->meta_values( $id, array( 'field' => 'btnsx_animation_reveal' ) );

				if( !empty( $animation_reveal ) ){
					$animation_reveal = ' btnsx-reveal btnsx-animation-' . $animation_reveal;
				} else {
					$animation_reveal = '';
				}

			// Dropdown
				$dropdown_font_family = $dropdown_font_family != '' ? $dropdown_font_family : $this->meta_values( $id, array( 'field' => 'btnsx_link_dropdown_font', 'field2' => 'family' ) );
				if( $dropdown_font_family != '' ){
					$dropdown_font_family = ' data-font-dropdown="' . esc_attr( $dropdown_font_family ) . '"';
				}
				$dropdown_font_weight = $dropdown_font_weight != '' ? $dropdown_font_weight : $this->meta_values( $id, array( 'field' => 'btnsx_link_dropdown_font', 'field2' => 'weight' ) );
				if( $dropdown_font_weight != '' ){
					$dropdown_font_weight = ' data-font-dropdown-weight="' . esc_attr( $dropdown_font_weight ) . '"';
				}

			// Miscellaneous
				$container								= $container != '' ? $container : $this->meta_values( $id, array( 'field' => 'btnsx_container' ) );
				$wrap_center							= $wrap_center != '' ? $wrap_center : $this->meta_values( $id, array( 'field' => 'btnsx_wrap_center' ) );

				if( $container == '1' ){
					$container_id = 'btnsx-' . $id;
			   		$container_before = apply_filters( 'btnsx_container_before', '<div id="' . $container_id . '-container" class="btnsx-btn-container">', $container_id );
			   		$container_after = apply_filters( 'btnsx_container_after', '</div>', $container_id );
			   	} else {
			   		$container_id = '';
			   		$container_before = '';
			   		$container_after = '';
			   	}

			   	if( $wrap_center == '1' ){
			   		$wrap_id = 'btnsx-' . $id;
			   		$wrap_before = apply_filters( 'btnsx_wrap_before', '<div id="' . $wrap_id . '-wrap" class="btnsx-wrap-center" align="center">', $wrap_id );
			   		$wrap_after = apply_filters( 'btnsx_wrap_after', '</div>', $wrap_id );
			   	} else {
			   		$wrap_id = '';
			   		$wrap_before = '';
			   		$wrap_after = '';
			   	}

			   	if( $link_target === 'iframe' ){
					$link_target = '';
				}

			// JS
				$js					= $js != '' ? $js : $this->meta_values( $id, array( 'field' => 'btnsx_js' ) );
				$js					= $js != '' ? '<script type="text/javascript">'.$js.'</script>' : '';

			// Custom CSS
				$css				= $css != '' ? $css : $this->meta_values( $id, array( 'field' => 'btnsx_css' ) );
				$css 				= str_replace('btnsx-preview-btn', 'btnsx-'.$id, $css);
				$css				= $css != '' ? '<style type="text/css">'.$css.'</style>' : '';

			// Inline CSS
				global $btnsx_settings;
				if( isset( $btnsx_settings['css'] ) && $btnsx_settings['css'] === 'inline' || $css_inline === '1' ){
					$css = '<style type="text/css">' . $this->generate_css( $id, false ) . '</style>' . $css;
				}

			// Click Attribute
				$on_click_attr = '';
				// Filter - On Click
				$btn_on_click = apply_filters( 'btnsx_output_button_on_click_filter', array(), $options, $atts );
				foreach ( $btn_on_click as $key => $value ) {
					$on_click_content .= implode( ' ', $value );
				}
				if( $on_click_content != '' ){
					if( $link_type != 'menu' ){
						$on_click_attr = ' onClick="' . $on_click_content . '"';
					}
				}

			// Background Hover Image load delay fix
				$background_image_hover = $background_image_hover != '' ? $background_image_hover : $this->meta_values( $id, array( 'field' => 'btnsx_background_image_hover' ) );
				if($background_image_hover){
					$bg_hover_img_fix = '<span style="background-image:url('.$background_image_hover.');width:0;height:0;display:none;"></span>';
				}else{
					$bg_hover_img_fix = '';
				}

				if( $link_type == 'wistia_popover' ){
					$wistia_start = '<script src="//fast.wistia.com/embed/medias/e1ncncjriy.jsonp" async></script><script src="//fast.wistia.com/assets/external/E-v1.js" async></script><span class="wistia_embed wistia_async_'.$link_wistia_video_id.' popover=true popoverContent=link" style="display:inline">';
					$wistia_end = '</span>';
				} else {
					$wistia_start = '';
					$wistia_end = '';
				}

			// Filters
				// Filter - Before Button Start
					$btn_before_filter = apply_filters( 'btnsx_output_button_before_filter', array(), $options, $atts );
					$btn_before_filter_as_string = '';
					foreach ( $btn_before_filter as $key => $value ) {
						$btn_before_filter_as_string .= implode( ' ', $value );
					}

				// Filter - After Button End
					$btn_after_filter = apply_filters( 'btnsx_output_button_after_filter', array(), $options, $atts );
					$btn_after_filter_as_string = '';
					foreach ( $btn_after_filter as $key => $value ) {
						$btn_after_filter_as_string .= implode( ' ', $value );
					}

				// Filter - Button Attributes
					$btn_atts_filter = apply_filters( 'btnsx_output_button_attributes_filter', array(), $options, $atts );
					$btn_atts_filter_as_string = '';
					foreach ( $btn_atts_filter as $key => $value ) {
						$btn_atts_filter_as_string .= implode( ' ', $value );
					}

				// Filter - Button Class
					$btn_class_filter = apply_filters( 'btnsx_output_button_class_filter', array(), $options, $atts );
					$btn_class_filter_as_string = '';
					foreach ( $btn_class_filter as $key => $value ) {
						$btn_class_filter_as_string .= implode( ' ', $value );
					}

				// Filter - Button Primary Text Class
					$btn_text_class_filter = apply_filters( 'btnsx_output_button_text_class_filter', array(), $options, $atts );
					$btn_text_class_filter_as_string = '';
					foreach ( $btn_text_class_filter as $key => $value ) {
						$btn_text_class_filter_as_string .= implode( ' ', $value );
					}

				// Filter - Button link
					$link = apply_filters( 'btnsx_output_button_link', $link, $atts );
				// Filter - Button link relationship
					$link_relationship = apply_filters( 'btnsx_output_button_link_relationship', $link_relationship, $atts );

return do_shortcode(
'
<!-- Buttons X - Start -->
' . $js . $css . $wistia_start . $wrap_before . $container_before . $menu_wrap_begin . $btn_before_filter_as_string . '
<a href="' . $link . '" id="btnsx-' . $id . '"' . $link_target . $link_relationship . ' class="btnsx-btn' . esc_attr( $class ) . esc_attr( $disabled ) . esc_attr( $embossed ) . esc_attr( $full_width ) . esc_attr( $backtotop_class ) . esc_attr( $menu_class ) . esc_attr( $animation_reveal ) . esc_attr( $animation_hover ) . esc_attr( $btn_class_filter_as_string ) . '" ' . $menu_data_attribute . $text_font_family . $text_font_weight . $text_secondary_font_family . $dropdown_font_family . $dropdown_font_weight . $icon_animation . $icon_animation_type . $on_click_attr . $btn_atts_filter_as_string . $whatsapp_attribute . '>
	' . $icon_divider . $icon . '<span class="btnsx-text-primary ' . $btn_text_class_filter_as_string . '">' . $text . '</span>' . $icon_right . $text_secondary
	. do_shortcode( $content ) . $bg_hover_img_fix .
'</a>
' . $btn_after_filter_as_string . $menu . $menu_wrap_end . $container_after . $wrap_after  . $wistia_end . '
<!-- Buttons X - End -->
');
	    }

	} // Main Class

}

/**
 *  Kicking this off
 */

$btn = new Btnsx();
$btn->init();
